use core:lang;
use lang:bs;
use lang:bs:macro;

Expr patternExpr(Block block, Expr param) {
	// Note if-else is to ensure that ()? are handled correctly!
	var e = pattern(block) {
		Int z = 1;
		if (10 > 20) {
			z;
		} else {
			10 + $param * ${NumLiteral(SrcPos(), 20)};
		}
	};

	e;
}

Int testPattern() {
	p!8!p;
}

Int testPatternNames() {
	// Make sure the correct 'z' is used. There is a 'z' inside the pattern as well.
	Int z = 100;
	p!z!p;
}

Expr patternSpliceExpr(Block block, Expr[] params) {
	var e = pattern(block) {
		spliceTest(1, @params);
	};

	e;
}

Int spliceTest(Int a, Int b) {
	a + b + 20;
}

Int spliceTest(Int a, Int b, Int c) {
	a + b + c;
}

Int testPatternSplice1() {
	s!2!s;
}

Int testPatternSplice2() {
	s!2,3!s;
}
