9.3 Wiele Żywych Pętli

# Wiele Żywych Pętli

Przyjrzyjmy się natępującej żywej pętli: 

```
live_loop :foo do
  play 50
  sleep 1
end
```

Być może zastanawiałeś się dlaczego konieczna jest nazwa `:foo`. Nazwa 
ta jest ważna ponieważ oznacza, że ta konkrenta żywa pętla jest inna od wszystkich 
innych żywych pętli. 

*W tym samym czasie nie mogą być uruchomione dwie żywe pętle o tej samej nazwie.* 

Oznacza to, że jeśli potrzebujemy kilku jednocześnie kręcących się żywych pętli, 
to po prostu musimy nadać im inne nazwy: 

```
live_loop :foo do
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end

live_loop :bar do
  sample :bd_haus
  sleep 0.5
end
```

Możesz teraz aktualizować i zmieniać każdą z żywych pętli niezależnie 
i wszystio będzie po prostu działać. 

## Synchronizacja Żywych Pętli

Jedną z rzeczy, które być może już zauważyłeś to to, że żywe pętle 
działają automatycznie z mechanizmem punktów cue dla wątków, które 
poznaliśmy już wcześniej. Za każdym razem, gdy żywa pętla wykona pętlę, 
generuje nowe zdarzenie `cue` nadając mu nazwę taką samą jaką nadaliśmy 
żywej pętli. Możemy więc sychroznizować się z wykorzystaniem funkcji 
`sync` na każdym zdarzeniu `cue` aby upewnić się, że nasze pętle 
są zsynchronizowane bez konieczności zatrzymywania czegokolwiek.

Spójrzmy na poniższy kod, który został źle zsynchronizowany:

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.4
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

Zobaczmy czy możemy naprawić chronometraż (timing) bez zatrzymywania. Najpierw, 
naprawmy pętlę `:foo` tak, aby sprawić, że wartość parametru sleep będzie 
współczynnikiem liczby 1 - coś jak `0.5` powinno być ok: 

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

To jeszcze nie koniec - powinieneś zauważyć, że uderzenia nie do końca 
ustawiają się odpowiednio. Dzieje się tak, ponieważ pętle *nie są 
synchronizowane*. Spróbujmy to naprawić przez ich synchronizację:

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sync :foo
  sample :bd_haus
  sleep 1
end
```

Łał, teraz wszystko perfekcyjnie w czas - i to wszystko bez zatrzymywania.

A teraz, nie zatrzymuj się i koduj na żywo z wykorzystaniem żywych pętli!
