2.3 シンセの切り替え

# シンセの切り替え

これまで、ビープ音を鳴らして楽しんできました。けれども、
もしかするとあなたはこのベーシックなビープ音に退屈し始めているかも知れません。
これがSonic piが提供してくれるサウンドの全てなのでしょうか？もちろん、ビープ音だけではなくて、
もっと他にもたくさんのライブコーディングがありますよね？はい、あります。
この章ではSonic Piが作り出すエキサイティングな音の領域へと探検していきましょう。

## シンセ

Sonic Piは、シンセサイザーの略であるシンセと呼ばれる楽器の機能を持っています。
サンプルがすでに録音された音であるのに対して、シンセはあなたがそれをコントロールすることに応じて
新しいサウンドを生み出すことができます（このチュートリアルの後半でみていきます）。Sonic Piのシンセは、
パワフルで表現力に富んでいて、探索しながら演奏したり、楽しめるはずです。
最初に、ひとまずここでシンセを使うために、選び方を学んでみましょう。

## 酔っ払いのsawとprophet

面白い音は、*ノコギリ（saw）波*です。試してみましょう。

```
use_synth :saw
play 38
sleep 0.25
play 50
sleep 0.25
play 62
sleep 0.25
```

他の音*prophet*を試してみましょう。

```
use_synth :prophet
play 38
sleep 0.25
play 50
sleep 0.25
play 62
sleep 0.25

```
2つを一緒にしたらどうでしょう。一方のあとに、もう一方を。
```

use_synth :saw
play 38
sleep 0.25
play 50
sleep 0.25
use_synth :prophet
play 57
sleep 0.25

```

では同時に。

```
use_synth :tb303
play 38
sleep 0.25
use_synth :dsaw
play 50
sleep 0.25
use_synth :prophet
play 57
sleep 0.25
```

`use_synth`コマンドは、 下の`play`にだけ影響していることに注意してください。
大きなスイッチのようなものだと考えてください。指定したどんなシンセでも、
新しい`play`へ命令として演奏されます。`use_synth`で新しいシンセにスイッチすることができます。

## シンセを見つける

演奏するために Sonic Piがどんなシンセを備えているかを見るには、左端のメニュー（効果 の上）にあるシンセオプションを見てください。20以上が用意されています。これらは、わたしのお気に入りの数種類です。

* `:prophet`
* `:dsaw`
* `:fm`
* `:tb303`
* `:pulse`

*音楽の中でシンセを切り替えて*遊んでみてください。音楽の異なるセクションに違うシンセを使うように、
シンセを組み合わせて新しい音を作って楽しんでください。