5.1 Blocs

# Blocs

Une structure que vous verrez souvant dans Sonic Pi est le bloc. Les 
blocs vous permettent de faire des choses utiles avec de grands 
morceaux de code. Par exemple, avec les paramètres des synthés et des 
échantillons, nous sommes capables de changer sur une seule ligne 
quelque chose qui s'est passé. Cependant, nous souhaitons quelquefois
faire quelque chose de significatif sur un certain nombre de 
lignes de code. Par exemple, nous souhaiterions les faire boucler, leur 
ajouter de la réverbération, les exécuter seulement une fois sur 
5, etc. Considérez le code suivant :

```
play 50
sleep 0.5
sample :elec_plip
sleep 0.5
play 62
```

Pour faire quelque chose avec un morceau de code, nous devons dire à 
Sonic Pi où *commence* le bloc et où il *finit*. Nous utilisons `do` 
pour le début et `end` pour la fin. Par exemple :

```
do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Toutefois, ce n'est pas encore complet et ne fonctionnera pas 
(essayez-le et vous obtiendrez une erreur) puique nous n'avons pas dit 
à Sonic Pi ce que nous voulions faire avec ce *bloc do/end*. On le dit 
à Sonic Pi en écrivant du code spécial avant le `do`. Nous verrons un 
certain nombre de ces bouts de code spéciaux plus tard dans ce tutoriel. 
Pour l'instant, il est important de savoir que d'encadrer votre code entre 
`do` et `end` dit à Sonic Pi que vous voulez faire quelque chose de 
spécial avec ce morceau de code.
