9.4 チック

# チック

ライブコーディングでリングをループしていて、気が付くとたくさんのことをしていたことはないでしょうか。
例えば、リングにメロディーの音符を入れたり、リズムのスリープ、
コード進行や音色のバリエーションを入れたり等々。

## リングのチック

Sonic Piは`live_loop`内でリングと共に使える*とても*手軽なツールを提供しています。
それはチックシステムと呼ばれ、*tick through rings（リングをチックタックと進める）*
機能を提供しています。次の例を見てください。

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end
```

ここでは、E3マイナーペンタトニックのスケールを作成し、各要素をチックしています。これは`.tick`を
スケール宣言の末尾に追加することによって実現されています。このチックはライブループ内で局所的であるため、
個々のライブループは独立したチックを持つことができます。

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end

live_loop :arp2 do
  use_synth :dsaw
  play (scale :e2, :minor_pentatonic, num_octaves: 3).tick, release: 0.25
  sleep 0.25
end
```

## 標準関数としてのチック

`tick`はまた標準関数としても呼ぶことができ、その値はインデックスとして使うことができます。

```
live_loop :arp do
  idx = tick
  play (scale :e3, :minor_pentatonic)[idx], release: 0.1
  sleep 0.125
end
```

しかし、この場合は`.tick`を呼ぶほうが良いでしょう。`tick`関数の用途は、
チックの値で手の込んだことをしたかったり、リングのインデックス以外のことにチックの値を使いたかったりする場合です。

## ルック

チックの魅力的なところはそれが新しいインデックス（もしくはそのインデックスにあるリングの値）
を返すだけでなく、次にチックを呼んだときに必ず次の値を返すことを保証していることでしょう。
`tick`が色んな形でこのような動作をしていることをこのドキュメントの例で見てみてください。
しかし、ここでチックの現在の値を見たいだけで値を*増加させたくない*の場合もあることを指摘することは重要でしょう。
これは`look`関数により実現可能です。`look`を標準関数として呼んだり、リングの後ろに`.look`を付けたりできます。

## チックの名前付け

最後に、1つのライブループに複数のチックが必要になることがあるかも
しれません。これはチックに名前を付けることで実現できます。

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick(:foo), release: 0.1
  sleep (ring 0.125, 0.25).tick(:bar)
end
```

ここでは2つのチックを使っていて、1つは音符用に、1つはスリープ時間用にしています。
これらのチックは同じライブループにあるので、別々にしておくためにユニークな名前を与えています。
これはちょうど`live_loop`に名前を付ける（`:`から始まるシンボル名を渡すだけ）のと同じことです。
上の例では1つは`:foo`でチックを呼び出し、もう1つは`:bar`で呼び出しています。
また、これらの値を`look`したい場合には、チックの名前を`look`に渡す必要があります。

## 複雑にしすぎないように

チックシステムの能力のほどんどは、最初のうちは役に立たないでしょう。
このセクションの全ての内容を学習しようとしないでください。
一つのリングでチックすることだけに集中するとよいでしょう。
そうすることで、`live_loop`でリングをチックする簡単さや楽しみを得ることができるでしょう。

`tick`のドキュメントには役に立つ例がたくさんあるので、それを見て楽しくチックしてみましょう！
