/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef AGS_SHARED_AC_COMMON_H
#define AGS_SHARED_AC_COMMON_H

#include "ags/shared/util/string.h"

namespace AGS3 {

// These are the project-dependent functions, they are defined both in Engine.App and AGS.Native.
void quit(const AGS::Shared::String &str);
void quit(const char *);
void quitprintf(const char *fmt, ...);
void update_polled_stuff_if_runtime();
void set_our_eip(int eip);
int  get_our_eip();

extern const char *game_file_sig;

// archive attributes to search for - al_findfirst breaks with 0
#define FA_SEARCH -1

} // namespace AGS3

#endif
