/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CamSetDlg.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/04/17
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __CAMSETDLG_H__
#define __CAMSETDLG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

struct _CAM_SET_DLG
{
	gint value;
	gint toggle_frag;

	gint AbsInc;				// 0:ABS   1:INC
	gint Modal;					// 0:Modal ON   1:Modal OFF
	gint RIJ;					// 0:R   1:IJ
	gint Heel;					// 0:Endmill   1:heel G03+   2:heel G02+
	gchar *start_str;
	gchar *end_str;

	/**/
	GtkWidget *abs_check;
	GtkWidget *inc_check;

	GtkWidget *r_check;
	GtkWidget *ij_check;

	GtkWidget *modal_off_check;
	GtkWidget *modal_on_check;

	GtkWidget *start_text;
	GtkWidget *end_text;

	GtkWidget *parent;
	GtkWidget *dialog;
};
typedef struct _CAM_SET_DLG CAM_SET_DLG;



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _CAMSETDLG_
#define   GLOBAL
/* 初期値設定 */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* 初期値設定の代入部分を無くす */
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _CAMSETDLG_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */

/* CAM 設定 */
gint CamSetDialog(CAM_SET_DLG *cam_set_dlg);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __CAMSETDLG_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CamSetDlg.h
 * ====================================================================
 */
