use thiserror::Error;

/// Errors that can be generated by niffler
#[allow(clippy::upper_case_acronyms)]
#[derive(Debug, Error)]
pub enum Error {
    /// This feature is disabled, you can enable it in cargo dependencies sections.
    #[error("Feature disabled, enabled it during compilation")]
    FeatureDisabled,

    /// This file is shorter than five bytes, it's probably not a compression file or corrupted.
    #[error("File is too short, less than five bytes")]
    FileTooShort,

    #[error("I/O error")]
    IOError(#[from] std::io::Error),
}
