/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// Match : GeoCoding match
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Match {
    /// location type
    #[serde(rename = "type")]
    pub r#type: Type,
    /// list of non-overlapping tokens that were matched
    #[serde(rename = "tokens")]
    pub tokens: Vec<Vec<f64>>,
    /// name of the location (transit stop / PoI / address)
    #[serde(rename = "name")]
    pub name: String,
    /// unique ID of the location
    #[serde(rename = "id")]
    pub id: String,
    /// latitude
    #[serde(rename = "lat")]
    pub lat: f64,
    /// longitude
    #[serde(rename = "lon")]
    pub lon: f64,
    /// level according to OpenStreetMap (at the moment only for public transport) 
    #[serde(rename = "level", skip_serializing_if = "Option::is_none")]
    pub level: Option<f64>,
    /// street name
    #[serde(rename = "street", skip_serializing_if = "Option::is_none")]
    pub street: Option<String>,
    /// house number
    #[serde(rename = "houseNumber", skip_serializing_if = "Option::is_none")]
    pub house_number: Option<String>,
    /// zip code
    #[serde(rename = "zip", skip_serializing_if = "Option::is_none")]
    pub zip: Option<String>,
    /// list of areas
    #[serde(rename = "areas")]
    pub areas: Vec<models::Area>,
    /// score according to the internal scoring system (the scoring algorithm might change in the future)
    #[serde(rename = "score")]
    pub score: f64,
}

impl Match {
    /// GeoCoding match
    pub fn new(r#type: Type, tokens: Vec<Vec<f64>>, name: String, id: String, lat: f64, lon: f64, areas: Vec<models::Area>, score: f64) -> Match {
        Match {
            r#type,
            tokens,
            name,
            id,
            lat,
            lon,
            level: None,
            street: None,
            house_number: None,
            zip: None,
            areas,
            score,
        }
    }
}
/// location type
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Type {
    #[serde(rename = "ADDRESS")]
    Address,
    #[serde(rename = "PLACE")]
    Place,
    #[serde(rename = "STOP")]
    Stop,
}

impl Default for Type {
    fn default() -> Type {
        Self::Address
    }
}

