//! Precalculated large powers for 32-bit limbs.

// PRIME (EXCEPT 2)

/// Large powers (&[u32]) for base5 operations.
const POW5_1: [u32; 1] = [5];
const POW5_2: [u32; 1] = [25];
const POW5_3: [u32; 1] = [625];
const POW5_4: [u32; 1] = [390625];
const POW5_5: [u32; 2] = [2264035265, 35];
const POW5_6: [u32; 3] = [2242703233, 762134875, 1262];
const POW5_7: [u32; 5] = [3211403009, 1849224548, 3668416493, 3913284084, 1593091];
const POW5_8: [u32; 10] = [781532673, 64985353, 253049085, 594863151, 3553621484, 3288652808, 3167596762, 2788392729, 3911132675, 590];
const POW5_9: [u32; 19] = [2553183233, 3201533787, 3638140786, 303378311, 1809731782, 3477761648, 3583367183, 649228654, 2915460784, 487929380, 1011012442, 1677677582, 3428152256, 1710878487, 1438394610, 2161952759, 4100910556, 1608314830, 349175];
const POW5_10: [u32; 38] = [4234999809, 2012377703, 2408924892, 1570150255, 3090844311, 3273530073, 1187251475, 2498123591, 3364452033, 1148564857, 687371067, 2854068671, 1883165473, 505794538, 2988060450, 3159489326, 2531348317, 3215191468, 849106862, 3892080979, 3288073877, 2242451748, 4183778142, 2995818208, 2477501924, 325481258, 2487842652, 1774082830, 1933815724, 2962865281, 1168579910, 2724829000, 2360374019, 2315984659, 2360052375, 3251779801, 1664357844, 28];
const POW5_11: [u32; 75] = [689565697, 4116392818, 1853628763, 516071302, 2568769159, 365238920, 336250165, 1283268122, 3425490969, 248595470, 2305176814, 2111925499, 507770399, 2681111421, 589114268, 591287751, 1708941527, 4098957707, 475844916, 3378731398, 2452339615, 2817037361, 2678008327, 1656645978, 2383430340, 73103988, 448667107, 2329420453, 3124020241, 3625235717, 3208634035, 2412059158, 2981664444, 4117622508, 838560765, 3069470027, 270153238, 1802868219, 3692709886, 2161737865, 2159912357, 2585798786, 837488486, 4237238160, 2540319504, 3798629246, 3748148874, 1021550776, 2386715342, 1973637538, 1823520457, 1146713475, 833971519, 3277251466, 905620390, 26278816, 2680483154, 2294040859, 373297482, 5996609, 4109575006, 512575049, 917036550, 1942311753, 2816916778, 3248920332, 1192784020, 3537586671, 2456567643, 2925660628, 759380297, 888447942, 3559939476, 3654687237, 805];
const POW5_12: [u32; 149] = [322166785, 3809044581, 2994556223, 1239584207, 3962455841, 4001882964, 3053876612, 915114683, 2783289745, 785739093, 4253185907, 3931164994, 1370983858, 2553556126, 3360742076, 2255410929, 422849554, 2457422215, 3539495362, 1720790602, 1908931983, 1470596141, 592794347, 4219465164, 4085652704, 941661409, 2534650953, 885063988, 2355909854, 2812815516, 767256131, 3821757683, 2155151105, 3817418473, 281116564, 2834395026, 2821201622, 2524625843, 1511330880, 2572352493, 330571332, 2951088579, 2730271766, 4044456479, 4212286644, 2444937588, 3603420843, 2387148597, 1142537539, 3299235429, 1751012624, 861228086, 2873722519, 230498814, 1023297821, 2553128038, 3421129895, 2651917435, 2042981258, 1606787143, 2228751918, 447345732, 1930371132, 1784132011, 3612538790, 2275925090, 2487567871, 1080427616, 2009179183, 3383506781, 3899054063, 1950782960, 2168622213, 2717674390, 3616636027, 2079341593, 1530129217, 1461057425, 2406264415, 3674671357, 2972036238, 2019354295, 1455849819, 1866918619, 1324269294, 424891864, 2722422332, 2641594816, 1400249021, 3482963993, 3734946379, 225889849, 1891545473, 777383150, 3589824633, 4117601611, 4220028667, 334453379, 1083130821, 1060342180, 4208163139, 1489826908, 4163762246, 1096580926, 689301528, 2336054516, 1782865703, 4175148410, 3398369392, 2329412588, 3001580596, 59740741, 3202189932, 3351895776, 246185302, 718535188, 3772647488, 4151666556, 4055698133, 2461934110, 2281316281, 3466396836, 3536023465, 1064267812, 2955456354, 2423805422, 3627960790, 1325057500, 3876919979, 2009959531, 175455101, 184092852, 2358785571, 3842977831, 2485266289, 487121622, 4159252710, 4075707558, 459389244, 300652075, 2521346588, 3458976673, 888631636, 2076098096, 3844514585, 2363697580, 3729421522, 3051115477, 649395];
const POW5_13: [u32; 298] = [711442433, 3564261005, 2399042279, 4170849936, 4010295575, 1423987028, 330414929, 1349249065, 4213813618, 3852031822, 4040843590, 2154565331, 3094013374, 1159028371, 3227065538, 2115927092, 2085102554, 488590542, 2609619432, 3602898805, 3812736528, 3269439096, 23816114, 253984538, 1035905997, 2942969204, 3400787671, 338562688, 1637191975, 740509713, 2264962817, 3410753922, 4162231428, 2282041228, 1759373012, 3155367777, 4278913285, 1420532801, 1981002276, 438054990, 1006507643, 1142697287, 1332538012, 2029019521, 3949305784, 818392641, 2491288846, 2716584663, 3648886102, 556814413, 444795339, 4071412999, 1066321706, 4253169466, 2510832316, 672091442, 4083256000, 2165985028, 1841538484, 3549854235, 364431512, 3707648143, 1162785440, 2268641545, 281340310, 735693841, 848809228, 1700785200, 2919703985, 4094234344, 58530286, 965505005, 1000010347, 3381961808, 3040089923, 1973852082, 2890971585, 1019960210, 4292895237, 2821887841, 3756675650, 3951282907, 3885870583, 1008791145, 503998487, 1881258362, 1949332730, 392996726, 2012973814, 3970014187, 2461725150, 2942547730, 3728066699, 2766901132, 3778532841, 1085564064, 2278673896, 1116879805, 3448726271, 774279411, 157211670, 1506320155, 531168605, 1362654525, 956967721, 2148871960, 769186085, 4186232894, 2055679604, 3248365487, 3981268013, 3975787984, 2489510517, 3309046495, 212771124, 933418041, 3371839114, 562115198, 1853601831, 757336096, 1354633440, 1486083256, 2872126393, 522920738, 1141587749, 3210903262, 1926940553, 3054024853, 2021162538, 2262742000, 1877899947, 3147002868, 669840763, 4158174590, 4238502559, 1023731922, 3386840011, 829588074, 3449720188, 2835142880, 2999162007, 813056473, 482949569, 638108879, 3067201471, 1026714238, 4004452838, 2383667807, 3999477803, 771648919, 630660440, 3827121348, 176185980, 2878191002, 2666149832, 3909811063, 2429163983, 2665690412, 907266128, 4269332098, 2022665808, 1527122180, 3072053668, 1072477492, 3006022924, 549664855, 2800340954, 37352654, 1212772743, 2711280533, 3029527946, 2511120040, 1305308377, 3474662224, 4226330922, 442988428, 954940108, 3274548099, 4212288177, 2688499880, 3982226758, 3922609956, 1279948029, 1939943640, 3650489901, 2733364929, 2494263275, 1864579964, 1225941120, 2390465139, 1267503249, 3533240729, 904410805, 2842550015, 2517736241, 1796069820, 3335274381, 673539835, 1924694759, 3598098235, 2792633405, 16535707, 3703535497, 3592841791, 2929082877, 1317622811, 294990855, 1396706563, 2383271770, 3853857605, 277813677, 277580220, 1101318484, 3761974115, 1132150143, 2544692622, 3419825776, 743770306, 1695464553, 1548693232, 2421159615, 2575672031, 2678971806, 1591267897, 626546738, 3823443129, 267710932, 1455435162, 2353985540, 3248523795, 335348168, 3872552561, 2814522612, 2634118860, 3503767026, 1301019273, 1414467789, 722985138, 3070909565, 4253482569, 3744939841, 558142907, 2229819389, 13833173, 77003966, 2763671364, 3905603970, 2931990126, 2280419384, 1879090457, 2934846267, 4284933164, 2331863845, 62191163, 3178861020, 1522063815, 785672270, 1215568492, 2936443917, 802972489, 2956820173, 3916732783, 2893572089, 1391232801, 3168640330, 2396859648, 894950918, 1103583736, 961991865, 2807302642, 305977505, 3054505899, 1048256994, 781017659, 2459278754, 3164823415, 537658277, 905753687, 464963300, 4149131560, 1029507924, 2278300961, 1231291503, 414073408, 3630740085, 2345841814, 475358196, 3258243317, 4167625072, 4178911231, 2927355042, 655438830, 3138378018, 623200562, 2785714112, 273403236, 807993669, 98];
const POW5_14: [u32; 595] = [1691320321, 2671006246, 1682531301, 2072858707, 1240508969, 3108358191, 1125119096, 2470144952, 1610099978, 1690632660, 1941696884, 2663506355, 1006364675, 3909158537, 4147711374, 1072663936, 4078768933, 745751659, 4123687570, 471458681, 655028926, 4113407388, 3945524552, 985625313, 1254424514, 2127508744, 570530434, 945388122, 3194649404, 2589065070, 2731705399, 202030749, 2090780394, 3348662271, 1481754777, 1130635472, 4025144705, 1924486271, 2578567861, 125491448, 1558036315, 994248173, 3817216711, 763950077, 1030439870, 959586474, 3845661701, 483795093, 1637944470, 2275463649, 3398804829, 1758016486, 2665513698, 2004912571, 1094885097, 4223064276, 3307819021, 651121777, 1757003305, 3603542336, 129917786, 2215974994, 3042386306, 2205352757, 3944939700, 3710987569, 97967515, 1217242524, 930630949, 3660328512, 1787663098, 1784141600, 2500542892, 4034561586, 3444961378, 785043562, 3869499367, 885623728, 2625011087, 3053789617, 1965731793, 3900511934, 2648823592, 3851062028, 3321968688, 799195417, 1011847510, 1369129160, 1348009103, 2876796955, 2915408967, 3305284948, 263399535, 1715990604, 2645821294, 1587844552, 2624912049, 3035631499, 2306636348, 3499275462, 675152704, 854794152, 4004972748, 1739996642, 1333476491, 4012621867, 3658792931, 3297985728, 2864481726, 3066357406, 785287846, 1671499798, 433044045, 1919608025, 264833858, 3999983367, 1116778570, 1301982149, 4213901070, 4081649357, 536169226, 1389008649, 188923873, 373495152, 2551132278, 1800758715, 3951840330, 2632334454, 3118778225, 1034046547, 1862428410, 3037609062, 1994608505, 29051798, 2571685694, 264151332, 2260643090, 2717535964, 3508441116, 3283713017, 1903365635, 923575694, 1219598101, 2288281570, 3676533911, 1014136356, 555142354, 2389170030, 4185108175, 884862419, 836141292, 2957159173, 1997444768, 4233903127, 2876184692, 3089125070, 1480848293, 1097600237, 299700527, 2507669891, 2982628312, 2114881043, 2529576251, 2812279824, 2987750993, 4241938954, 2204775591, 1037094060, 829315638, 1231047149, 52608178, 3735136637, 3455232602, 962039123, 488286513, 50685385, 3516451821, 843975207, 1572355722, 675489076, 2428445672, 1555117248, 3708476086, 10375249, 4172112346, 2117510871, 2227658327, 3187664554, 3050656558, 328034318, 3179601324, 1247769761, 3439263953, 1431538938, 2962525068, 1213366289, 3813013550, 2651093719, 1860661503, 3933716208, 264320617, 789980519, 2257856172, 102000748, 977269860, 1113845122, 3008928583, 1461738106, 557786285, 2926560363, 1038106190, 3643478847, 828004507, 457818698, 1933056971, 373408056, 2076808229, 3160935130, 2781854874, 2519636100, 177606000, 4237103862, 3977834316, 1621936232, 2599050516, 319893558, 3343370366, 765044144, 976657331, 7026264, 294277429, 3829376742, 3029627280, 2705178718, 3614653880, 230519152, 3288033233, 293525479, 3805751881, 3227511198, 2520308544, 3648103003, 1111086184, 437622105, 2232033852, 3239146386, 584244184, 1450926016, 2462430443, 3226534010, 298582169, 4214576928, 1762099469, 964985185, 1585788148, 1641127666, 787006566, 2315956284, 3258232694, 2275058964, 2541003317, 1508235863, 2613339827, 4080647514, 1152057965, 3149266279, 731345410, 914737650, 65395712, 1884566942, 1379520432, 2611027720, 4163073378, 2619704967, 2746552541, 1388822415, 3005141199, 843440249, 4288674003, 3136174279, 4051522914, 4144149433, 3427566947, 3419023197, 3758479825, 3893877676, 96899594, 1657725776, 253618880, 434129337, 1499045748, 2996992534, 4036042074, 2110713869, 906222950, 928326225, 2541827893, 1604330202, 226792470, 4022228930, 815850898, 1466012310, 3377712199, 292769859, 2822055597, 3225701344, 3052947004, 385831222, 705324593, 4030158636, 3540280538, 2982120874, 2136414455, 255762046, 3852783591, 3262064164, 2358991588, 3756586117, 4143612643, 3326743817, 2897365738, 807711264, 3719310016, 3721264861, 3627337076, 944539331, 3640975513, 3712525681, 1162911839, 2008243316, 2179489649, 2867584109, 261861553, 3570253908, 2062868357, 2220328623, 3857004679, 3744109002, 4138041873, 1451860932, 2364975637, 2802161722, 2680106834, 753401584, 1223182946, 1245401957, 4163377735, 3565815922, 2216942838, 4036140094, 71979081, 3924559643, 400477238, 551750683, 1174153235, 859969898, 1185921017, 1711399735, 812991545, 4051735761, 3549118738, 1631653329, 3631835958, 3648867800, 1206500363, 2155893137, 361030362, 3454286017, 2505909489, 1083595169, 453595313, 1510564703, 1706163902, 1632924345, 1381875722, 1661526119, 1082778324, 3571910052, 1140625929, 851544870, 1145546234, 2938573139, 907528924, 1304752338, 1764668294, 1788942063, 1700368828, 104979467, 1413911959, 3327497828, 1956384744, 1272712474, 2815637534, 3307809377, 1320574940, 1111968962, 4073107827, 434096622, 169451929, 3201183459, 3331028877, 2852366972, 3369830128, 2924794558, 3106537952, 3739481231, 1612955817, 4138608722, 2721281595, 2755775390, 843505117, 982234295, 1157276611, 814674632, 4246504726, 3532006708, 992340967, 1647538031, 204696133, 193866982, 3899126129, 300851698, 1379496684, 1759463683, 1354782756, 1374637239, 3410883240, 1073406229, 3038431791, 1053909855, 3607043270, 173719711, 3733903830, 171820911, 1573050589, 932781534, 4183534770, 2158849555, 372245998, 3573073830, 841339264, 2759200520, 1610547277, 2603293319, 3890906486, 1557138278, 3964109906, 677238797, 537994297, 1124184993, 4287078344, 4207654540, 2943022776, 2977947524, 3255359985, 4098397558, 2274666217, 2915862060, 243524940, 2467726756, 2869020032, 507521339, 3403121914, 522051455, 1803903108, 3471254194, 473535371, 1948602036, 3352095732, 3116527002, 1795743673, 775867940, 2551469548, 3757442064, 3162525227, 3765412747, 3040105484, 1927625810, 48214767, 2997207130, 1342349989, 2536583992, 1501320191, 3592287317, 887432730, 967585477, 3334212779, 948663609, 1064513472, 15386372, 2465931737, 3230242590, 3036652803, 2063155087, 1927500726, 2821790499, 2187774383, 501520074, 3688568496, 3606711121, 2576459247, 3176542345, 378322447, 156541411, 1400607301, 1406179107, 677848877, 2253753529, 193196070, 4207435024, 4166396241, 509467541, 2906024136, 1221753746, 3375413222, 431327897, 2749265123, 2848827671, 3412997614, 2051920238, 1283516885, 1300498239, 1957256104, 2634010560, 3531900395, 360276850, 1461184973, 2012063967, 2873572430, 2914608609, 4289554777, 1539331673, 1859532928, 4213441063, 538215691, 3512720863, 4258743698, 3040408445, 982396546, 343095663, 4138069496, 1021581857, 214185242, 1968079460, 2864275059, 3347192726, 4096783459, 3259169450, 3707808869, 142485006, 399610869, 230556456, 2219467721, 4191227798, 2242548189, 3136366572, 179755707, 3464881829, 452317775, 3887426070, 3446430233, 1473370015, 1576807208, 3964523248, 419325089, 2373067114, 1596072055, 1928415752, 3635452689, 1005598891, 3335462724, 3290848636, 3669078247, 1178176812, 2110774376, 3068593619, 1253036518, 908857731, 3631223047, 4138506423, 2903592318, 3596915748, 3289036113, 3721512676, 2704409359, 3386016968, 3676268074, 2185259502, 1096257611, 3360076717, 3548676554, 170167319, 3360064287, 3899940843, 9640];

pub(super) const POW5: [&'static [u32]; 14] = [
    &POW5_1,
    &POW5_2,
    &POW5_3,
    &POW5_4,
    &POW5_5,
    &POW5_6,
    &POW5_7,
    &POW5_8,
    &POW5_9,
    &POW5_10,
    &POW5_11,
    &POW5_12,
    &POW5_13,
    &POW5_14,
];

cfg_if! {
if #[cfg(feature = "radix")] {

/// Large powers (&[u32]) for base3 operations.
const POW3_1: [u32; 1] = [3];
const POW3_2: [u32; 1] = [9];
const POW3_3: [u32; 1] = [81];
const POW3_4: [u32; 1] = [6561];
const POW3_5: [u32; 1] = [43046721];
const POW3_6: [u32; 2] = [3793632897, 431439];
const POW3_7: [u32; 4] = [2038349057, 2033330060, 1456779151, 43];
const POW3_8: [u32; 7] = [2324068865, 2151814273, 4219200356, 3831009148, 1515007727, 1223069914, 1878];
const POW3_9: [u32; 13] = [120648705, 3524288303, 123305297, 1973552606, 1582677123, 4275192449, 223346561, 3350064824, 1500483036, 1257605964, 1367913622, 2878850248, 3527953];
const POW3_10: [u32; 26] = [1995565057, 493227282, 1124501772, 1987702555, 1293151165, 901580639, 3173678675, 2491643407, 2858789928, 4190666723, 3234280160, 1552091534, 1098766192, 535263123, 671427889, 2428827667, 442154954, 3812608783, 2997209821, 882392610, 726842283, 3784254415, 1868908668, 1167284160, 3936843162, 2897];
const POW3_11: [u32; 51] = [2418266113, 2644811931, 291457750, 1228555692, 4188395951, 1879994809, 3593180558, 10265866, 1663691138, 843910177, 428616802, 383870689, 363531492, 132717144, 1517834416, 1163669408, 3198438890, 2668578238, 3647540890, 862346293, 2517635987, 240350806, 3915968527, 1177122755, 748979939, 2832571033, 89370928, 1833830663, 2468463247, 2650192631, 2242055147, 1865594656, 4265350596, 1503068824, 1868812441, 2681777372, 2889847246, 3308916069, 983500879, 3408251151, 2154883072, 49524507, 3278693234, 4217536798, 4081384898, 3784867324, 607038776, 4050474118, 1564906641, 3106553379, 8397920];
const POW3_12: [u32; 102] = [2840043521, 1540321337, 767411044, 3396833747, 259596680, 3733039683, 207521616, 948242495, 781132489, 2161879572, 891872999, 895088354, 1052134478, 3366112117, 2144001521, 2587580027, 3486676624, 1606020622, 1120717714, 3202521782, 2600718456, 1561168670, 4008838462, 4289731214, 2853963150, 2124711879, 2426069860, 4179412452, 2514942520, 782315593, 637303440, 2034234560, 1899461323, 1365048154, 143638530, 1091043496, 2313128713, 1632823752, 1501556769, 1617441271, 3832922217, 4022881155, 2291639705, 2009961883, 2923031135, 104349646, 721181067, 3110549978, 1118342134, 3111544970, 3523576724, 3188223411, 1433909029, 715526501, 480052905, 3456303432, 1911699360, 2383287320, 806454471, 3619655246, 797999986, 3490535011, 727608595, 3007402875, 412470314, 311012536, 4082475156, 1929900167, 2743731994, 123772258, 3183779998, 331631487, 2482139594, 2030549481, 886716221, 3336904643, 1675792966, 708537412, 3256221032, 1941911759, 3257054398, 2644783750, 2889722204, 2012789015, 3141472195, 2208384519, 4290796508, 3164140686, 798188221, 3588366685, 2275055709, 1007570156, 895359884, 308610244, 3285989372, 453890838, 2972940297, 3657184703, 4029262500, 1785980957, 1709474525, 16420];
const POW3_13: [u32; 203] = [1989099521, 4118005181, 2784736632, 1591520375, 3149497838, 120872100, 3268194218, 2541515075, 1443129394, 2450564616, 4211997843, 3010894003, 3488508283, 3168823743, 4221978727, 1814219615, 2257880666, 2937457502, 726097399, 1432510431, 3623148218, 4212655794, 674028783, 1070458814, 2999384570, 1057211904, 1214775680, 1198321802, 1742834418, 3976283753, 1704638003, 1150196049, 862607433, 3094934565, 1717221074, 2662007806, 1439914256, 440811537, 2348627913, 1256162099, 267894251, 786369445, 1766348239, 3821736572, 3346805441, 153712663, 3885791558, 2372893612, 3047484027, 1233249852, 2901680213, 1633905397, 1227232372, 2772305912, 3924643248, 2682967226, 452577852, 4125302502, 3281241925, 4238233594, 2716754899, 3041594220, 2682018838, 626131564, 1963041990, 2065902713, 2603950262, 3095577885, 1839434394, 4180555672, 84786972, 4278806346, 3035916175, 2330476828, 1488573301, 2500745307, 851546392, 856436551, 3255008763, 1254027339, 3922579641, 684521982, 3718279773, 201247274, 2865772478, 1661217807, 2452776392, 2994094948, 1563975657, 3404497195, 26262692, 1976116320, 2717359634, 3933383310, 2639054358, 433403848, 3618223885, 515738077, 1166242878, 2870355216, 2931111594, 3146034481, 1341461620, 2902728897, 445742713, 2516857131, 3214583960, 2398636469, 272528879, 1474549553, 4074162653, 2846904993, 3653153845, 1143580991, 2862624787, 1146152282, 678419602, 676200709, 3450362083, 3496513874, 1340992762, 4202699539, 2772946083, 1813525850, 3647968120, 2351713161, 2620418793, 1432172974, 1926349909, 3142386689, 798457517, 2602933474, 1282058432, 1591224320, 2716997635, 1470549750, 3231957967, 1843138204, 916505043, 944975043, 3562455555, 142650189, 3496720432, 172385644, 1321658753, 3705048361, 2722721050, 1309746413, 3948489302, 1278815165, 2862992204, 416184660, 1314168979, 3057292743, 3306397597, 3990492847, 4077152808, 728714950, 1739211429, 2747763777, 1272802838, 311396446, 3721256556, 3351298146, 3532437535, 1181844299, 4211695344, 3293791810, 463498694, 467923860, 3160877532, 1513252595, 2210598062, 375855701, 2032403348, 126535477, 2612392194, 2324015344, 3456022262, 3450499670, 2870619468, 794761483, 3000301945, 2387559626, 2662253415, 3659359224, 1026083388, 1046817774, 3912755589, 2122896674, 3271718598, 2001918117, 1779848570, 2511901175, 2480900964, 1524873519, 2123619892, 3128581558, 2498944444, 637563527, 4159894460, 306290363, 269629471];
const POW3_14: [u32; 406] = [2099150849, 701786787, 1755792598, 784340596, 1318601904, 3847911731, 587073536, 365758857, 458403624, 386356260, 1762699493, 3433357154, 2584239718, 3024933458, 992158912, 190818046, 626134648, 3100287313, 2050339901, 3193336121, 865261815, 4032628840, 3544894355, 1343940016, 2256792156, 660366745, 3495038095, 1796842708, 2708197863, 488865090, 3019365153, 3547886422, 338978285, 2879593856, 1161424980, 2532570101, 919483686, 285229234, 1471360694, 962282435, 3522233567, 812073225, 2974433512, 2062552230, 4142366515, 3030097561, 2370820074, 1533608708, 3136743081, 677180323, 2026099629, 3988538975, 2882718020, 2791855106, 901454064, 1733181317, 1815926074, 2641249342, 205063446, 1605355824, 1412530368, 392610986, 1165183496, 1547418282, 234904178, 1452470696, 4153026085, 1039567861, 976503900, 3326386007, 398523011, 636629983, 988936191, 180109784, 35078416, 3316096777, 446118631, 3363780714, 2778228881, 1121420008, 2277227294, 3286959436, 3390534136, 3471230490, 26261918, 1529388667, 1337804871, 157925485, 4005827295, 1940455666, 2179129784, 2230764206, 4133049885, 787743620, 206584505, 536424564, 2347733349, 2127350488, 3622501416, 2681290576, 29689975, 3157055732, 3755589600, 3964024562, 1703745931, 444745493, 1685391633, 3847735038, 1141249397, 4124411194, 2699168764, 2516945277, 1379343014, 1735161321, 2518007387, 4154772473, 2516518603, 77667182, 2901149252, 1077617976, 3033704680, 2341748280, 3239557938, 3625034956, 3851721623, 958796982, 1030859667, 1614720586, 1417286859, 3019299795, 3316288320, 2053046853, 1205913034, 406765224, 4163409034, 3644521955, 678788809, 1048403252, 2180427097, 1510574153, 1320493806, 4279263604, 281966796, 2685455103, 2666190803, 3067005562, 3221244892, 1971957474, 849438589, 1584595613, 2454213790, 2156344722, 3770071351, 2205912499, 2893248775, 1629808101, 252803404, 1632951746, 3155742212, 166264103, 492569650, 2230310542, 3689268700, 4204139123, 3759547874, 326889610, 711452220, 4058365029, 1128589942, 789582083, 4071978836, 2696635374, 3923925207, 1293857747, 2987905449, 3346858289, 28115676, 715947610, 608126801, 1751549604, 3309338460, 1129461952, 552591053, 267524979, 1414364888, 2528558825, 3781593658, 2335318828, 4139346762, 2281798865, 3588226868, 2855371367, 308801770, 2067748732, 2361054051, 3541790565, 1015821430, 1667098714, 2017648993, 2672308018, 1576401102, 59885878, 2536836354, 769548065, 3150906464, 3038028751, 2097625751, 4213561908, 1337967423, 2931763012, 2256338530, 3526977155, 2211626795, 3921745985, 4044006804, 2620267187, 1303853568, 138250406, 676718200, 2434799399, 1034944144, 2790768247, 1949560037, 2657385661, 1401109267, 2969455499, 2342873842, 4292623932, 3148918694, 169039494, 1361292240, 1689965319, 270493791, 1171826919, 1200742270, 2846839124, 3153980733, 3233534339, 3824262631, 326024744, 3780525617, 1649806460, 1500987616, 288775088, 3535410573, 3275414509, 3158560889, 2281111300, 3764770800, 1798194300, 2256605564, 1104786778, 147494599, 1948189160, 469870811, 3275616186, 1215054053, 1802946482, 215038054, 3232037233, 3945501635, 1363902757, 404304310, 2741496635, 4006384272, 3104805825, 2707083507, 1268576851, 74077974, 1902096819, 2500280581, 2077772156, 252830146, 330674602, 182339026, 3998928, 679066470, 2193213293, 2297252499, 3199220015, 2916487180, 34820209, 3043558828, 496902160, 1912842248, 2761877593, 81053742, 31423440, 1623392413, 3681614180, 3706303025, 3609099829, 319355607, 2116802460, 1631992176, 326568575, 308633459, 2253446077, 2505725839, 1658619050, 3717100624, 3124457627, 3938979720, 378615080, 796775517, 2484425710, 2370945803, 3635404255, 1642897911, 3461267096, 980851450, 669484175, 3957917346, 1291209040, 3534600633, 908358350, 1171284312, 1173895248, 2045404622, 2383359933, 694807182, 782712160, 276844360, 3279951877, 662528357, 1140187597, 962859221, 609598977, 3224082259, 606343511, 1007222254, 3312403701, 3723085654, 2896760681, 1268912052, 2669270762, 2776585343, 2328099212, 1913949529, 1705013131, 1352980727, 3247747100, 3237280485, 3725838632, 1816740850, 2095343623, 2604445469, 2014122662, 2278326090, 2137889241, 2073810843, 3230036038, 2722123549, 625335738, 2143934557, 3485229053, 907622657, 389106053, 517294670, 3975094579, 3460497132, 2753230712, 3618500254, 1767180180, 450598903, 318120517, 1371944747, 4270384812, 4064996567, 4062789116, 2378871712, 2581768669, 1541615487, 3183806363, 2187213713, 592752252, 2581891948, 105706307, 1271739594, 2675380672, 4001439490, 4045432171, 1661211140, 169691080, 3239633127, 1859466085, 4177368645, 4254065357, 1214584656, 4106228738, 1588437889, 4216163436, 1823694050, 1947452389, 3346370711, 3092250440, 808677001, 2442695134, 2423455871, 305111635, 781955824, 3233596643, 2406310476, 4094768582, 3539230931, 16926799];
const POW3_15: [u32; 812] = [977076225, 665231849, 1569936694, 3300462826, 3759246837, 326316884, 2798287963, 3779953373, 2277747800, 689807777, 829104887, 2397668658, 1709214325, 4206373129, 3483391277, 462393218, 116664855, 3637894846, 2827889973, 2289639987, 3701261422, 4131673423, 1392299185, 18191081, 1308379809, 2813448616, 2137621016, 3532900543, 1569394972, 2216088761, 3605559987, 2480823850, 153023415, 2537218497, 754662786, 2688938781, 104227757, 3786462738, 1526336091, 4226287732, 2226740239, 221297306, 2380509180, 1464866741, 2133456807, 96068661, 76554789, 1194672402, 1286883027, 2750574887, 3680268940, 1148071571, 1618401263, 2273043207, 4233533562, 3294809827, 3038764813, 2260406468, 2751753334, 1445140655, 951517675, 2699714925, 797923648, 1411860472, 1216680597, 1265156686, 3093702682, 3635681048, 103475451, 1351713669, 1822435752, 1075856608, 617029753, 2108292708, 2265794484, 3444562046, 3013856539, 3374113009, 1273744434, 1798683062, 731085671, 1174843365, 1264751086, 3613934285, 234566293, 759631509, 2924341480, 1364564907, 1422066798, 3499662881, 3217435347, 1735515946, 783210314, 1463486206, 503941910, 573961175, 3116332448, 1988468357, 1619292039, 494673558, 289406169, 3681947934, 2354543125, 576799059, 604599075, 2021838681, 2539335679, 3620888342, 3440021174, 3167827176, 3202187935, 3409546789, 1753251271, 3951582214, 521441946, 3520318558, 2949580253, 1744686194, 3722262649, 623707689, 2906626542, 3122971166, 3666397302, 1405545324, 3247824480, 50348455, 2950984894, 4100482143, 2601927701, 769445341, 3282420320, 1612837839, 3846723436, 3100293446, 3454749416, 3832773649, 4106402262, 2132557325, 3697449131, 911174079, 1113364369, 4157715961, 3459844844, 884122317, 2104093387, 2246217016, 1014013752, 1363067164, 2136896341, 638524480, 856226478, 2613694659, 3809502541, 1101617889, 1348584245, 4085070738, 2653090842, 3548571547, 3638729786, 3978827176, 2701180571, 2431405901, 1991357722, 2789553889, 1215139818, 149948434, 1862909929, 524705816, 3865681882, 3085477434, 1234829146, 261905085, 2486282815, 902059058, 1115268482, 3234668970, 633446375, 2133637664, 208465789, 1168192927, 91089615, 2600824463, 821516792, 655082941, 2827356163, 958520014, 459754197, 3190418314, 2477738486, 2276057265, 2937046308, 4129474599, 2953340360, 720300476, 3071321147, 1961269026, 2626964164, 3295057101, 351312209, 3989328611, 4016287034, 2784297095, 2584564549, 4235964864, 3020191779, 3613856936, 3834427981, 2394222409, 4238789829, 4268785928, 3051356005, 3293606548, 3630736032, 422867984, 432824566, 3901098751, 2390975830, 3134306497, 2564921837, 4140939134, 1810973406, 232764264, 69946565, 1089005411, 288255572, 2307356902, 721551027, 2799884692, 4290562898, 3755023645, 3388258631, 1735432797, 3975130945, 3656271477, 980084222, 1693335884, 1128682411, 459254825, 4286436860, 1282800380, 3201300723, 2913660195, 1230767939, 2564841558, 2901607613, 2047657105, 312129423, 3670907676, 747204213, 398567505, 1017711391, 3562607879, 1151347463, 3504014102, 2885816569, 3702067617, 71206157, 3414390270, 875720752, 756309280, 2064378149, 3801432071, 2624302272, 4115743361, 2437234452, 4096619154, 2014005425, 837832307, 606482339, 1435363044, 3220253675, 2923815073, 3601698132, 2353903620, 320691909, 2980412705, 3629142485, 527344715, 712935520, 3244244787, 3953180185, 2997173735, 1152679787, 4141514275, 2153167521, 1995499395, 2881799696, 1641155614, 2156166469, 1572616433, 1510630704, 644378049, 4087657681, 3978892094, 691499394, 1761722997, 3050169641, 129094026, 2242972306, 3174880108, 4111928597, 2556230763, 1057341631, 3171345450, 4263386100, 3631765252, 1299324510, 2638754245, 2928716291, 2489288192, 1674137302, 2117213443, 882713605, 1721601475, 454277280, 2909840013, 4261878591, 4022483988, 3544985560, 458094242, 2961271485, 3048055976, 1376883343, 449828671, 564618158, 4214664377, 1215494659, 2499909252, 4219176856, 2811094696, 1385141981, 2701051365, 1856463317, 3584408118, 2968635820, 10172405, 2056014449, 3384619603, 2280278205, 3805365066, 901038155, 2068856942, 307396294, 3069118749, 998505300, 2487723299, 3358590131, 2731763005, 2707256312, 1883994053, 3799343800, 2732088777, 3387374759, 2710407985, 2023144656, 1627017642, 2744538970, 1417526901, 1979078266, 3955229367, 836934913, 3899152926, 3259588588, 4063607839, 1894138936, 4153978973, 2768699532, 3020574603, 2328913378, 1569099469, 799511246, 1133327297, 300277759, 3974871327, 2460059461, 3899205157, 3064672977, 1872540621, 945262695, 325232699, 76534068, 1479292589, 79858847, 4048780148, 4214538964, 3544736689, 3122263589, 3478566613, 81585786, 1883073293, 1586951053, 2187904173, 310461746, 3417021150, 921595721, 2053427479, 576973815, 3088873149, 254955010, 136832176, 4131280646, 396511795, 933966624, 596695524, 1886566601, 538546092, 1777359054, 1782863433, 4088120414, 2692527488, 1994469219, 1205575334, 2220302319, 3071518678, 1822291831, 555715043, 1382151022, 1251562657, 3366152646, 2235627699, 3309035321, 2952465262, 1588243565, 616371241, 1537858556, 3733502239, 3038942605, 2943072839, 1772377061, 212909121, 280698560, 1185201976, 1806348826, 3495857928, 1360522891, 667653581, 4169340271, 518461107, 4110527590, 2668038607, 2414610661, 1865330298, 825331100, 2444783573, 2466941253, 3650347584, 1397625664, 1980523468, 3793438624, 2690589061, 1195952221, 3747602114, 2374869194, 414544833, 27677727, 3400143154, 2210677843, 238322055, 2955979780, 1742604312, 1635554129, 4288342779, 3525767625, 3575812701, 3852420364, 774768456, 1506764262, 2429709095, 650578902, 340564538, 3927129992, 4056828676, 166703365, 33948809, 3717821049, 1509919413, 3567916042, 3981250677, 1927530024, 224725383, 600599372, 1383643164, 2138194201, 4215725040, 694881644, 3312648852, 772708618, 3733439657, 4142109032, 3690065639, 577875182, 2042961772, 2305850905, 2666010309, 4139127974, 3625925851, 37363622, 1484971370, 4226846556, 992135373, 1354091842, 2706219413, 4006422807, 3356274389, 1898412496, 372485657, 3113085433, 2469075819, 3700417951, 661665232, 2175263303, 4151002255, 1322953602, 1398857372, 4092760541, 460708877, 1380138655, 1173256788, 3543568491, 372513444, 3618774273, 171778171, 2906866967, 2741819333, 2449184156, 223365344, 4074821242, 389134615, 3872232579, 2182620296, 1144968045, 1253477771, 1488762008, 950621237, 2808471730, 1754633513, 1343614188, 707229382, 1587254860, 4057654663, 2471650257, 3003858919, 1521938392, 2801431700, 4041731793, 1665613244, 1764345685, 2682613774, 1089317494, 3920898996, 1631542663, 1152751820, 2593297577, 2401176124, 3427924880, 2895054615, 2841733279, 3854928360, 3715787645, 3776522603, 2555629509, 4206541732, 3223789014, 3740340293, 3320164578, 435177505, 2523400968, 563655360, 1581191127, 1144707279, 855705671, 1764404902, 1980422602, 3193983722, 1784826658, 2033241881, 3298662269, 4052448551, 1814214611, 2414784682, 1392057948, 1530764508, 4236021491, 2631121997, 1558832356, 65806235, 2439716846, 2333677941, 3855912835, 3323178073, 1648841414, 3829450625, 2677208545, 3734992945, 3608554434, 4151698100, 2265494611, 973831956, 1127908087, 2675067860, 2242029652, 1172430891, 386583169, 891502608, 3159236118, 91249420, 924134833, 655922446, 3878261204, 2569875981, 306765063, 3997879750, 922838874, 469732202, 3413422760, 2100428547, 1134345585, 2671194616, 744990806, 2212196019, 4048773444, 3791713114, 465130004, 396721512, 3896966880, 2771391871, 2858000595, 3584483877, 2691782662, 71701344, 3267381379, 2627664943, 487370091, 1128409664, 555841047, 682672357, 2207620346, 1974862125, 1961136721, 2764165810, 633378149, 3686514390, 1628451091, 1244377725, 4021981336, 2632625717, 212003232, 4213777100, 1614360497, 2205714513, 1193502716, 2965908528, 2556543713, 2169587738, 1716921633, 3361580901, 1270997602, 3251480352, 1461993621, 4009359607, 872306146, 2274523155, 2334723523, 3398888123, 4015291819, 12680754, 2805358789, 2247586482, 28821447, 4228210838, 2867165351, 4209425414, 922472442, 3643667272, 1313769367, 1778529406, 584053570, 83932611, 3878783785, 4196858881, 1254933100, 30545947, 2451049957, 154913180, 3845798874, 1409060809, 3698149006, 527499883, 3434852678, 1979037736, 401474618, 2713075691, 2032852562, 3315343561, 3117156026, 3181822096, 2967959904, 1867039832, 1567241529, 1015814356, 2412089990, 1113107588, 602907863, 159564957, 2080426894, 198488940, 3985292030, 55282183, 3166735149, 1314890162, 119232860, 3469854015, 4174956040, 2691924814, 1006559213, 1532043124, 3780490932, 735080823, 4038443176, 1464982680, 2188164698, 1105691252, 2832066849, 642565775, 2809009489, 3698954670, 1268079142, 3380048275, 2662521390, 3640101839, 1367787965, 1769983508, 1558676012, 3821420353, 557271040, 200032047, 2391640791, 3185110957, 3370102276, 4192700174, 1951921206, 2393913997, 2256077493, 3912963808, 890212418, 410895905, 793331347, 1194949436, 1163600753, 3261321478, 1478141486, 3778505335, 1148133083, 1580132921, 2075844758, 2044688990, 3252322700, 3450246327, 1665549940, 885615587, 3053594569, 2064590405, 882713210, 1035067905, 2624489169, 422434002, 861334403, 1732796031, 3463839962, 2080242549, 1471721702, 3879684426, 1737303084, 452970607, 2407914145, 1453526573, 2797693217, 699390353, 3388187217, 1293310005, 3490803260, 1346814231, 147543365, 3807051994, 513089673, 3224976654, 2555625000, 2421574820, 2500076521, 3147402354, 3326543525, 1259937196, 3089525877, 3832036063, 1145039035, 3033684338, 3430207412, 789393924, 3750175001, 2595067644, 2026469744, 2973210731, 77465930, 199452807, 3866340586, 786433973, 1959614337, 2595721884, 707599685, 2186856175, 3578934304, 66709];

pub(super) const POW3: [&'static [u32]; 15] = [
    &POW3_1,
    &POW3_2,
    &POW3_3,
    &POW3_4,
    &POW3_5,
    &POW3_6,
    &POW3_7,
    &POW3_8,
    &POW3_9,
    &POW3_10,
    &POW3_11,
    &POW3_12,
    &POW3_13,
    &POW3_14,
    &POW3_15,
];

/// Large powers (&[u32]) for base7 operations.
const POW7_1: [u32; 1] = [7];
const POW7_2: [u32; 1] = [49];
const POW7_3: [u32; 1] = [2401];
const POW7_4: [u32; 1] = [5764801];
const POW7_5: [u32; 2] = [2768600449, 7737];
const POW7_6: [u32; 3] = [1855011585, 809251672, 59871144];
const POW7_7: [u32; 6] = [3233510913, 429135816, 2162242590, 3594221799, 4265959880, 834593];
const POW7_8: [u32; 12] = [467332097, 140397015, 2040215064, 1542555902, 642371654, 3366106563, 831699702, 4090248544, 1331205625, 2632189658, 762431610, 162];
const POW7_9: [u32; 23] = [21354497, 135586989, 282407512, 217755548, 3801957565, 1769047343, 3062175267, 1076844155, 1124873580, 2147641037, 1086167164, 3185325477, 3247742386, 2077448856, 1351003107, 2494468834, 1425599169, 1702421937, 627210051, 1827625163, 1157572577, 2350050876, 26301];
const POW7_10: [u32; 45] = [684437505, 4048640024, 292557896, 3831731169, 3332525442, 473405432, 318170344, 90380968, 1033695812, 2724674731, 3595206122, 3629228025, 4209239057, 3965362365, 2238697023, 3154103790, 4052343864, 307061298, 318989332, 3153953031, 3156479151, 3680726623, 4137569985, 2873142659, 111620858, 2694718026, 9322418, 1564274048, 34089246, 3248975485, 350774805, 3831801630, 1993467950, 948561877, 2841933524, 572639019, 4216663619, 2647977339, 3749591258, 2896152255, 2891627799, 2539551806, 2116905892, 913342961, 691771383];
const POW7_11: [u32; 90] = [3935789057, 4166252864, 1130174762, 746642697, 2097267391, 230814212, 262482422, 3074840744, 4242045452, 4198780607, 1168143213, 3832006688, 635278146, 3974112408, 2693579674, 4052193596, 224135106, 224110576, 1831951626, 884408112, 4161923167, 2530538468, 1766697210, 3734044005, 2193311966, 3643962908, 2508922853, 1237927695, 826765018, 301294391, 1355373603, 1013255492, 201605170, 4021658079, 1585360530, 2707437896, 1900635396, 1905296076, 1675742546, 1310459767, 3490908979, 1638170283, 4030411698, 3455559243, 2381042632, 3337653594, 279126172, 981840272, 4256082875, 2339121715, 620004595, 3193169600, 1024613477, 1289526822, 3754565871, 3118997668, 3220746202, 1344646439, 1144771397, 110884155, 2555110865, 1640054265, 266135361, 261538498, 2590652801, 3038147251, 4191122774, 4053161994, 3178416621, 3431021971, 1510437530, 2311593861, 420559473, 3882531531, 1283913491, 4286998498, 297948899, 1491612193, 2971470854, 1136813312, 1037229141, 134785729, 763322283, 3085025371, 3408591202, 487574582, 1031455143, 297009289, 2509812334, 111420556];
const POW7_12: [u32; 180] = [959365121, 3423668100, 712143694, 444296678, 48418474, 142336985, 3887558252, 3943006832, 3576330202, 4129514092, 42707875, 2694838052, 4082217492, 1355779148, 1861261927, 4159987319, 2544936187, 3806468287, 2398026180, 3957753963, 402448149, 2470238010, 66876637, 2170332003, 2407422937, 1228991919, 2304511904, 3264332932, 2065315545, 2762340589, 334250829, 4004573477, 3741920693, 2645443327, 2594766859, 895785842, 685096937, 3987524779, 1950352476, 2513536865, 1885951213, 4205468775, 3467243111, 4147994187, 1971851587, 558300163, 2061929723, 2784144437, 2922857092, 983256724, 230712609, 3933689823, 3690771138, 339563475, 24292607, 3371043320, 1273540978, 999150964, 1547569001, 1982341170, 1284932132, 4168068064, 3400761299, 3440883534, 3651096652, 3298235049, 708333125, 2267355819, 1643664806, 4114241045, 2619840477, 4293837164, 2866213855, 333068409, 2378301991, 991300859, 3044159605, 4196815209, 4135023850, 2196188706, 962925211, 2245320399, 564630964, 2457639540, 3232877080, 3055780701, 980341, 2711742573, 861530545, 3387314866, 3853131369, 32864486, 2678257946, 2669908999, 2000719590, 4085016586, 783013123, 3352468813, 3041875261, 672636292, 130345520, 3182074148, 2375468194, 144749725, 455673297, 3298407527, 2300894874, 2550621169, 2686545759, 2253272293, 2104008843, 3417084127, 3977810179, 3028718465, 3616280352, 472810701, 2435685230, 1140184549, 1815608139, 820551257, 1499547529, 3723830388, 3341076506, 1943874127, 2208139362, 843305710, 3253353809, 450882879, 2226491280, 2792190206, 2983548622, 1950750459, 2107941997, 1949146725, 3541495173, 1504541620, 4057108078, 1764274118, 2345724503, 4134715625, 3990303177, 853336782, 2849901989, 4105387281, 2811829615, 2395277513, 1705693013, 3132275041, 962121883, 1160904978, 716319733, 1865107910, 2767053744, 597618956, 1268902401, 3183068659, 465089785, 4051212113, 2371235036, 153181892, 1517303695, 4284973800, 2302738028, 2923330867, 1156795778, 3306600239, 3325535674, 4131001630, 3795322436, 1518142203, 42963, 1989482042, 462137403, 274966593, 1990974015, 2775016969, 2607645715, 2927122125, 1884990280, 2890485];
const POW7_13: [u32; 360] = [39682049, 2879252754, 3905716286, 2731189630, 966550211, 3252116258, 1335121684, 681044725, 2706091913, 648576539, 1423719455, 2112883936, 446026994, 788763554, 3766400133, 3802304351, 230490497, 1165165563, 11106404, 306247384, 2988589671, 1661613069, 439656198, 1535870016, 3928833501, 3568921325, 1383527719, 966546572, 2522388907, 633790419, 4215157643, 2929987618, 179646966, 1117925074, 4104859487, 290750689, 472489963, 2821759338, 2262625157, 1313217641, 3057814726, 574179583, 1571020465, 2183096229, 4252706683, 2950945461, 225603735, 3822968681, 1486094954, 3059720615, 1450766227, 3907188135, 871584955, 1088147742, 2446721734, 359320498, 1045473649, 152701656, 2073984609, 1019883931, 900397467, 4005214849, 1127792464, 2304454455, 455034548, 43343476, 4155327021, 2523732159, 638983805, 2892302829, 4283759155, 2943823736, 733632460, 2081380126, 2068191087, 3773292338, 3545085461, 2480295365, 2977057353, 1465321450, 4251560853, 2330236178, 200580713, 3888643412, 2710299332, 508228750, 3563957841, 611964264, 2420910703, 3715783850, 1060180261, 3687212695, 57436190, 2594481263, 3517172044, 2710085974, 1386435930, 2003427645, 1887681247, 67580893, 2492380859, 2530292932, 4141927460, 326169307, 3038495324, 1595985242, 4038575285, 871235333, 197140807, 2932035130, 3876347670, 102413750, 1348655981, 3781071583, 991687143, 2244663491, 3034023638, 2226118165, 4266682441, 2558001305, 652816556, 1306666356, 2409492116, 1189710321, 641930377, 121304481, 988012863, 1120045908, 2647024674, 1693808083, 2400379292, 4130523923, 2228041005, 3088521292, 3953572113, 1315146663, 1730466124, 448651717, 3142660598, 2888439717, 2144478006, 1952012792, 1281347257, 3034776202, 3385354032, 1610743174, 3250198660, 2062397168, 7849456, 2951565047, 1210878543, 3197024034, 3936553620, 1576601042, 1703562519, 2038817515, 1911545912, 3115087069, 2546337969, 1477903667, 1111933258, 788616929, 2725714831, 3330901336, 1035806609, 2773494881, 1840946151, 3387943085, 3856066552, 3124046370, 142112852, 3468696704, 1443178086, 4025409800, 3051817770, 3710270826, 1815171402, 2543269087, 1648373362, 1343483240, 4281806129, 1455193863, 2812972380, 1656167148, 1786309504, 3815616779, 1363050615, 3979406714, 2704972290, 496180240, 604853040, 3222170484, 1533573479, 2064025049, 525044436, 1431874076, 298038857, 3499922978, 2897172967, 949779672, 2390963596, 4226088650, 1288804277, 114574730, 3602333058, 4093682466, 958318090, 4092877466, 3776234353, 2890875716, 1589722447, 70461774, 3108903503, 1694441784, 52774611, 4265039878, 384595410, 1941048036, 4144534331, 2615953628, 245732993, 3234665791, 4163933482, 1697208095, 920250943, 1613357097, 3496559205, 3015994176, 40127559, 3369681758, 322792290, 3524996575, 3994827051, 393680817, 3200838249, 1153726347, 2406622498, 3869429162, 425402345, 2207346618, 365059, 2913999903, 4229175742, 2389219440, 1271061414, 1326457181, 450511120, 3944707822, 3886268527, 789528580, 852899589, 2410522351, 4038073280, 2914394560, 1370579794, 2293563894, 2719647097, 3380071952, 3067201483, 1763398529, 2991294230, 2209995439, 3200272980, 2005056358, 1166615296, 880283180, 3472909777, 342105901, 4124970840, 3561185389, 4208382111, 2839271323, 1206554429, 3696465541, 3706600000, 4229678662, 927942557, 3432267311, 1525401348, 2926457083, 3636398962, 744164581, 2280802780, 1850592388, 3725781290, 1981983136, 2894286166, 3518902953, 4130465722, 2780390157, 294854241, 4252673443, 2401608171, 1052084730, 1085373656, 1581328005, 3173411406, 3835729745, 2899844887, 3136848387, 1454757175, 3772637913, 1260190546, 2099037014, 3394671557, 1749814814, 3800071156, 2262535435, 33126042, 2981030374, 2265695734, 2284915338, 3206556658, 2832368439, 1417325431, 1582639928, 2632360018, 1712991880, 2547303465, 1517517778, 3660163307, 1046516952, 2374217362, 2927717337, 2513567247, 4244432732, 3248485883, 3851115926, 1003869639, 3947494045, 703696287, 1034178955, 1036111252, 1790993163, 3023345892, 3450329516, 1660808035, 3850898253, 1771224094, 579613367, 2072593500, 2421697040, 3247577931, 1513830843, 266394078, 1416619970, 1337774628, 1654066033, 3821326261, 1375198867, 1094040881, 1528646615, 3652940609, 2913873658, 1945416978, 1951666989, 3036904715, 2325875688, 1194681677, 1945];
const POW7_14: [u32; 719] = [1153105921, 3748096586, 978622910, 3057108446, 4163170541, 1475680606, 2896837077, 1817581710, 4230906863, 923122206, 2922006298, 2809572217, 3083308048, 231281980, 627002913, 106338948, 89650935, 1486504804, 2516894440, 3179661582, 3612364719, 1773194738, 4088816374, 354575531, 3666777246, 1576096274, 4233470586, 2095621999, 2970035246, 4110595912, 1358918312, 3628722034, 1149966972, 591400841, 3187581789, 4193396823, 12888783, 574915035, 2249808107, 3381397609, 2623734857, 740709562, 2546218981, 1725780745, 3351544684, 3633549760, 513705480, 3197256058, 1040246531, 1592866823, 2459213266, 3905053856, 2914075030, 915653484, 2333738230, 217825286, 2444620904, 2078822099, 608853997, 102326136, 1311845337, 871277544, 820523394, 1738639497, 4065841057, 1613004231, 2660853222, 2868364490, 1224390301, 513979072, 2055102626, 2109197819, 2669136545, 2085059472, 662164683, 394805015, 3659253988, 2984019579, 2109740354, 1779344816, 304690248, 1330182754, 2018784696, 2900087501, 3007768746, 2102207330, 2981687066, 612325851, 2279869201, 1529453769, 1972024802, 1499876922, 516721211, 321506622, 2707831412, 1201984786, 2336323361, 4219002744, 438957379, 828217643, 4194939659, 2231811303, 384618266, 2593821208, 3563124922, 4107917569, 3403654838, 2049628812, 1052405170, 3716531778, 1929466028, 3972824820, 824258969, 2497221351, 4151283990, 3657604243, 1007508491, 2276339330, 3866424680, 2244938938, 1571583002, 1949328097, 2674201210, 3934027974, 1820081934, 373810442, 1158794837, 1535976805, 2594293063, 1265703501, 1302223049, 1577048594, 151730989, 611882750, 3680638713, 1504655705, 2540403722, 3694579162, 461807637, 3019726503, 3612147647, 3015269393, 2204949105, 526872857, 1035176768, 1835861107, 2364218155, 2681021965, 2554335141, 1288907257, 2605885745, 3807016274, 2952394860, 1044216606, 82999816, 2830344404, 3205579736, 3705177523, 2769864739, 1456121549, 3573727012, 412745620, 2189310813, 187260800, 2590038269, 2420082833, 2314343445, 4136873716, 3047185979, 3178516382, 3032609299, 642806458, 1454301025, 82252124, 3275337515, 1734026600, 3741465849, 2676973446, 2749492780, 3078811183, 3652601975, 523379590, 3297473030, 2317427843, 32842235, 2816337061, 2475200552, 423232845, 497187125, 4214825014, 2174134877, 1493591393, 3250970901, 2332110719, 3959711000, 3929962791, 3625751890, 2435618294, 197650571, 2581084028, 359459964, 1836929608, 209890023, 703580385, 2177789617, 951344639, 2664644557, 2436893896, 2571451997, 3806745872, 3547944748, 4040254763, 386888799, 140028986, 3881171361, 1501141365, 4056634011, 4189900791, 1966959141, 1613488508, 989474367, 854455994, 136161545, 791237984, 3698679741, 535816137, 979707224, 3335735253, 676376709, 1517887200, 1144246118, 1274409907, 1616516914, 912735086, 2379244426, 2517318681, 1597046559, 12333141, 1073220241, 4220849166, 3636789234, 2358542730, 54029752, 1937294786, 2672023367, 3546104798, 3811752789, 2427341597, 3076000293, 1991184063, 3753278648, 121003404, 3652600541, 1984852734, 912364563, 2047474216, 1935941550, 3764307070, 1582175758, 127440725, 2330212039, 526839080, 3312028891, 1394970791, 1474372973, 2540744706, 1738211591, 3837815516, 3252079654, 2301442285, 1613562956, 2499277553, 3441096592, 2747500539, 2287259636, 2807578121, 1677289991, 1665996425, 2217022758, 3756818249, 2980850970, 1544637470, 1633921400, 4205764903, 792411862, 583762863, 2189836678, 1922953239, 1346364866, 3014148848, 2340843708, 1670072191, 1255400575, 3606338005, 2570968473, 2425790420, 707900326, 2143152343, 2745029367, 670293110, 3999614746, 3370996986, 491656146, 1532127729, 77134227, 4178304080, 3558559758, 3725562259, 2466603336, 2438859951, 3311034008, 1514769094, 374651559, 1633871428, 1447594957, 2427805085, 2684566455, 1732135452, 757320869, 3768098156, 3397376950, 1480382334, 588057005, 2957530935, 2011613980, 1687967416, 1777963549, 1233920782, 2294471781, 112108380, 3009690358, 3736688893, 72034545, 4246427889, 2695216477, 530287243, 2050752351, 652291986, 1662763440, 3689402310, 2144301097, 2283252203, 3479162609, 3066689563, 2807261412, 4146952328, 1437257025, 55350497, 3459772015, 369017485, 738846542, 805222689, 2961340083, 3475656112, 3326516981, 2800947885, 2336052516, 2654129831, 238976140, 83443562, 330221668, 3317802863, 666725705, 3383708319, 993009182, 254579037, 4242485096, 1579429492, 3811867359, 3450480200, 1481985188, 1482644519, 2910231812, 3308446917, 3011690497, 2304226970, 1134916107, 488410008, 857142045, 3986457525, 1456260330, 843366222, 3304110132, 4138476730, 736041681, 1547352989, 3049665367, 3506381443, 4124716701, 3381880597, 1915742763, 1808725730, 4105410130, 2198569419, 1386329308, 2356293163, 2685388559, 1719133264, 4228371740, 1468536490, 2067459757, 1718630680, 2324243436, 2952968880, 4076335840, 2403998755, 809862168, 2806524602, 2802419727, 3923693949, 255077309, 4150937580, 822572440, 3602578857, 1263840496, 2488015830, 902056622, 1643356219, 2838629771, 3610298087, 2179873862, 606152528, 2437557331, 3488800879, 876430535, 3098692439, 3125969266, 3160034175, 3523921867, 115637708, 2818674504, 2793552788, 3727731629, 3585445699, 1835434236, 1669933918, 3922127915, 999653945, 2175581148, 3020535201, 3928723015, 3317467748, 1944034356, 217205701, 378862281, 807325426, 867399702, 290496724, 175373522, 3580436040, 568376999, 881149950, 1005592714, 1887045576, 747546941, 2914821352, 3305251061, 1279405556, 881399316, 547602040, 200297724, 1560896296, 2935557875, 748832393, 373218117, 3073301090, 1618010803, 2434671440, 797497944, 419297674, 1553563068, 2313622833, 3559700525, 1635613056, 1123818923, 4112032971, 528915762, 2109047881, 4145488685, 155480440, 2423616749, 1183660032, 2477160975, 828160843, 1484661647, 2471164875, 1489334933, 1012896981, 2338203819, 339361895, 4078634584, 2068779935, 1102030564, 2402077859, 913116273, 809671166, 3761753718, 3940674856, 1742006890, 3686867776, 3967164332, 3646017009, 1331274146, 1731062675, 2538196931, 2828367729, 1244400705, 1319780385, 1316177888, 1870289197, 1316080050, 3170658907, 4107182519, 1177187703, 569255601, 479247227, 1380242537, 555072541, 2004418401, 4282549996, 3119355810, 837186318, 2369247570, 1099970852, 561838147, 20602717, 1138744095, 2891632962, 1493526963, 3499306068, 62201839, 2433802059, 894372251, 2751097797, 1714035873, 3101021033, 2512576194, 3972865821, 1099362247, 3724167579, 1331499754, 776982313, 904336468, 2796586040, 1946476205, 1306766676, 796080494, 3388182499, 2603454905, 427659975, 4154723015, 390160151, 313493660, 1526895795, 2230189943, 4227662425, 3170756818, 3030306231, 8858515, 1122624576, 2923206001, 3469487704, 2441063536, 4202927798, 4084007727, 935649002, 1963520419, 2649713081, 3337381769, 3607591719, 78688266, 520191842, 4042543809, 2517983022, 266942687, 2568707342, 1145096805, 2989583839, 3454749423, 2941347316, 433006007, 3385957842, 2158533973, 1297931376, 1287013961, 2104630109, 2054364877, 1545615453, 2448905893, 3540073710, 1623584004, 1967252767, 1994341042, 1310732054, 2013842419, 3333117969, 2210515758, 2296487942, 1395582116, 3375670959, 2892151175, 4011817996, 619230196, 495042200, 2620782475, 1695574355, 553255419, 3803106015, 4208410060, 2286831406, 1193771919, 3298509554, 3411559309, 4180378230, 2855176103, 1875028861, 2414766865, 1354638132, 4041297731, 3889126499, 100683305, 774308857, 2008948704, 2621007698, 1317839822, 1977505935, 1699489450, 1576232670, 1207737392, 1880318149, 1893164693, 4268540102, 1446410475, 2209518770, 2798189966, 295412899, 1449048199, 1905265270, 3671064440, 260580421, 4150015275, 3668501119, 2341543178, 1698397458, 1549193903, 2671077356, 313973002, 4188990811, 3758641278, 2621061863, 3011353435, 3720176335, 2831212049, 3900897064, 1409175473, 3103835334, 3443002515, 2562592851, 2448088013, 1820389257, 1450260636, 1771109840, 3036330463, 1646746416, 518150615, 1801754979, 3595046886, 2104281978, 2267537723, 857190932, 1871647842, 2990058049, 580273327, 2686857724, 1637859671, 2414777686, 3107828639, 3139674888, 3467628273, 2709878525, 1038907005, 4075121701, 2814464206, 3864794613, 2660278673, 2599961839, 2030885286, 2827273080, 527219392, 4018232299, 1368084053, 3869553637, 1389963880, 1571327879, 4225101988, 1861605877, 2197582553, 3851374488, 208574880, 1204848641, 4294490766, 2842385856, 913263915, 1958032961, 1454915737, 2843434041, 2490051537, 2118049584, 4281828637, 2544353302, 1823440601, 2427463976, 89726641, 4097444643, 1640965918, 532209431, 2943387299, 489422232, 3784107];

pub(super) const POW7: [&'static [u32]; 14] = [
    &POW7_1,
    &POW7_2,
    &POW7_3,
    &POW7_4,
    &POW7_5,
    &POW7_6,
    &POW7_7,
    &POW7_8,
    &POW7_9,
    &POW7_10,
    &POW7_11,
    &POW7_12,
    &POW7_13,
    &POW7_14,
];

/// Large powers (&[u32]) for base11 operations.
const POW11_1: [u32; 1] = [11];
const POW11_2: [u32; 1] = [121];
const POW11_3: [u32; 1] = [14641];
const POW11_4: [u32; 1] = [214358881];
const POW11_5: [u32; 2] = [772479681, 10698505];
const POW11_6: [u32; 4] = [2875311489, 3456163242, 1429612321, 26649];
const POW11_7: [u32; 7] = [2585905921, 2073480325, 1636806860, 3370723472, 3947938656, 3233553771, 710186941];
const POW11_8: [u32; 14] = [725390849, 983511997, 1546466724, 1452173552, 4110885543, 3594965768, 3109748563, 3754293795, 4268788147, 2994526333, 3490277564, 3382469739, 833985310, 117431742];
const POW11_9: [u32; 28] = [4267518977, 3418704948, 4145983365, 2633889206, 1401015784, 2168955970, 4023491585, 2524575715, 1049283211, 445723862, 2434794608, 580179552, 2985579862, 2834866824, 480627468, 2191904507, 996937640, 2935962584, 1843145488, 1510931281, 327439189, 27267795, 129172641, 339183348, 3871693391, 3654642246, 1800239665, 3210784];
const POW11_10: [u32; 56] = [4232730625, 4097932706, 1490802744, 1867908586, 2724996515, 2011879905, 326698679, 4127462488, 840325205, 2229494804, 1262994467, 482469434, 1420581911, 3335497932, 1947974370, 115845259, 107144140, 4106149828, 1698261230, 2710549612, 635562105, 955831875, 3553998392, 186570327, 2293025151, 3737801843, 2669890933, 2617861926, 811827227, 1669377375, 2900245233, 1521548800, 1807704428, 414015847, 4291805179, 2832878152, 4263613655, 1607020746, 4106685115, 1439641309, 1239778605, 3869166695, 2478617187, 2371970986, 314417574, 782839013, 2698203809, 2206976258, 2530586241, 2282465641, 4070492013, 3894191130, 926862392, 2441413722, 1215075862, 2400];
const POW11_11: [u32; 111] = [4141133825, 2032979484, 3524827159, 1779079378, 4024400033, 1736752743, 2286386169, 2281943783, 2312119071, 1441879824, 2106994417, 2198887008, 3538871549, 3308641462, 1802204363, 720418141, 784183413, 155727697, 400164668, 813106568, 422073521, 22474994, 2846752640, 2303474280, 2066227883, 1503268392, 250830710, 2090036307, 2739805682, 1001846430, 3888615633, 2916606130, 3948696965, 4099947954, 2539164700, 3619344625, 1436649263, 390608915, 4179636138, 1731812072, 3606488196, 2063647324, 350623992, 170798726, 1288828649, 1497761545, 2941359089, 4222238530, 2336294577, 2515641214, 197418423, 4025643045, 3210677689, 2358071829, 3406251140, 3112734109, 4192102319, 1407631921, 4084900893, 1332291286, 1473052503, 3193020458, 3582429336, 2287319506, 2689946046, 590828939, 1092703632, 3967962452, 1955093624, 3766411750, 668711646, 3860644732, 647459628, 3424440292, 2712061312, 3397247314, 3045422855, 1832687227, 1747645833, 1244959344, 152949509, 1075533131, 202325721, 815802040, 3793027242, 2431666777, 4145768276, 92597003, 3756449424, 771389754, 2833191593, 4152921425, 1032605176, 439850745, 1990627130, 3239738123, 2963980584, 3329048404, 3214391679, 3009295430, 3682028224, 220913858, 2536745075, 2023812800, 2800493459, 3121880805, 974926757, 2069202727, 720743103, 142305700, 5761358];
const POW11_12: [u32; 222] = [3869859841, 2854063917, 1889884208, 2022964038, 3603195100, 502071371, 474465694, 4152855322, 1398326773, 4275106380, 887147922, 1691233063, 2011450311, 388838798, 3801654612, 1331477005, 747816233, 1900605903, 1009749887, 2645734039, 1539916229, 946336119, 851071301, 2692816950, 2662152929, 588635876, 3187004443, 3576613079, 1981871555, 1738099482, 3380892176, 1796956124, 3397525580, 657292099, 2591699721, 3149742663, 4041201154, 2195797098, 3351045615, 904595538, 1334241505, 1521739205, 2828238575, 1038796987, 2547250474, 4200726341, 2703556888, 1739688469, 209829270, 3962781589, 4264971273, 1149735334, 2167150866, 939580810, 239676954, 3218166905, 1552866, 3227504832, 1404487130, 2131450362, 1742093842, 3923402526, 427152929, 2927933153, 2471455735, 1995653969, 162843970, 3235954335, 1548968465, 188747565, 45604216, 1855505400, 1992538720, 997981727, 1559880400, 3491821681, 1490986077, 1924332905, 621812681, 3676379956, 3975921387, 275936914, 4032514215, 3879034146, 3403485904, 595163544, 2554398869, 1953178592, 2826546226, 4184318576, 2722054308, 353502213, 4049756048, 3477037883, 1376236983, 3590379845, 3196628706, 3500798689, 4241740474, 867181969, 779564930, 3911113180, 751942860, 2089630146, 3098914351, 170156892, 2972958347, 2030930695, 630104136, 4174596611, 3610904270, 266982989, 584140030, 4140942458, 3586658039, 3868077426, 3846170377, 2104241794, 975478838, 1543171979, 66720657, 77614061, 737768900, 3576929742, 4024034598, 3067027138, 2170480890, 3649174216, 2001675371, 2111191181, 3801182046, 398908084, 1346485642, 4122990553, 382415280, 850245041, 3284568739, 2534805287, 2823194212, 577939938, 2036269819, 2937472987, 311426674, 367746621, 1689857062, 3424697633, 58605103, 11984314, 877875338, 444100515, 2306970422, 64456454, 3583517780, 4229732174, 4274921429, 2252255259, 3825433926, 1695539474, 1778915798, 2673475271, 2477589530, 25638469, 272317646, 2790651081, 1511598805, 2775216623, 2521592706, 1041000893, 755617320, 2097900204, 462265493, 3907772707, 1663734723, 3889590955, 3920735492, 2602716974, 3960180417, 1970046431, 1435078416, 2818559054, 2384120597, 3902012439, 3472928531, 3458904990, 1151760472, 2654969323, 1576704615, 3965273527, 1465371726, 1704948267, 3067789515, 2045561924, 1391284099, 296961224, 149394475, 636839124, 2476458570, 1406040725, 4203739580, 425906425, 3896729981, 1154686444, 243822498, 3013347645, 780439327, 3321355321, 1150372588, 3909023926, 3283498893, 1381234586, 3540879757, 1738538592, 1861402027, 2769530245, 3578873312, 78385056, 1954255545, 1485602757, 1588799125, 2673761104, 1739122459, 7728];
const POW11_13: [u32; 443] = [2974990337, 886810347, 1235367469, 3247998528, 1266708286, 2281334753, 3508173699, 3584374607, 927020900, 1956332791, 423255369, 2478161032, 1110082262, 179285634, 76779911, 2944469863, 1014042971, 3004104218, 40989949, 1097347567, 2144381125, 2982306288, 1594568231, 840934796, 668771519, 2512929418, 1926593062, 2286317039, 115375215, 2422055400, 3496946850, 721689833, 1760159277, 303610295, 3444971505, 4005211476, 3030238888, 2747270777, 471274338, 1231716495, 3743325078, 1580360895, 345974508, 3614608741, 4290395798, 4142762147, 3552241329, 3959257273, 3114916710, 2989797040, 2743528887, 4144868575, 2329751946, 2023346244, 2722914919, 3963062858, 3805443369, 2843879915, 3376707268, 452779392, 4202201503, 2882236683, 3983056802, 1841321863, 1943804249, 695628442, 2250666831, 474733573, 1309970587, 1574342593, 3436394886, 2079535374, 1473583641, 1801902801, 3293611912, 2392725287, 3312283079, 1033749601, 954822500, 3163673053, 2185522280, 2463483901, 1770933757, 786641795, 2301956811, 2686259278, 39312491, 3914666264, 1762789717, 1837306708, 1007435468, 2177160075, 3296655398, 1282950346, 2038964665, 2580894214, 2751586561, 2917187922, 2937144239, 645598957, 2684220382, 2702748272, 3590116382, 2459018264, 1540131195, 2198036930, 150782656, 2604814448, 63350345, 4217056873, 888507216, 2197882270, 3540801146, 2903226106, 722862329, 3395604303, 3970614305, 44729879, 508855665, 1572645425, 1260787290, 1054909269, 3167223460, 107910164, 3952497435, 1466355981, 3846625768, 29242262, 3180243996, 2569443999, 4266302660, 4103339395, 3283032177, 3672978853, 594635929, 3416582250, 1237100891, 281707214, 390060316, 3627008920, 2684206858, 2926850740, 3020008643, 2691769288, 3673654227, 1082908754, 3040464583, 1704951909, 3794131135, 2749543778, 718192982, 563547953, 2828954940, 3959732687, 2656908980, 2138436744, 486521795, 1171424981, 1625045989, 724353093, 412005125, 3032400303, 1828341894, 1945517046, 150116753, 773231125, 1705584394, 1466940545, 859075406, 4132076121, 83313068, 639737848, 1676217023, 816236605, 1497752199, 823896869, 3749261953, 1261979817, 2748516810, 3621634515, 4030362957, 3373576215, 298434919, 1129231193, 4262487017, 3332018489, 4019029330, 2163521164, 1079519614, 2725808019, 3541407711, 2631878018, 2548421851, 2117515271, 1054311869, 2464880688, 4203703314, 4181753824, 3365161331, 2018783743, 2560337842, 2014785831, 1932415105, 1762245993, 884237557, 3230276329, 20454952, 3683272639, 356236860, 3499440238, 1990782775, 3224132926, 416822690, 4242275363, 364749046, 2007597332, 1605047707, 2521834722, 1912978517, 810916178, 3542071297, 1801734579, 1143093630, 556038080, 2067456433, 1014687787, 232532349, 1748043586, 2069484578, 20784607, 2276087048, 3157699876, 1968607472, 3831090736, 1654015548, 3726576643, 2830024300, 3647816176, 4099267749, 1298173212, 155940039, 2428617961, 1546314543, 2714667295, 2830915896, 1139822374, 797836549, 1418220596, 4066046461, 4146345735, 2259397643, 2228421691, 2468365576, 1370849257, 4079360423, 1139661317, 3949688523, 61570993, 1159761556, 2811376232, 737984647, 1393665393, 4010402903, 2079282959, 291080581, 135460766, 1037662671, 4177242690, 374053900, 3682728148, 94673243, 545582988, 3154559367, 95206075, 363445988, 1013020252, 428519276, 3952976820, 555114629, 928853924, 2720137936, 2746901602, 3444735454, 600310186, 2018362055, 1843342515, 3880080454, 984961881, 3907780401, 3056144783, 3184949149, 3950783192, 193469505, 2635151519, 817462585, 2945037563, 1993534483, 724379440, 1333667479, 2492836205, 3381464640, 3368271876, 2031170389, 4067633372, 3924918837, 4286754266, 3458306614, 734339222, 614342218, 236164084, 1584809905, 2111183392, 1306657771, 2141200365, 3124308398, 4270571755, 3550451412, 478128667, 2686883913, 3611569215, 2910085506, 3018633570, 273750991, 1072897033, 2493114187, 4186065849, 1596097473, 3699214752, 339363728, 1441513643, 3507673604, 3995323433, 3867827003, 4077574071, 3757981427, 2425459708, 627460790, 4206690153, 664849414, 1445743014, 787429280, 1567786561, 193640995, 1063599729, 1475528048, 2643870666, 701285894, 3591459499, 2279084258, 3955873780, 1287087372, 2251837591, 1146015384, 3051667063, 2550050456, 2516734256, 4208571648, 598826918, 2304366111, 2851076526, 1993463006, 3839353374, 967227050, 95846598, 1609952768, 435034943, 3531583260, 2568808904, 3619367599, 1477226707, 51110073, 177139523, 3888931447, 769851956, 2495542158, 1592424566, 2778962622, 3834261637, 1659135327, 491759826, 1112811379, 2944548908, 2883134377, 2326760206, 2945056646, 3496435689, 1692799806, 349018150, 1764242425, 2855067765, 3748713256, 245165772, 1825448728, 588045899, 1967959460, 2182946280, 44403394, 618505048, 415106561, 1298153882, 2503705565, 513469357, 964967278, 939724558, 386295402, 3569810726, 4168598696, 3553597393, 1627215002, 2889135, 3373164162, 505222248, 489875874, 1209335956, 2847054290, 4284077100, 2379694006, 34096050, 1229732749, 1354001516, 3061649930, 3736286526, 1243461683, 4049558096, 1418890796, 3369219718, 945406425, 878930290, 1700641215, 4079722516, 2452574684, 314984708, 3198984676, 2894702689, 1109209654, 1293554534, 464385312, 32630398, 1116566508, 1339200257, 1072368191, 2675604766, 59728242];
const POW11_14: [u32; 886] = [4070932481, 1131894294, 2541580517, 3314335917, 2621222710, 2869536534, 2259585760, 308457433, 3075365252, 141385081, 2209617233, 342003376, 987047251, 2752647932, 415512433, 412750028, 3888010303, 1026392053, 531725674, 41885172, 517497408, 4045966437, 898789227, 399141194, 829183925, 3196159056, 1556167610, 3587980714, 1523862219, 1639041152, 2084734832, 3189329044, 1765573105, 2141192374, 4156227592, 979640142, 4121679305, 1782014569, 1070929751, 1648884387, 3147541389, 4220465729, 4098653625, 303180016, 2564515297, 530392946, 4081743324, 4022373073, 3566899890, 4108692210, 2801029917, 247188192, 3415226323, 1401953185, 1200397516, 2396501541, 1492430773, 3144686397, 1281203173, 191964542, 468640886, 1843861327, 1099663598, 462374683, 1868051233, 1403316667, 2830773658, 1278003691, 3698875734, 1490478002, 1251588998, 3783559703, 1288390447, 3599829920, 403631845, 501073745, 3628790866, 1995096702, 300244162, 2685729029, 1043247117, 1270609242, 1883655131, 4215435320, 4100429127, 336720770, 142595584, 1383060640, 2439149541, 1099753346, 53064458, 2638552127, 3353382228, 2610244989, 491489225, 3786668044, 2121735204, 1532806824, 1413969261, 808886062, 2568527399, 273744004, 2952477361, 2331629037, 3112996173, 112329411, 1544537734, 2946414591, 376685424, 2808148785, 1507936170, 3811722359, 1159670939, 3195571284, 285012140, 2124103551, 3578311259, 564467310, 3477123971, 1650281466, 2410688778, 3398337318, 2986299181, 3717975184, 3060601431, 4017903284, 2653122359, 4070291299, 849084145, 951004750, 1212614599, 3981119203, 2566703780, 1982735235, 846636004, 532784497, 1999973932, 3795100102, 2105545697, 1993347610, 1699669179, 2624964597, 6140530, 1674556546, 966678971, 2090523086, 3887825235, 3241893962, 2586004674, 1357877398, 2064685679, 2290546241, 992284202, 4202912844, 3927220794, 1079658617, 3440308624, 1453049536, 3873319046, 1718339831, 170237072, 2476995681, 385924417, 2221877126, 1588774856, 124201159, 4253033542, 3719812823, 4287560623, 3170521061, 1364694937, 2392634924, 2906240203, 3543369279, 3697755918, 1566290098, 3930668148, 519398905, 3876359489, 2333254569, 1947490476, 375504323, 4047613257, 1639438905, 2964150195, 1232039149, 291272726, 2474215855, 767387170, 852077576, 3180450827, 359841564, 798542523, 3380604431, 2033268447, 298113335, 2521370110, 3771794538, 3757914067, 1995944575, 1984985073, 3977002802, 3290665163, 4260261825, 3644465517, 3428014918, 3164649324, 2041307645, 3402977909, 2926411733, 545291530, 2445788464, 1415275564, 4187220013, 2556979554, 76532612, 1348025426, 506304002, 2479294010, 664845898, 2016498767, 2097610119, 412114424, 2532825482, 1545363882, 4019613161, 3830197079, 52003152, 784340115, 1338279932, 403817189, 3728186790, 4067803879, 995325116, 1394408747, 1326695547, 3494336040, 654333105, 4209872954, 468141302, 3081362583, 2113191305, 1628052800, 3960313831, 1850082798, 3855146531, 2163433175, 4280472630, 3986310002, 3667616803, 617338426, 1442514807, 1696333813, 3221981896, 3998802600, 930750551, 2045906298, 3174131745, 749316339, 2461355189, 4013720187, 3463722134, 3925206244, 903351518, 1436125350, 4246085443, 2955864459, 3038951335, 234079060, 2154079368, 2420162185, 2423173754, 2033757437, 1056733160, 1739561183, 2074753830, 2583049296, 2408306266, 2635307150, 3523389815, 2223713888, 1831163316, 278004040, 1130207121, 3269180378, 3373831537, 1667568560, 447719129, 104696336, 2978338186, 2656085147, 1145580331, 3213259943, 569625455, 339198509, 633080196, 1722577508, 2328208384, 3280823183, 1125969106, 3022600006, 1395727915, 668084278, 3511880526, 3676744300, 4169664813, 3126915500, 2003076035, 2179608109, 3092578470, 1002151320, 1741503696, 844041551, 658131435, 4289916842, 2198587284, 11810130, 3188560700, 1612596425, 947822095, 3422109094, 3145469557, 2317999441, 930277130, 3775579768, 3609086377, 1009443894, 2280721933, 4202076109, 366005216, 3941500782, 3060068449, 1633301684, 2245956492, 3366817402, 2043701019, 1885260207, 2300661209, 1521660573, 1980947376, 3952259346, 3519811464, 2028050103, 3836092415, 2244422455, 2212774592, 1350469798, 3297244715, 2291378428, 2333522621, 3669290718, 180390701, 60300764, 84512031, 2268736806, 632136814, 3182303842, 4119844270, 3259697275, 282630540, 801642006, 2803409553, 2595474417, 2341819055, 1144853912, 525300043, 1135530042, 4229268371, 256930731, 2961900081, 127363863, 3581059085, 1296651780, 2140749214, 974771997, 324842794, 3893679710, 2062677328, 4222442, 1791165587, 859905573, 4116030842, 2946754764, 1176093473, 3167096377, 2766703440, 1003207502, 1268406517, 2969773597, 759332428, 803908399, 1633524313, 2588734550, 2886893338, 3804778649, 3871545617, 3679188802, 1039963565, 2302174152, 2683894558, 1011336061, 3468446669, 3864182200, 1733740316, 1940646178, 143259692, 4252132355, 3590449941, 3046112866, 3705447583, 257756962, 2427814998, 2430857633, 103329624, 4077938023, 1303147448, 3602884249, 1475689568, 397342958, 3081227134, 2830662621, 4138610654, 97172805, 2119432886, 3306055932, 3109151444, 3729428721, 219796604, 3232963899, 2090178124, 1302726280, 872678205, 4199692655, 768054, 1732174930, 1964058489, 632528501, 2759426115, 450224041, 3800921670, 1009505843, 1400793450, 2940475260, 2713485302, 3113099991, 319009507, 2285161383, 3440575161, 770343811, 2509003244, 1340453413, 1032213360, 3878004983, 3454397903, 1154514660, 1090893710, 2576207997, 1724848192, 1985365162, 3538901477, 2447045019, 514898869, 2283491244, 2368316641, 4063318665, 2986655158, 4076216358, 2550056126, 2878339444, 1148639848, 837491563, 1704283458, 1378661113, 4098522605, 3371463500, 1030746799, 2917554515, 1341204917, 3387830943, 611879271, 315404268, 3294079476, 86241882, 3748484102, 2352320584, 774672579, 844276536, 1249900953, 336052797, 2151721035, 586962547, 3641645058, 2341962484, 2208872600, 1269015893, 4105434232, 3543579581, 2965497267, 4023218637, 2321691548, 3392055752, 3997297637, 1959011850, 96508499, 766563511, 1356783068, 1130708583, 2005327310, 2753738818, 155641301, 765599089, 1045643795, 417019531, 4279177501, 3141781224, 2330999246, 1175129605, 3274946160, 325263414, 3715586975, 4087778066, 2820246349, 2953573922, 314003702, 2427613123, 4290348179, 992235384, 138456964, 2981343154, 2109809464, 4284604113, 3950505789, 881086028, 1738915794, 4189931245, 106478441, 2642176795, 3416075864, 3989123265, 387883555, 3991266157, 3972565066, 3187826264, 338642415, 1495975504, 2136825939, 762375475, 508049359, 131999286, 2970554320, 3966422178, 2705492368, 4289705839, 2104019310, 596636472, 3065570912, 3289124724, 1855567379, 20159508, 2457906835, 1788340431, 707498337, 4221485148, 2706774190, 4015950809, 117987882, 3035391549, 2524048164, 457807155, 3396518424, 1288466349, 90439263, 2164109950, 708733436, 1355156843, 2280665581, 1737724469, 2022775283, 529606498, 2452894920, 3461564193, 1954946106, 3609082938, 4218678935, 1298958447, 3837284047, 2129379103, 2948380137, 2299353551, 1424725141, 536058925, 503230181, 1996902958, 2400752447, 1496876021, 3404123439, 2358739091, 2151289701, 1443733466, 2818061111, 3082508621, 2709122055, 992958633, 1512850725, 3012822226, 3384645338, 533725542, 4044430918, 272943741, 943999291, 1766065436, 2877732382, 3835412802, 718108910, 1397588672, 2680041715, 2282977712, 3270916867, 3722273660, 826652679, 4143202450, 1650020929, 4010941523, 2718815727, 1602960184, 1427517158, 3644929012, 857260087, 3243666693, 3340410932, 3676495307, 4030353869, 2792872295, 2156212200, 4025830339, 3870363358, 3850982905, 2546524745, 1538610575, 3594745811, 3951971938, 3137413934, 8469919, 4235244239, 1270322934, 1228060597, 3877519911, 1160386569, 2010570083, 1629837228, 2571271563, 578136632, 2489161866, 655133121, 1500184496, 190202049, 2458685579, 403297538, 778321025, 3734551682, 2631438217, 32541742, 2466777289, 4128937423, 893637377, 1073285338, 492763568, 3239505966, 2269081088, 712333859, 830437732, 3447526734, 3696521755, 1296725656, 608606261, 3347056464, 2897155532, 1817848162, 697798988, 132644033, 4219025119, 12060084, 1451516218, 2212982342, 3664925880, 2146221586, 1575731675, 2533044067, 1755593894, 2058968296, 4290028320, 1455009286, 66037293, 573802245, 3036270415, 2552709177, 2564995126, 1200668905, 126743679, 1273110179, 1437985708, 506765039, 375995703, 1631860051, 337395672, 1544295859, 139177756, 4224519853, 1160719268, 1886998076, 3127117391, 2088826595, 199063578, 1399636190, 2790105408, 927425914, 3200190318, 904924367, 2965435123, 3940870390, 2208604356, 3726163018, 1459478394, 338517128, 3779374617, 992010876, 551173706, 4223223345, 3035093341, 3888145231, 1232373136, 1733768816, 1795904673, 2551527730, 2752925555, 1196709495, 3342895187, 4110270879, 2743430114, 1754629452, 2348271519, 1771309554, 2341244584, 3390218226, 1385211349, 3063788339, 2485171731, 2885497667, 3304778666, 1809504693, 2992696783, 1428344003, 623630415, 936927397, 1569189475, 3214559426, 887178239, 2619861432, 1890694716, 1535366889, 199677522, 3432642120, 3647950708, 692899641, 1637087898, 2749418322, 1977363022, 4099800292, 2404536715, 1423983840, 727951753, 3983837110, 2974501161, 340512213, 989883469, 863907583, 2582484458, 2586599347, 944006389, 2185993602, 4162703295, 1418591485, 1362602198, 3388441084, 1053587319, 598791580, 1292863440, 3094564285, 3653072303, 2477921523, 670324931, 242053704, 2706816646, 585803084, 3709712346, 1235872749, 3683668463, 1248998175, 3313218763, 2228491170, 503151767, 1010983578, 2816330914, 3218773763, 1596737466, 3055840371, 2168180487, 1523514012, 1495001033, 3644591539, 444548763, 296729366, 1778637469, 1193855794, 3405789531, 3354183376, 3728215902, 3103751643, 1527238010, 2420400493, 1402016200, 1617688348, 3238327513, 1969615161, 2342876063, 3288511060, 3790922492, 2000550945, 3318981623, 4021432786, 3510791403, 2331892605, 2557162884, 4202413135, 3305792408, 3474494290, 3325017089, 3904897310, 1684472309, 3007641723, 4154313981, 4276823588, 2362703100, 3764623176, 3532967864, 476776680, 1141442939, 306204369, 3779583093, 3291937717, 3308501447, 192247119, 2410509919, 711399214, 1829817082, 347516703, 688605891, 4157145667, 352944182, 3251086987, 3719124641, 238052721, 209502934, 4029082102, 2806990453, 3373411417, 2081377628, 828649400, 722547061, 2282664078, 3575173360, 1359901770, 2464158424, 4066308244, 3464822223, 177133317, 4226125148, 2593495596, 829439895, 1047772155, 2185360966, 3933664574, 185903185, 3163334715, 3001227763, 830614];

pub(super) const POW11: [&'static [u32]; 14] = [
    &POW11_1,
    &POW11_2,
    &POW11_3,
    &POW11_4,
    &POW11_5,
    &POW11_6,
    &POW11_7,
    &POW11_8,
    &POW11_9,
    &POW11_10,
    &POW11_11,
    &POW11_12,
    &POW11_13,
    &POW11_14,
];

/// Large powers (&[u32]) for base13 operations.
const POW13_1: [u32; 1] = [13];
const POW13_2: [u32; 1] = [169];
const POW13_3: [u32; 1] = [28561];
const POW13_4: [u32; 1] = [815730721];
const POW13_5: [u32; 2] = [1778525249, 154929377];
const POW13_6: [u32; 4] = [1780897921, 912625740, 57455785, 5588660];
const POW13_7: [u32; 8] = [954528001, 2552460193, 811089956, 1065775915, 3255164516, 1007972746, 118568612, 7272];
const POW13_8: [u32; 15] = [2628444673, 1667825520, 3480482745, 1792807966, 2982160738, 2216443239, 1414760918, 1741036037, 3705043424, 136135250, 395110073, 1084641480, 2452973265, 2183283898, 52882385];
const POW13_9: [u32; 30] = [685360129, 1249145954, 645630652, 1995019793, 3253088488, 1804068787, 392320294, 1343267562, 507087513, 2330257028, 3658736453, 3072903141, 2377702882, 4240373633, 2610933614, 2563321149, 1240024358, 1174015769, 312909694, 3764772638, 510500093, 1167371064, 563930725, 3086997765, 1545500121, 2429233725, 68804066, 1863990200, 3296313385, 651121];
const POW13_10: [u32; 60] = [801343489, 3687300930, 3650812618, 1292855309, 2657805576, 2016037326, 2874760646, 4032262657, 3967567070, 883767154, 3799873193, 1340661027, 2187028009, 519274923, 858329769, 1315293196, 1461381497, 2243176904, 2753124609, 1955575782, 3920557849, 3872634657, 1019315217, 2838082753, 4120836809, 3754077040, 3026025179, 3031194929, 939865930, 3056830274, 985854548, 1576100855, 1107911373, 110425770, 1299195383, 1944865273, 2937643568, 2194411508, 2836927120, 1383249273, 57765149, 3867259877, 1932068233, 109231726, 906092787, 3309745783, 2104989599, 791524559, 2729013296, 3986268043, 477685452, 2884389037, 612321482, 3705313463, 2993214628, 3749675120, 3978557831, 3791485445, 3052761081, 98];
const POW13_11: [u32; 119] = [3620147201, 2520448972, 3203085989, 1217137342, 484743908, 1266092962, 4017933550, 613421828, 1157475910, 1814056583, 2810379772, 2293156651, 1965199283, 1927758316, 2374138670, 479770094, 262749610, 2384139334, 1670384786, 2884741713, 3251648127, 2797691182, 2810917987, 3630241364, 2157703366, 2088147519, 1236575574, 3715291775, 454175536, 4102988862, 2473058752, 663798426, 2536668137, 3238952308, 1835701502, 1702835847, 1052170065, 1687755339, 2826467910, 1535016938, 3193994837, 3446775204, 2204416003, 3656812722, 2730402046, 1893756449, 2053075260, 860659233, 1806071445, 2655250301, 4258151335, 1844307072, 1274603853, 1527617519, 2253700363, 2821044754, 419774276, 527694400, 4022163085, 1101339995, 2025426409, 3797830892, 3487708653, 3598614153, 1916423427, 897070156, 1895034986, 413560392, 280773718, 2448371825, 165282340, 179165469, 1030808076, 39526810, 3877992771, 2162336219, 2334849212, 3701673118, 3052707624, 1966847591, 2558342553, 3106702943, 1120734167, 3082482115, 117878845, 1243873970, 749558131, 2716083794, 2654625971, 285288667, 1341977361, 3231619945, 2142906861, 3563550616, 1991443713, 1969042993, 841057806, 1671882063, 2685874009, 1179964040, 3849314352, 131899846, 1283609696, 3137550223, 3712908318, 3301971787, 3577169086, 4263774890, 4235897085, 2488576797, 876167408, 3032262832, 797148112, 2583748789, 886261242, 3063930978, 3840348196, 3510548215, 9743];
const POW13_12: [u32; 237] = [2425233409, 2574743363, 4101624837, 2153042727, 1531252719, 4036354306, 2401474531, 2403619786, 1719472816, 350359211, 451450518, 2224633991, 1428121154, 1999448647, 1585463868, 1206872105, 869324018, 848230480, 2750061047, 4284173396, 486383658, 831827024, 675124885, 984738848, 2138354606, 827070744, 3016864193, 431856008, 943413656, 3266222201, 2837427173, 3463873313, 677794294, 2548501243, 178001789, 337320639, 4034985727, 1808420373, 1344978182, 3912589803, 1033442872, 52718543, 2250494829, 3558544136, 3122831758, 346404849, 668684072, 2406040350, 2420354654, 637393673, 4098750334, 2939549086, 1264791761, 2859564186, 3468812613, 4008674017, 4254115003, 2544764869, 3867714930, 2529930645, 1851568576, 775869569, 1482041037, 1137060211, 643668385, 4102840359, 2555794241, 206916058, 983377758, 1396985722, 957949107, 2024380604, 2199022796, 1499271974, 469023693, 1177083598, 1752268915, 4060513915, 1446807110, 440224784, 3705711514, 1983674577, 3576135134, 2983057703, 3538843950, 2737247417, 1005612404, 2991215791, 983614109, 743993101, 1647755052, 1259263581, 319781774, 1611804733, 1083833261, 1208608074, 2367174970, 3194329404, 1177756119, 2474980291, 2369559203, 2068529994, 1297717025, 1454638114, 2734555032, 811712058, 1336242572, 2310255276, 2387114925, 3271408028, 2502887356, 2094479200, 474660715, 3350628624, 3403940146, 2050141589, 1833993774, 364733640, 3218126981, 3477723798, 380035144, 1826185561, 873938827, 1714280976, 1858073373, 2083003323, 1474730733, 2882374875, 904986443, 2473857363, 3269354893, 3448104725, 2169444320, 2235183121, 2575197543, 2290535644, 1321689261, 1935808522, 1112616083, 1754300357, 1425341447, 4085151395, 1182577983, 1254051060, 4119729564, 2401638640, 3454808266, 2309994520, 1640684696, 1224355549, 2182651080, 3869604543, 1863319579, 3078167217, 1904866486, 3792869478, 1355205715, 1864150525, 299187236, 1185533991, 882246841, 2345090191, 3112757939, 3285727616, 509028476, 76970100, 3315151085, 3688079555, 2862397804, 2196302659, 1155354124, 4085531211, 3884726114, 2096383930, 256229858, 3034840193, 823572967, 3539255498, 2332934609, 1314879257, 3110127578, 3138071632, 424647373, 2353538903, 525324637, 2245908706, 1032785158, 3572623713, 1981528100, 1742376255, 2042281104, 2047789421, 3137387214, 4164202311, 1795955008, 1524631721, 628395172, 1467338913, 4175798669, 2970351306, 1934462376, 3084449096, 3326694779, 509857835, 2919086400, 2663173614, 2779131459, 3282039794, 3983826989, 1917509999, 3495152555, 4174987179, 4092034002, 2311496518, 110257144, 2327334555, 2213388081, 2124473154, 3729882918, 4189444486, 3424543753, 2265140621, 3633421397, 3968371473, 33820435, 4070867890, 791648135, 1518365079, 1843767356, 2800735357, 3415928287, 1970816581, 930922651, 2933175509, 1383619664, 3467804447, 94941976];
const POW13_13: [u32; 474] = [2770092033, 280224110, 246091942, 374836744, 3607013529, 253512952, 177646904, 3922117122, 2148254347, 3223611726, 3865501515, 2626156833, 989547111, 974283937, 3003459491, 3170742052, 2589703124, 2581400182, 2165153230, 2985830471, 1475784315, 3504033590, 2881668895, 2316680387, 3511038643, 3397084274, 2578493341, 1960520677, 73504101, 3051337079, 1504567381, 518177353, 3575573965, 3057255272, 3216184760, 3346547012, 393673973, 317565720, 957485750, 813335576, 3709344008, 46126917, 2611447377, 4126735737, 3595823679, 3611359744, 2031678107, 2191428280, 1411860804, 3051745288, 3280383825, 3335460735, 2226183551, 4025871240, 837606713, 3006379156, 686664223, 2768120872, 339578215, 3917147530, 1273686782, 1549830028, 3078670208, 2494099685, 1042732950, 3163033797, 86441987, 1281815991, 348421568, 217001506, 4017340371, 4019844214, 3556283649, 2146097930, 2270174349, 1719863819, 2763306949, 3697682472, 276478498, 1999857109, 2253852500, 2852185129, 3282813689, 3353376613, 394482546, 3535818980, 1110676660, 3186472404, 800893469, 3992983194, 2176615172, 3948360834, 639471592, 103908103, 202243463, 113430590, 1331890480, 2630431929, 528384611, 1600167062, 2598772260, 1912111261, 4293437669, 776014103, 1566456533, 1609790320, 3159532308, 2128884070, 1533748912, 3911012398, 2872566187, 75228133, 1378524420, 3108914974, 3868458668, 2981751804, 107089968, 4253406523, 3961903717, 1020359712, 2004968899, 197361203, 2041843185, 214556791, 4079590443, 794785720, 746147898, 1233829155, 3762541793, 3863505596, 3628747110, 158785463, 1873132594, 4010432341, 4073167215, 3179777450, 797445362, 3710062573, 4223428401, 1389616073, 1893581875, 2546613520, 1245613358, 3803671791, 1988518811, 2888476702, 2567029727, 2341492200, 3193553523, 2222450177, 714099752, 1450703628, 3150528499, 401219602, 689603544, 759986930, 3078711132, 2808389020, 2591337821, 3677239533, 1644870392, 645042089, 2259101651, 2035601092, 1917023803, 2922085335, 4187753069, 1317058292, 2373086190, 3513129050, 3133275789, 2552447641, 2928047049, 2556372464, 1909569339, 3211899072, 4676947, 1035632270, 2488097790, 9003917, 3830909762, 1434251395, 866919600, 292794276, 327039161, 740061955, 3686185869, 3001893598, 1400171098, 359791510, 3510621913, 3461839011, 2188755022, 2894813905, 3662814350, 243919073, 1670424940, 2987320578, 1546978015, 3950456083, 1167806508, 3562314041, 3879472154, 639979027, 2408265652, 3361581149, 1465489790, 1195818519, 2217402719, 2691027340, 2017525845, 2317038524, 3174058830, 2120025818, 2688173402, 2943399075, 99619204, 3434080855, 4274885553, 1820238284, 1763571765, 762452581, 79715782, 2145788487, 2661559287, 648455633, 722916325, 1850179877, 3031761966, 2300516444, 2624237337, 1702671866, 3569612857, 1582992344, 2684356765, 1210899082, 1397665657, 1271600252, 3524956906, 1552340482, 1363082597, 2529231496, 2542055832, 1159800647, 1169650988, 4285318734, 1452462859, 611511573, 3612626278, 587667021, 3623373186, 2194342199, 4291509347, 2185971813, 502535224, 601182308, 3908631698, 805942480, 1879472563, 1607395107, 1129122572, 3298848373, 174698773, 2785240237, 1444202161, 4243527810, 259356752, 2850901382, 3933623322, 4115636047, 547038038, 3655462568, 3502451555, 926079503, 1722207232, 4138993533, 1039107710, 3298283152, 2282624588, 2945236299, 759263377, 3391272306, 3433251348, 4265990061, 3149069185, 2403408177, 1162778116, 4134714139, 3813329316, 1171827073, 400581629, 3009999040, 4061326516, 1261810447, 511899134, 2451111623, 1355824333, 791974327, 3686088002, 4101109368, 219973590, 1120035633, 53961656, 816734567, 979301214, 3640215323, 3764031081, 2185919590, 860594344, 4206263253, 2200598939, 3583011712, 699277704, 107496135, 3983224148, 3690497201, 3903478923, 3285573455, 2116551127, 1162978445, 2559642491, 2515822592, 4067740483, 922254774, 2800200216, 2402553132, 4239545323, 1337189450, 2181950874, 2372338711, 547750316, 1309058307, 904368026, 3666222198, 1068046481, 3277822362, 3817944533, 417730359, 1546943492, 3852618022, 537109694, 1098971095, 3302128171, 2727628990, 2165459563, 3684942333, 849597304, 1763743193, 1883968625, 830232956, 318348250, 2931492361, 2026235029, 112878337, 723329677, 3587687010, 1792817637, 1493742140, 1187328123, 3993625964, 1839596571, 1858019152, 573000935, 2404658877, 1742169035, 2851996326, 1045595807, 2425224508, 1482513435, 4074947726, 669697757, 2558647442, 93498172, 1220328942, 3225739130, 574036431, 1293679291, 2345754323, 1066530946, 3988256419, 2671745740, 2527519788, 4253346119, 3473651924, 921950866, 3552188502, 179378863, 2136216814, 1085209858, 506391777, 3040955182, 734408408, 2240296289, 2353189990, 1525516884, 350519298, 4034989771, 3125870643, 2498034387, 3325926792, 2730601914, 1965324699, 579502103, 1181376476, 2504227516, 1399468995, 352661714, 1984723490, 3666746672, 3080165925, 1879443766, 849919215, 790324719, 1569814023, 2458343887, 4014421975, 755780875, 3186796623, 379409846, 257726134, 918072968, 4176579022, 4264622186, 214176848, 3857236105, 2402509578, 3828635205, 3694477513, 711561401, 1845924925, 1234827689, 2036365951, 2239015709, 2041164661, 2616341638, 1012632782, 2595136816, 2122924896, 1366611735, 1961650896, 474321148, 2926691709, 333195756, 3381411750, 541637243, 3858321538, 2241353192, 2749834711, 4031206761, 51329255, 3462462125, 2669823769, 823300936, 1674034500, 3485087004, 2450138386, 231547375, 452303643, 3414776178, 3326617885, 3875604562, 4021341687, 4068217451, 2155536911, 1728551567, 3648149057, 4145014037, 749726987, 420081287, 2712204900, 2278319478, 410408403, 2246964915, 2098730];
const POW13_14: [u32; 948] = [1513652225, 2561421435, 568016091, 3219124610, 1567548994, 3140672003, 3901443699, 2182387622, 4141196970, 366544369, 3676769560, 1911033767, 3242806085, 3748543015, 192824234, 1956115948, 1696291081, 1211388376, 700323856, 1515270072, 1084306770, 2465771648, 1542369175, 3166292813, 1509064568, 2196599076, 1239276043, 2364515323, 3741001254, 943293, 1432737829, 1555653668, 3641646355, 3313476148, 1069086654, 2865509789, 681536068, 3319239661, 2983083463, 1630276271, 1686018834, 3982604714, 2499040238, 4080953275, 3186544137, 3492167634, 3859279674, 4002574719, 2303161186, 1165791332, 3824318502, 2061358225, 937392540, 3954310122, 282436525, 474293277, 4238882128, 7082045, 1225756846, 1870807289, 1085028422, 1406801929, 3672630733, 3697064332, 2065063721, 2263797067, 11961925, 3559293097, 390564761, 656808016, 692370340, 2322676275, 546038800, 1672419195, 2556287572, 317711936, 1327212729, 4259953, 197577355, 134308044, 2271578320, 1386560190, 3050738733, 1718060978, 2130640554, 1331375940, 624111047, 3525554789, 1985521375, 2586019191, 1558402647, 3909440642, 856980417, 60053137, 913591866, 2898291345, 3513718336, 329509821, 2417319852, 4168311558, 664301251, 636015145, 2271617140, 1452171662, 2458460330, 1505883977, 1445507301, 302456227, 3822965831, 92894040, 3072167418, 1758772508, 2961726038, 3942910328, 1720364146, 300138901, 1080779583, 608595466, 287672053, 2991774865, 762076370, 76860426, 1501520728, 1340523011, 3081299408, 1760038262, 333139184, 1290564990, 76012907, 356964572, 859660282, 1728034276, 4082308696, 3863777730, 1111208589, 4167045508, 2377192236, 2115772327, 252081885, 2110972140, 3423848279, 1825612364, 4007303109, 3940132191, 529705551, 1131819847, 592386154, 767211996, 139345560, 2560638736, 1895474888, 3572412807, 1881983119, 306828160, 4280170547, 3436356640, 36724135, 298470868, 4009401144, 1201965222, 1907743005, 2272048226, 2027347658, 3171140097, 2209466522, 1141566160, 1535992603, 3480643687, 1411494951, 497705101, 325571997, 863779574, 1184765804, 268740290, 3578205385, 689075140, 2224186343, 674642629, 1777572359, 2532206686, 1918297826, 2786087730, 4275399690, 862160943, 3259486169, 482763122, 3311818353, 3745176056, 1712996127, 2457056529, 3105386152, 2913799945, 1952930022, 3669936214, 2031184872, 2112139107, 2357143158, 2447231606, 507345305, 4094940971, 3926425827, 3724336083, 1509694285, 151207944, 3864335236, 727913605, 3187844539, 872137891, 1332616877, 638024373, 3801449042, 573612644, 575875522, 3238993358, 2861607758, 2548845838, 3141071378, 2334409874, 4289008640, 870877795, 1278831489, 3428774005, 4271138832, 1818592575, 878735662, 3620716114, 1945114857, 839824163, 2157168551, 4219212498, 3329653447, 3874762373, 3680159945, 244325794, 3271264534, 1473424871, 3737837342, 3519006596, 2834960577, 3436012911, 3683895049, 4176039645, 2376577933, 3247021487, 513042186, 768601904, 3622268649, 867697180, 2366161934, 3939446948, 2835080666, 3537114981, 1849443514, 2370190814, 3809085128, 3267234068, 719980388, 1621149743, 2686272540, 1262781703, 379346578, 1557964862, 2566561722, 2280542739, 1233009971, 3097781731, 473123888, 1508969395, 166217313, 1439964413, 3646047105, 3595493850, 4093783883, 2795147704, 4123805955, 1250668369, 2283708785, 4245016844, 2370592816, 3828877629, 2787374354, 2139886021, 1208299774, 1237413658, 169664298, 3173462107, 187208603, 2350252003, 892173722, 1004799120, 1328565147, 1789812913, 2527558555, 3872714659, 436946276, 3539454332, 571491969, 189796439, 1759928285, 2669584886, 718645501, 3223822936, 2575652450, 1909911646, 1050893712, 3043752848, 354123663, 487623292, 3025255091, 374157101, 2780753679, 194255140, 3725060196, 3685000348, 1428039010, 4159354712, 4012044805, 3798775630, 20529910, 2559898033, 3760819554, 1905045719, 4136414273, 1334841817, 1687195975, 396189875, 125555202, 2020505664, 3220241916, 2924152273, 1863085422, 500567270, 195508168, 1089450990, 2248396770, 1138761945, 3890258299, 2873381448, 3780002525, 3957311268, 687889825, 1668858664, 1655301133, 15032665, 1027527896, 3031209921, 604531171, 188027538, 3397073288, 3066311381, 2394581530, 303094307, 396468081, 2601109216, 2132608852, 2544917816, 2811813849, 1747120901, 2708158049, 863836234, 2697246800, 1710479489, 2729997963, 4131856113, 2321916459, 1262031341, 232880161, 1058563119, 4099189568, 1755908884, 3803044948, 1379125605, 1386052163, 1738771205, 1749683758, 2024467163, 1809475648, 2754470451, 2421546076, 1874430359, 2069109089, 1152782153, 991766383, 1737431140, 269673911, 2437505434, 2400728955, 1431646091, 1518987122, 2186573637, 339196051, 2764190315, 2259560835, 1282592948, 385468243, 4224274421, 576119317, 3614677639, 4077356423, 1125313062, 3470202367, 1919613845, 4086285995, 1177477287, 1673930406, 705504836, 2454248004, 3209530252, 2088988744, 4246583497, 1590352726, 3112690209, 2013531390, 3100368545, 3437386857, 3717564705, 1286589729, 718408048, 905320788, 2180204187, 2467325432, 3761853951, 3456699635, 2225751987, 1172971511, 733477348, 3854435069, 2062050530, 846090884, 719789043, 1202566603, 2104825256, 2675059687, 319293190, 3793179115, 3001011882, 1431545052, 3969584490, 128832074, 3901679260, 3656005145, 2737768227, 3888240409, 1806666537, 67018228, 2350913546, 1861921716, 3862626538, 4097865829, 2778774693, 794562701, 2871622549, 3207270794, 921035565, 2952602132, 960502613, 284709072, 1063639601, 1270411333, 4218699110, 2004386441, 1244682346, 1409678825, 115127831, 4190053265, 1862167526, 2739270424, 219481578, 3279781500, 3827260408, 2695400129, 298768304, 2646618453, 3569808749, 1266254550, 4053619764, 2493810128, 2777409661, 1011099958, 2293535048, 1538972312, 403680299, 2974007309, 2874111038, 3709710526, 656396871, 3952406898, 1858557412, 2334590495, 968681341, 966614911, 3222900426, 2213498955, 1818090739, 3542494106, 3166652381, 3192598200, 604136432, 3368065402, 3682460660, 689589424, 695654418, 121724358, 2920509093, 2198787760, 890996897, 669876185, 3690589436, 1070026100, 2332305551, 4278372981, 1574424533, 3582500652, 1235862574, 3850504962, 968104830, 3633004844, 1578094246, 3003761403, 3963252178, 3840627084, 1693470859, 81769956, 466743567, 713232122, 1407990440, 302068389, 445519817, 1064709610, 227912160, 2386646931, 3986077052, 4064515613, 1678703953, 4241671000, 1681278033, 1917715036, 2061733932, 2732251455, 1894829556, 3512167475, 3522668618, 3656561203, 4246783356, 1548504543, 3310397548, 3132349564, 405441083, 1890605897, 291119375, 1279935057, 1127928022, 3720852427, 755282063, 634444696, 528643617, 892885284, 406515873, 3274379684, 2703617700, 3403237914, 3915236057, 3184451645, 3061575457, 2105702428, 2973892165, 3999271114, 4220671200, 2503013152, 2707203603, 27691282, 3046681132, 1274969825, 1900657527, 2401297211, 1552686090, 227547796, 2045679188, 4173296788, 2776138215, 591988920, 2131566845, 2003789538, 1235232893, 3340198667, 3333296244, 2018829707, 2454383771, 1982743622, 3479308400, 3863852620, 1843512509, 2509383589, 3639484414, 466868776, 3008250020, 778970280, 2551780482, 4099311632, 3662393901, 489399479, 3093439758, 3216889430, 3027882678, 1720491014, 611553651, 3358642299, 713635213, 1447045321, 2800156197, 2137306122, 2459446301, 1759310149, 547011719, 1432342532, 4199872702, 1895280434, 3406272363, 216310692, 3843975459, 2857117203, 4062571918, 536631140, 1530351545, 2202767419, 4251275457, 1033942363, 1710252604, 1209244418, 854719529, 1827039250, 1721644441, 2392598670, 298698364, 3362109492, 2412492131, 3294067883, 1963247666, 348649514, 2261373206, 938962700, 750409289, 3763953107, 356905891, 2430006041, 3980385739, 717486472, 1098229618, 2187536344, 1411854270, 648813363, 2036353351, 4018623382, 268372487, 670309263, 2712132306, 578773468, 3590008529, 1467649524, 1615886356, 838976389, 1947563188, 544421144, 2717842254, 516155658, 2022510534, 198574402, 3109744008, 4090909930, 2752050324, 3484409074, 2934380843, 3509731361, 422644402, 2439130793, 2971079069, 3031992074, 2924654189, 490468002, 1865664422, 2831427047, 1903651532, 3500580721, 2196852090, 2284208344, 3912911632, 3628348878, 1194228659, 2662145560, 1698198936, 3608826986, 2296769476, 208592660, 1778240109, 2294936288, 2463134109, 2193491972, 2222032594, 2911161316, 3798448785, 182161400, 2335547072, 3311803402, 2366498045, 799281076, 760849489, 2583953491, 730201846, 2567758141, 862894082, 3268126212, 2202597914, 3472692951, 2541602720, 3855357471, 1670106726, 1458362949, 582777374, 3032782867, 1913202013, 2770672567, 654399100, 1581322803, 3325054319, 1915420607, 384321647, 3612199730, 2571660929, 194766147, 2497927899, 783080414, 47229788, 1102095090, 44506115, 2027940288, 1762855022, 260908886, 832440255, 3225197671, 3726417634, 1206263839, 610637814, 2208683705, 2133435355, 3346426517, 224534500, 331233567, 3117629849, 4091918435, 2432831282, 4173196902, 4185058230, 3544764999, 1899728526, 3483314643, 1787603337, 2012280234, 1582069083, 1854338184, 608566817, 292018758, 68148185, 1784644537, 162824350, 46084345, 1399098201, 1011250592, 1119676264, 4100416618, 610831036, 2628823081, 3471721533, 3416232519, 1200121027, 3007148243, 1070271576, 2418754722, 2133851283, 1604771026, 2823776969, 3826842772, 3172890451, 1425697732, 2726151980, 2963167702, 17686890, 1194564047, 1804687131, 3950206041, 421525065, 1333016152, 2466497591, 372565849, 681921832, 2957148092, 2661466908, 296262422, 804942293, 3815683888, 2376634571, 1899045977, 384927800, 2809050809, 1836583241, 2993834542, 1085356114, 3292258341, 1028941227, 1638891302, 2140584062, 113470547, 149891607, 868278739, 1752309909, 1361127472, 4000144082, 1412503340, 528978060, 325410307, 2201220004, 270121903, 4019419590, 864855298, 842515367, 3573287403, 3929124052, 1218070028, 214091141, 2473026042, 3930593534, 426335338, 1513416994, 101725441, 1898194862, 3769220994, 3358173240, 3251806489, 2346613945, 1822324793, 385846400, 1905141224, 3762370339, 3671341477, 2733102709, 322430576, 2794508835, 2474465429, 2043541568, 2738081290, 3885575667, 2009733977, 4225772572, 921826531, 3187755075, 1875257447, 1621428986, 3859138601, 1871313650, 3309224894, 136404944, 3926302281, 3095910985, 2755740164, 2232225837, 1221715843, 3881886774, 770005275, 363454342, 761530375, 2038996127, 1629145929, 2924898105, 751524179, 623104484, 3339997361, 3853611564, 1008822372, 321609560, 1196466737, 3038983061, 211222827, 2079451992, 2543829854, 4054374694, 1360599687, 2016528549, 2377504097, 1187988191, 929094844, 1785919608, 1879099701, 994220924, 1227457127, 2677672527, 3465041955, 84769360, 2436251402, 331603758, 1135534070, 1903010537, 2648205504, 1118585624, 970619688, 4220032948, 2220352008, 1183597872, 4286883798, 4053369708, 1816754731, 3426271933, 3929750343, 2771249666, 2749699081, 2457642363, 3992523278, 1613632090, 2397782377, 3735099573, 3798575094, 399742811, 2994377476, 2714996325, 1705111263, 2267158662, 3635994134, 3159268715, 1991382833, 70956919, 1127357667, 1823907249, 8950685, 816809301, 1310535478, 1087069453, 1468526264, 1582856215, 1085290774, 2479625835, 1334283253, 601399030, 4123082659, 4184693207, 1371028573, 3674475575, 3565090678, 209491207, 2328330453, 1025];

pub(super) const POW13: [&'static [u32]; 14] = [
    &POW13_1,
    &POW13_2,
    &POW13_3,
    &POW13_4,
    &POW13_5,
    &POW13_6,
    &POW13_7,
    &POW13_8,
    &POW13_9,
    &POW13_10,
    &POW13_11,
    &POW13_12,
    &POW13_13,
    &POW13_14,
];

/// Large powers (&[u32]) for base17 operations.
const POW17_1: [u32; 1] = [17];
const POW17_2: [u32; 1] = [289];
const POW17_3: [u32; 1] = [83521];
const POW17_4: [u32; 2] = [2680790145, 1];
const POW17_5: [u32; 3] = [1614772481, 2739882033, 2];
const POW17_6: [u32; 5] = [2276454913, 2771029215, 73658097, 4117442370, 6];
const POW17_7: [u32; 9] = [3492013057, 3480731623, 2144081192, 1009276412, 4254173166, 4151923560, 452949210, 1816956013, 48];
const POW17_8: [u32; 17] = [3277309953, 1864847191, 707834086, 1365492312, 4096642650, 2628241885, 1040897072, 3647618881, 4287772355, 126927969, 3695747218, 1041208948, 524092261, 1484945811, 3697469546, 3397736009, 2344];
const POW17_9: [u32; 33] = [317689857, 1450665849, 1775742626, 792817246, 735751321, 1553574078, 160284371, 1873256746, 2085456896, 2906891001, 2367433931, 2570134778, 3520334249, 99950267, 475720041, 4178498415, 925636968, 3880190760, 4090350540, 1913195868, 737980718, 2149816287, 3313879437, 1462712522, 3066369386, 2488096894, 2055534827, 1929403434, 1042156826, 164256614, 685827684, 1240652339, 5498045];
const POW17_10: [u32; 66] = [1457463297, 984317792, 129815356, 1108536177, 928471766, 2693550375, 2072553947, 1297125867, 1133000653, 1362423844, 2622920053, 2400166317, 2898543712, 3911312760, 340195761, 1832344099, 4238200431, 4289498679, 705322524, 3307021183, 2157383404, 2978222774, 3893788760, 2997995349, 3286528627, 3564068084, 1266442040, 2127456684, 697216183, 818919725, 399364822, 3518519912, 3208026815, 3949195313, 3259276073, 3282846545, 1676913258, 3748532885, 4097340895, 2606771886, 61542262, 928806234, 3952687047, 733904288, 708149719, 1985158190, 3554113964, 3778903691, 3310198145, 3418861933, 2384303007, 1529238789, 2412994435, 3893269128, 1436629905, 3992557715, 1329675393, 3885197615, 1566768946, 690629475, 2807722067, 656572394, 3411636943, 1472870658, 522169128, 7038];
const POW17_11: [u32; 131] = [1908293633, 3689523897, 2822932863, 4126052176, 3318263763, 3554909022, 3131835113, 784466375, 3362613358, 1594674871, 1342349825, 363201666, 3676246246, 3527189453, 4228641855, 3365544222, 2883906697, 1582601823, 2762086834, 444671130, 2667867771, 3306000853, 3176478884, 3611595152, 768565409, 1351677235, 1170484663, 1819794577, 2852094787, 3425809562, 3324861987, 167440938, 181440877, 3524867703, 875516746, 3772659731, 3494739066, 950227557, 4090892939, 3436199439, 2002989813, 2259107998, 514339703, 2959546, 4187061166, 279847702, 1113414927, 758547077, 2853043995, 2873726472, 2287854644, 586017138, 2360476349, 3937610949, 3442197266, 4107701379, 2564015432, 1436806687, 3123130272, 2028236154, 271886327, 2209938990, 804782749, 1603918673, 1581219264, 895483627, 1680234075, 2696502106, 2687909103, 1540265941, 529828618, 1934284392, 2534313015, 1183476453, 3357634495, 2329916589, 824072586, 3201172191, 354985910, 3218236432, 3073740731, 3761536584, 2028365300, 3397332515, 2172674274, 3767236113, 3476937416, 411868655, 1526749518, 2890623234, 275778389, 1862954273, 1889470767, 3943776092, 1863934473, 3244088512, 2671715289, 144944824, 2265756264, 764669572, 3040952776, 1765360244, 1115262701, 1619170671, 4212058315, 497757440, 4033354219, 893706607, 1084351448, 4095156874, 625437665, 1734599070, 4247172012, 4071352317, 1515537083, 1809169497, 2031873292, 2971219249, 3025150444, 3436736022, 1247708329, 201175674, 4101671226, 1644588900, 3326030287, 2437954544, 3174945387, 1000881834, 3196968465, 1427090841, 49535155];
const POW17_12: [u32; 262] = [4085022721, 2085967701, 1271919158, 44627928, 174363308, 2296121937, 2273963065, 3579431623, 1831121498, 1096894109, 3924357025, 2130068491, 2853365964, 1456617496, 2555178632, 3746749536, 1383109574, 4261474331, 436085303, 1293151098, 441533120, 1560211791, 3021758582, 4130670084, 19616318, 4095949148, 299409815, 1030209244, 1017224504, 3231906507, 1156282507, 1702927686, 2584098128, 492684726, 2159222556, 3752625501, 1456067947, 1084048890, 3453698315, 1591197554, 469559807, 851103264, 1113417463, 2668783582, 3284889668, 2346329028, 2859144744, 3057119932, 685449570, 1371349121, 920431876, 1427880275, 1652896932, 2264698818, 3897036934, 1221702260, 2212511271, 1987473568, 3854708112, 174246271, 540141811, 202099746, 2095338732, 645481146, 172501779, 3576793478, 283247730, 787654734, 2208423693, 1891955499, 2872549476, 935317575, 576771104, 1837844074, 3735762380, 1297782969, 1536128999, 1891495801, 1560967616, 3658718251, 3609644461, 3834598381, 3653579888, 2151769073, 862856085, 1438108966, 3966205101, 2513991516, 2033733267, 3497662243, 738646014, 3359330046, 1716117831, 1567957198, 2441990387, 2462302078, 3146031357, 3854102737, 2477210531, 292734252, 536678863, 909946955, 597585563, 1062761901, 2519377479, 2829303059, 995785540, 106677374, 2472390202, 953709486, 3167979348, 1723625740, 1854305745, 751864725, 1017260449, 962057863, 4090581882, 2249910134, 3926571064, 2150011692, 865882320, 928188638, 2537577815, 1998444138, 647936451, 3788138743, 11890717, 1299876652, 1052111241, 967696368, 3105978598, 2381554820, 843522982, 3559778921, 3374913697, 3014493578, 3433375089, 1476534227, 3851837465, 3550982465, 1947597635, 2617914116, 106488640, 212144176, 2408832624, 1301908012, 1665491697, 1379419294, 564803941, 3758117497, 1390844977, 29202037, 1842462665, 403468144, 2251965155, 131885595, 2635790422, 3212943466, 2591184548, 163518376, 1138906802, 2811232560, 1308265054, 772614419, 486210035, 2876589880, 1560778969, 4102610143, 2398046952, 414553900, 1138663335, 3092278650, 1164462332, 1074765431, 1294746920, 4168075562, 3198096521, 525130810, 4196764428, 1193236444, 1829545935, 2602603448, 3748322696, 2531099143, 2959009708, 3100670387, 2579785316, 382627899, 1714279389, 2236320312, 495836236, 2042911161, 51711653, 731191632, 4175109342, 3152106635, 2765872876, 1590115393, 2193625718, 4263502234, 1016876936, 4151561832, 605147024, 1598400881, 3018525409, 2654779395, 403909671, 1064515905, 762427870, 1495038862, 1837964475, 446573324, 2637178619, 725348654, 3025474236, 2784974393, 4013523660, 3185945252, 2195374701, 1059401852, 2957046851, 174542286, 2481692364, 1660288373, 2984571049, 1608858050, 1730035028, 890242804, 1883861595, 3561450135, 939429604, 529468388, 1256327278, 1400120915, 260360173, 1610973719, 2342985870, 1734243871, 3419599710, 4052964039, 3199610118, 1332281756, 1495544395, 482759947, 3706968720, 1387748444, 138131933, 3582340586, 3708359744, 3367255753, 1454884494, 955331047, 4232050806, 1692999880, 2390083316, 1121736953, 2141922999, 2203079571, 2702128415, 2113771929, 3912685476, 571303];
const POW17_13: [u32; 524] = [653852673, 804079160, 317045108, 3382101936, 1130367358, 1227772723, 4173914146, 3339195028, 3542063781, 2657877445, 3894315327, 3230922447, 4236383890, 74823206, 2713476980, 71935918, 3620482072, 3704646672, 336255660, 232091333, 3791099718, 3650314826, 366776504, 1444273864, 1120618892, 832839135, 609493913, 3201718649, 2486986236, 523770901, 1256029734, 2712373222, 3262555274, 2506465289, 313435995, 1170776324, 2820914572, 3104396610, 2910509361, 2468198655, 597764295, 87220591, 3201602912, 2057714627, 4187173982, 2915554184, 2122327454, 3466244712, 1117527356, 1834344467, 3185473027, 2323452348, 2197006662, 918358991, 1904036828, 3034522700, 1505524446, 3966195641, 2595798511, 3570966377, 297776101, 3314296794, 4028994078, 851938039, 3387562221, 2868368863, 2075437202, 4044965662, 667890580, 749943233, 2295967072, 3166655855, 4046713910, 288763546, 1802946687, 573814020, 3577395284, 1418065602, 613718014, 1108079389, 4144561354, 3158868488, 366065647, 517765378, 1252908858, 1800108071, 2039996851, 3103091418, 3035738119, 2311487556, 1484469507, 3811702428, 1485945074, 2186456769, 1440424806, 3219088477, 433920879, 1422162825, 2580724280, 3492571424, 3778679178, 1894964076, 3681876024, 185171109, 4081206146, 798917859, 1622533717, 953272728, 2232493014, 3214889684, 3936812384, 2566447781, 185469242, 130567499, 1369584753, 3152723673, 718117334, 1363850836, 1111801416, 76218431, 3144698431, 986789270, 4225990079, 1780295982, 2604050341, 1696265807, 3843667692, 907399108, 924884706, 249967460, 1558341531, 2528047802, 2518503920, 782994105, 1567940528, 1213726789, 1271011848, 401704401, 3311358501, 2783606812, 740870759, 2243045410, 3792179791, 2296007301, 3397510700, 2429904720, 3177665560, 3222432088, 3273294152, 96430915, 3271992663, 2641596440, 817687428, 1255065052, 236752853, 2979142313, 4240368624, 3772355931, 1589141692, 654783556, 2510746811, 152515501, 3713061712, 4012073196, 3156953387, 2580252737, 3438325899, 4294242085, 700415702, 1934727278, 2461513951, 451545344, 2357896586, 621639245, 759303246, 2225149225, 970127902, 884863837, 3728550998, 2754966688, 3219134282, 3682522197, 2219314299, 2364077779, 3612037037, 1302499120, 828188324, 2391024989, 2626738557, 883556972, 1546920446, 2341614606, 1520229141, 2968132573, 2697752544, 2479047703, 914636198, 2966521022, 1565555576, 2131686145, 267371516, 1237209139, 657787771, 1847745685, 3652066149, 2806093487, 626954154, 1078641188, 861789609, 4047429839, 1115869132, 2337343572, 2615394121, 2096333782, 1138444742, 2803024457, 131733434, 3143027078, 2985106047, 2826591279, 2642089216, 3944409184, 3633985939, 112520625, 3018084251, 2902017751, 2379500901, 470467556, 4020793048, 527244468, 352974788, 104402052, 2392599968, 2967330921, 567027142, 1483285025, 2942011053, 3332847706, 3197112695, 3724457591, 525975090, 241229588, 3492017920, 2614767616, 3535332976, 3207066141, 1072491264, 4162339653, 3820310096, 498690043, 1552583229, 3214142499, 1877255302, 1796230911, 3836721678, 1290150340, 313362434, 3188934567, 629795581, 3722093035, 946136182, 1343568012, 1144246267, 1290859252, 2467260418, 737358861, 3351888966, 4247954332, 2056378976, 1923963393, 833559643, 2304209581, 248746521, 734365562, 3718828583, 3109765686, 2181915489, 1003856590, 842334805, 3685181364, 1796224132, 1310504456, 3600986180, 4000748173, 2108016032, 2100281436, 653200590, 2344231620, 3671081413, 980655718, 975271315, 4081644043, 3387949569, 2648901384, 1374091753, 2154882951, 3118633206, 1876114421, 2130585588, 1625918937, 2697933051, 2678682545, 2083275865, 3650477692, 3245973132, 3362683911, 1015800757, 2255754549, 2907822735, 3163319592, 3131108494, 3005746967, 2944601521, 3400077278, 111205239, 65939123, 3042606419, 2397248111, 1765631252, 1151241243, 3815617887, 1663933225, 4196394528, 3530711924, 2041739626, 1497457836, 953998311, 570299149, 1311040112, 1031912543, 3952297037, 1429571434, 255646515, 1222461235, 358668034, 1291853262, 2561065587, 2494917777, 1038769745, 777198421, 2474384421, 4060113779, 725387790, 1595744499, 3739635811, 3812095211, 862373119, 3419451045, 1346587053, 1599169722, 824353531, 4259087799, 4091898003, 1693692162, 3916338621, 3488559751, 2521899964, 380859707, 3433232441, 623595720, 4024482943, 81903787, 949716956, 1488402371, 3919092307, 1938231947, 3428304871, 2170138389, 2143978663, 1457524934, 1352559918, 1478138542, 3260047087, 2141004915, 2901137763, 3904369290, 3759282057, 223943031, 875457119, 2131919520, 1568150650, 3649244639, 4205983702, 1267114280, 3929274314, 2066798261, 148847134, 1702265052, 3996556009, 1917239926, 3088056852, 3563887171, 1685277956, 1746697736, 1666454561, 1097111846, 141402998, 3358200408, 1225064452, 337312220, 864053464, 1415344927, 186648222, 633455815, 3895168635, 2402380352, 2939714357, 4217314923, 2268288847, 1491107257, 3936594949, 2155373198, 2109326196, 4118071792, 2002361849, 2353074369, 2559517815, 1773929122, 851200359, 875535853, 600517347, 3914683899, 2125327927, 2675990885, 589214872, 3068643885, 2281933169, 3224556846, 1547148234, 3507824974, 527664256, 726590753, 3431953398, 3204653402, 1123510277, 658746889, 3442991421, 2494213803, 2858333528, 2299417507, 1694766033, 4105482648, 2271222974, 279971142, 3425485238, 1875763912, 163514685, 855584457, 4127771402, 4027007331, 294343798, 3390077754, 1881338062, 3038077868, 2750900911, 3776107425, 282274049, 1316767029, 2839656145, 1706342088, 3997887022, 3245969985, 3158904772, 128653744, 163806714, 2959247222, 4134428955, 288596525, 906847794, 4139446572, 3944785016, 1365830554, 627418401, 1425486391, 4107966312, 3717061340, 3695004161, 1659726457, 4017260558, 430318666, 10830527, 1112525155, 1465704640, 2588279261, 2712586113, 2293334594, 2304990040, 1342029279, 1148007717, 1117909867, 1908885335, 2108935559, 61143512, 3245889886, 2849144913, 1585177368, 3231792894, 2868854115, 455631408, 3737249491, 1511987494, 1520617731, 4130027243, 2830658473, 52316930, 1072967416, 1015556087, 4106393656, 2586008251, 3105140800, 637395747, 2926208061, 2194055491, 4243576748, 751283033, 2540338189, 3953438836, 2005809997, 229028678, 1219407764, 2826213775, 4237771999, 4265611515, 75];

pub(super) const POW17: [&'static [u32]; 13] = [
    &POW17_1,
    &POW17_2,
    &POW17_3,
    &POW17_4,
    &POW17_5,
    &POW17_6,
    &POW17_7,
    &POW17_8,
    &POW17_9,
    &POW17_10,
    &POW17_11,
    &POW17_12,
    &POW17_13,
];

/// Large powers (&[u32]) for base19 operations.
const POW19_1: [u32; 1] = [19];
const POW19_2: [u32; 1] = [361];
const POW19_3: [u32; 1] = [130321];
const POW19_4: [u32; 2] = [4098661153, 3];
const POW19_5: [u32; 3] = [1637415489, 2733490537, 15];
const POW19_6: [u32; 5] = [1674773633, 2120389729, 2125575713, 2140041202, 244];
const POW19_7: [u32; 9] = [851069185, 953120046, 3422911417, 3249671984, 1253122465, 387558350, 2121285446, 1729366164, 59779];
const POW19_8: [u32; 17] = [2386924033, 190345838, 2985903449, 2575403751, 3663280926, 3225853746, 4150572491, 603254694, 1674172707, 3673007190, 1176051141, 3802513312, 1962388533, 482203478, 2403994182, 530593434, 3573576981];
const POW19_9: [u32; 34] = [600777729, 4287864253, 879263622, 662006526, 209087784, 1566861921, 1868491450, 2979970599, 2251023872, 619496482, 1962810147, 2474730226, 1043946239, 2571498863, 24001819, 1859204983, 2472425095, 339377689, 866657198, 990396938, 2881482992, 3673813, 1416246612, 2126450992, 810411284, 2469838367, 1356652332, 2422736342, 1273451346, 3772130430, 2531937001, 3633029867, 1546447747, 2973352661];
const POW19_10: [u32; 68] = [2226014209, 1311551213, 19006035, 3560028624, 3400822883, 2260137902, 2626308946, 397916838, 2154438492, 3267979482, 51974750, 3434718507, 352206864, 1183471152, 2304943612, 3788818754, 190140117, 170026499, 3825508396, 1347714733, 389308855, 1686258633, 1915096964, 1618679228, 56663032, 1502877569, 1787809606, 3171026396, 3411597083, 153287481, 3487511685, 3169928240, 3583116939, 1767370122, 487663870, 3505082218, 2006247521, 4220801096, 3037411207, 358526239, 4042932841, 1595456929, 1024170034, 3237701565, 2043937592, 3040155548, 2347496689, 1142942189, 2961469253, 163240502, 1637537269, 3146413046, 2853742643, 960593755, 2146471541, 407701098, 3202413246, 3392470930, 2399295285, 2816655148, 4137870176, 3139435252, 3999095315, 153016687, 3766844738, 3406533690, 1623276339, 2058415219];
const POW19_11: [u32; 136] = [4254896129, 900652736, 980304171, 2237494519, 806622219, 1481372569, 1594893306, 1429651042, 520461233, 1384169010, 1860986400, 3353153719, 521012967, 1061918539, 3585061057, 593465121, 4090592225, 511257954, 2042776089, 136083668, 3963988729, 2231773506, 1896847515, 2755786263, 437517368, 3542151637, 284143785, 888382325, 2229806951, 2282519678, 1727256475, 2202818889, 2173872667, 1234038854, 1585204565, 1378039623, 1024316507, 2844837976, 3737636296, 1501749607, 1687087875, 3587579209, 2909567867, 2902509091, 3536167724, 2520584651, 3701257854, 959596522, 2000373416, 638415389, 550367812, 2494901029, 3102796157, 3546334266, 1096826775, 1944229679, 1295092879, 2779719369, 1065888657, 1798890005, 3807924864, 2275240966, 2908136145, 4155123706, 3032995156, 3718296519, 267222915, 857395390, 340092803, 2424871771, 2044596141, 2628187515, 2157533238, 70172775, 2930304387, 1898292758, 2605936345, 3125842343, 4069912846, 1567585176, 3029314262, 1529860590, 1833219710, 240562859, 431586267, 2936800789, 3270111111, 2211649058, 2928629166, 2193374933, 2533225289, 2073294107, 1616302889, 3713955772, 1100750018, 1396681706, 3028822840, 3385342207, 3291026658, 2155875215, 937347553, 3624152314, 900975440, 2768781459, 3403238712, 1375102474, 680803628, 503869938, 420124670, 83031187, 3023590859, 4053349732, 2761177557, 1235737784, 3055076616, 3625956358, 4040355971, 975831122, 1148785172, 2676068949, 277739707, 3985956042, 2081975591, 1118499225, 1493547608, 2094944807, 2143099536, 3089923066, 889986503, 4024266613, 2416103842, 2307158933, 3736694398, 470967898, 4047643779, 986520483];
const POW19_12: [u32; 272] = [3426295809, 456430049, 1640218659, 3007079176, 959876987, 2223467885, 4076124500, 417888859, 1037880115, 2378369546, 2319054386, 1030664361, 3083754353, 1253520369, 1805795630, 466075093, 2198447969, 3550793507, 3483002958, 3696527081, 4109159608, 1034772337, 2864538764, 1845561056, 3844244629, 3328643887, 1623928805, 94248299, 3464429028, 279508986, 4121047871, 3703811188, 334236727, 3416012628, 1785319913, 350924216, 2805337799, 1595308984, 3493323566, 1994363794, 111516809, 1091882592, 1530881168, 176026905, 169089692, 3569082320, 4163151425, 2460214920, 1021156045, 3151009207, 985865882, 2997649065, 3116091745, 463670204, 2092181874, 4040408465, 2135545971, 3099695959, 3688345583, 2676964065, 1625226024, 3190311882, 87375303, 57511715, 2176616519, 2922021671, 131894521, 4045480739, 3029371625, 3683791277, 183182440, 2918812480, 679022819, 548831725, 545194003, 150746027, 2384861643, 774162756, 2307333480, 4063401231, 905006671, 1286321744, 1471072142, 2369239251, 4157285691, 2832213518, 3542764709, 275213133, 3264190258, 2673529100, 4162262270, 1352735401, 2495929144, 339616562, 99498066, 1548873055, 3278885527, 4030169179, 1520494036, 2805618981, 1493269915, 3893155572, 1427410907, 222948129, 453116650, 200054796, 3229577687, 2380861490, 2671152624, 2551740703, 1648910867, 337009883, 934844752, 3866683384, 1968565113, 4068714733, 3311509119, 1522688853, 2991638604, 2013517995, 481294794, 2578892484, 2175664801, 118823337, 3395067020, 3788021466, 996427616, 1991957499, 3061191301, 2685798947, 737155512, 2806053612, 2652347270, 646385592, 718776402, 3056261309, 1671840470, 3664347811, 2067964160, 4279377199, 864814793, 2733297930, 1857065174, 664714154, 2568338541, 4114063995, 1857735519, 334586826, 2193181127, 4282352547, 755179073, 2595052814, 3360639724, 2048031108, 2536631630, 3730675741, 288445910, 2488075713, 3340156953, 1759689498, 1699524541, 3465719663, 161191240, 2305028968, 663140709, 424749294, 3203217945, 980017320, 2641622629, 3179262525, 2268258129, 3703847754, 1953149931, 2034331792, 2453785789, 2645877717, 4149107306, 2444326557, 181780619, 641344048, 947653609, 494564618, 4165372872, 1009533988, 2247525603, 4272908696, 2399217132, 1227010564, 319655213, 2799392398, 3561139967, 4280646442, 705080968, 2030943653, 3077510072, 2623422447, 4145844983, 1555248449, 2666106573, 117240579, 321366571, 556728016, 1710553605, 802873415, 1550782081, 3989893606, 1992495208, 405282038, 720198523, 1022727910, 3080262583, 2885853759, 853837388, 3228366717, 3649328617, 97009278, 944298843, 2405349692, 3574066585, 2478557666, 3197441940, 1581669964, 3284119736, 2738233173, 3586426533, 1291387723, 2963731997, 1169402355, 1172500732, 3858949327, 4048579900, 3512967151, 277988563, 575774030, 3203736845, 3196420723, 2699397170, 189743599, 3290783293, 2310014003, 4154330172, 3890826007, 3698234563, 2259699940, 2728960897, 2813861197, 3040889884, 3943121979, 3924249142, 3370921844, 1739074773, 2250012001, 3311607808, 4275228102, 3032334483, 501818730, 2564077082, 289590731, 2811899264, 2262280121, 48124927, 3551007956, 3187578938, 3342870504, 1670700644, 400340834, 2974288493, 3545233831, 1864662781, 4093578384, 2430491226, 226596059];
const POW19_13: [u32; 544] = [3698475009, 2348710786, 1125569724, 27387644, 1693267154, 525565825, 3221818805, 627963023, 1871616018, 1703673704, 2288610982, 4012520689, 1077215743, 3542560748, 352715808, 1026708448, 763132536, 1292513486, 3128094965, 2432068461, 3144078469, 3639513047, 2452365249, 3897634097, 3158041736, 2842036982, 750624087, 2448194546, 1445977927, 2281412423, 2559176832, 2121789021, 820711812, 445943201, 4107798256, 1205099379, 3734091239, 262484112, 1708009319, 2341670672, 2385931575, 1604531876, 2763730110, 2987878241, 2598893428, 4080242107, 658701652, 3278278300, 495685585, 707364982, 2953115421, 2331439434, 695374200, 3059863288, 2673841031, 945337560, 2963017008, 2600811093, 2010921721, 2190994195, 1441728782, 874413108, 1340547061, 253295198, 1830889962, 1106390773, 267733138, 1078616913, 2176681734, 1037756416, 3496174982, 4160304534, 3708573742, 3606953911, 759922554, 908768211, 36301915, 2731180088, 2431564390, 3111240551, 1796201297, 1449677007, 2077716548, 3012974782, 3253299885, 1395989820, 4093069628, 3976864013, 2222800946, 3966075865, 1440883596, 2937249133, 1960613258, 3866722429, 3045749476, 4218987064, 2538371182, 3675801283, 841605258, 2239840858, 2661704789, 2124919157, 3178074258, 246943499, 3626277666, 2151349822, 1757973659, 2937817170, 3911039073, 2603480839, 1410754424, 3628086132, 3410926441, 1394153497, 161038440, 4048050492, 2857121086, 2302352481, 3355362520, 837134425, 4091164381, 2181027065, 1448048876, 1990829837, 4233637301, 4210787010, 3799162065, 3587407276, 2865177792, 69460099, 2373511514, 4056317445, 1815952152, 1832959647, 3225977, 2432637060, 1949712484, 3303591154, 2355390943, 3886644230, 365475074, 4141964206, 2626358532, 1941078737, 2622974917, 618116244, 4275387220, 594915216, 1224569507, 3845674819, 3912729408, 3090512886, 1189631081, 1022115508, 1984805740, 3021120626, 1759395566, 55950297, 1460793026, 1462014826, 2281305419, 135943629, 2549233697, 3448970082, 698019423, 1750514438, 1083912407, 1792619850, 2397984834, 180833955, 2525167464, 736145625, 4279871585, 4016857381, 4036939174, 2105463069, 498683168, 4159081386, 3370439434, 607760224, 836741276, 714413915, 778783896, 4218365807, 260504127, 2427279166, 3994847061, 745700051, 405317637, 437018589, 1108173734, 1038879664, 3107146829, 1753820698, 13154889, 4089222476, 783840504, 3758645013, 3296239984, 1465674627, 3860937699, 2330242899, 3356964930, 3428227399, 1170326701, 4027939567, 272867974, 1139814414, 1686357188, 4137535440, 935295564, 658917480, 3581653950, 2471701971, 2281752281, 229936885, 2479291357, 2273019496, 522521942, 3877448615, 2990128797, 378293256, 33829329, 47693473, 3264019538, 3673586715, 810931650, 3588924867, 881802719, 849877068, 3519113866, 2648824723, 298764587, 1061117323, 3497516460, 774097362, 2829082334, 2354372120, 290967978, 2228127560, 2448428118, 712297790, 2212669481, 4117664708, 2844307473, 2448759562, 3909013179, 82446222, 4063738208, 2548920436, 1399220080, 2174367894, 572159520, 2576016842, 1633755072, 1332574234, 90563630, 3403454573, 2306449586, 1836111429, 3847263182, 3157943865, 3187263043, 2336380071, 57204767, 3374191127, 2263034681, 1024000143, 2635372492, 3261928202, 797536801, 3763489472, 2206747643, 2978801531, 4291367355, 1851048078, 1583883821, 3058137808, 2876732371, 238942589, 987844605, 541104707, 4269758182, 726401954, 517779157, 3932852177, 2519316915, 215545279, 1170775446, 2679061552, 139443286, 3996718746, 3408745927, 1586582409, 1454370473, 3045247666, 2444884360, 3059683652, 3318906948, 1283666682, 4193821293, 834087456, 1135898775, 1334330677, 3583264251, 1256013730, 3356123107, 3794612215, 4184288324, 4209598392, 1148473112, 4097605935, 1368958267, 3522601735, 922959283, 4068741403, 3701983404, 3107114321, 461316967, 1960582466, 2441363463, 1407849835, 2168499426, 3799713542, 83435149, 1647227160, 2206800003, 3640079826, 2946722865, 1140599594, 1069261201, 3689142171, 4081025932, 91001280, 3621475658, 4210903522, 186355933, 748465236, 202779544, 1331032212, 3297032193, 14749470, 335754767, 703241747, 4055911534, 141500073, 3860904859, 801854871, 3134540418, 3697700580, 1121562158, 1292698770, 2759792766, 2163162039, 4214972901, 69131059, 2439268588, 1646213910, 3568299259, 416961787, 233508894, 3405225790, 2707437307, 169033690, 2763821461, 3371930561, 2671731524, 2218631372, 3556740456, 4196704464, 3270298054, 4025382741, 2046909602, 2072061389, 1575451198, 4188215372, 3836979169, 1617568182, 4287398767, 1420826033, 539985529, 213746114, 2053529503, 3280856001, 262261005, 2719073765, 2076616586, 3880611696, 4283397239, 4217794368, 3892326973, 3101643777, 1107439832, 320556763, 2418357014, 2613973143, 3590814049, 262032528, 1405627149, 2915350870, 1135921419, 857282742, 1554243154, 3702194247, 2756742536, 303554327, 2668112029, 2816621037, 1216972063, 3132436655, 2248364458, 1635977659, 375283790, 2351775118, 1477024371, 227015564, 3995133651, 1177315689, 3956504171, 4043948729, 1505950922, 3733597925, 1942915677, 1208783370, 77892568, 3780201208, 3992211952, 585713512, 3794452100, 2872133197, 1268675185, 2222307392, 1786705831, 1154148139, 2449697059, 3562775153, 4243048772, 2239913232, 1821035718, 785641329, 1483537159, 3966867099, 3711390631, 4160723913, 4128180782, 3845419982, 3498967752, 3623467449, 4023386558, 2080345519, 1829865640, 2066544244, 4269343993, 1707442400, 3652540860, 1580459142, 3170722747, 2635513381, 819917600, 963481752, 3956002458, 4207297868, 4146519668, 684565896, 330723648, 2732580672, 2460677898, 921005803, 328628933, 3004678593, 1290348712, 3375692685, 1995878766, 1738267363, 2136007949, 110895732, 2392525990, 3693450969, 225201216, 3171073045, 3478244004, 4155779732, 50953808, 825956166, 1897027940, 936075529, 3324254947, 3244913167, 774896874, 1181764826, 3286855052, 3636573853, 2004728685, 954948499, 480128314, 2144898790, 3707494056, 1991944670, 1023933339, 2129301216, 3774884033, 279325989, 1411971072, 631884243, 2797000113, 2469417595, 1059902555, 2554835918, 472620564, 1606463096, 45490379, 4072472094, 2574648783, 2363640954, 3956224404, 1251461196, 1488722722, 3112095189, 4023319800, 3492404471, 2694941226, 154487917, 133194553, 1842024384, 3321045507, 311009458, 2582077646, 1622864329, 4265317991, 3217905926, 2587369922, 2173669452, 985706565, 4174931395, 3045862001, 1615132599, 4171162099, 734562947, 2126761952, 852377186, 3655493546, 2471786196, 2827825430, 11954869];

pub(super) const POW19: [&'static [u32]; 13] = [
    &POW19_1,
    &POW19_2,
    &POW19_3,
    &POW19_4,
    &POW19_5,
    &POW19_6,
    &POW19_7,
    &POW19_8,
    &POW19_9,
    &POW19_10,
    &POW19_11,
    &POW19_12,
    &POW19_13,
];

/// Large powers (&[u32]) for base23 operations.
const POW23_1: [u32; 1] = [23];
const POW23_2: [u32; 1] = [529];
const POW23_3: [u32; 1] = [279841];
const POW23_4: [u32; 2] = [1001573953, 18];
const POW23_5: [u32; 3] = [1854975105, 1930488089, 332];
const POW23_6: [u32; 5] = [1633523969, 2552572211, 2550303091, 2811546753, 110522];
const POW23_7: [u32; 10] = [1210855937, 1436506257, 788091685, 4255817435, 2500410572, 2361723765, 2618086504, 4203283319, 3625322590, 2];
const POW23_8: [u32; 19] = [3390858241, 538851, 3291369078, 492442738, 2850638734, 3029803664, 2378638741, 755966606, 185069185, 2748924587, 3547456468, 2115104919, 3398114034, 3022323801, 3693445824, 1646113784, 2709808682, 381505921, 8];
const POW23_9: [u32; 37] = [2605238273, 3116014269, 2992234958, 1161074084, 479530153, 3899908674, 2110077101, 945664495, 1886615027, 178825347, 3336466241, 1535044871, 3130879489, 2072972949, 3321140195, 1277356633, 557957570, 1424987297, 2661331017, 3155813457, 1979672171, 69442422, 1465357477, 1292379284, 4001039347, 2329370010, 3548005518, 2351685740, 4050637122, 1246418910, 3135187870, 2896849915, 3344622137, 994758688, 3546606478, 1843015197, 65];
const POW23_10: [u32; 73] = [1389465601, 1270725724, 2430805426, 793913803, 1730617534, 830391743, 1447514731, 618344372, 623481912, 3084697698, 193767822, 3851124886, 255326659, 3713486952, 1566487911, 1755920970, 2992359304, 966788492, 3740415920, 159326876, 58388316, 3618138013, 1211637293, 3982421756, 447680048, 977798062, 1729585872, 29528160, 3511980698, 2986171906, 721298031, 4087122058, 1337589914, 2891941726, 1799086713, 677396911, 3673570755, 3849306605, 3461700235, 1874006132, 2569805975, 1563150380, 4669777, 2045351581, 374132179, 2011356629, 918291745, 3147334072, 236807592, 2435596618, 26881790, 2019016339, 1175120407, 1285033588, 272812424, 2679220483, 4186085566, 2453245162, 420923676, 1014007343, 1216833656, 3376737166, 3242365153, 838929369, 4111422289, 2611056369, 1954578150, 3133421373, 1159123251, 1087135977, 1381913124, 4159631453, 4280];
const POW23_11: [u32; 145] = [379789313, 2758141061, 71522850, 1119530638, 3978370053, 1160536233, 803554839, 4138152392, 3767315879, 2206196210, 1579030902, 1743902133, 2467116037, 2987035458, 3012122326, 432014986, 1690767645, 4236672118, 823127706, 3913278592, 1175238479, 39484736, 2726235066, 429737273, 3996909923, 3231819960, 3841170194, 3549092869, 156053954, 4177621645, 3218207888, 3773558946, 291467074, 2735794354, 2817713113, 2107057369, 4062136853, 1239339744, 1963513639, 2850418918, 3316030415, 2583849721, 4178950459, 3643813342, 3629742336, 4063289682, 2858387189, 401584375, 2351321327, 1961707692, 3148842945, 103814549, 3501419191, 2975550077, 1101977746, 2679908101, 3834230311, 188877196, 1948690137, 2620024128, 289849790, 457761556, 3006912097, 2159899689, 3894307461, 2329790703, 1426201101, 3005856300, 3111020731, 2546062547, 3089661554, 4084360158, 2272224239, 651696083, 1286065301, 1757277020, 1138141021, 2237865833, 642045488, 4203444687, 2023651164, 2966208508, 1092430863, 3622977179, 2319864750, 93603986, 2769608280, 887833271, 1586054297, 3225966370, 2510175321, 98568386, 655221764, 2788081662, 3922902292, 2900505997, 1887368825, 3533864638, 425446961, 3961415955, 1151618629, 1646022686, 3222130023, 3474940252, 1361296164, 659675733, 693297050, 3373397441, 1215971414, 2340864725, 407181956, 872585078, 3031994095, 2114550411, 2349517248, 700038787, 787928209, 1323880295, 1010311499, 1467760695, 3061713726, 3939092210, 1720173567, 121727021, 4004998533, 790233415, 2624290768, 4130208598, 1193155313, 2097752256, 1268873715, 2041343193, 3277403825, 1353198293, 648245758, 2548770238, 1282528946, 3619875585, 2095010525, 2649414752, 1890794924, 795315762, 369156751, 899949386, 18326691];
const POW23_12: [u32; 290] = [4047912961, 2706078331, 542992255, 1637665820, 2741142721, 4065827615, 1270610388, 3130100114, 3409680144, 3226805914, 3382630134, 1695211647, 835807866, 1253342310, 1867751943, 3414562408, 4131807098, 1838155340, 272019709, 475330415, 2848842812, 2628625154, 1779768443, 3660761624, 28646505, 4064911928, 1324601206, 2648009214, 3009464369, 4040162765, 4032792242, 3188403026, 2627115900, 3600369684, 1661889763, 2461085059, 2557186775, 1547903206, 2444484871, 2002767868, 3963260566, 4277655133, 3164618438, 1526177493, 3687429330, 3036799512, 1342125841, 886772701, 3065742182, 3228196492, 2175413217, 1149380218, 1160578103, 425846651, 3233169681, 3301185752, 3653989427, 1932531647, 1176656790, 2479866857, 1697450058, 2696979544, 4171688849, 1984257175, 2376794540, 268070975, 1584360037, 435144812, 341033877, 3377520632, 4090216239, 2751416470, 1489343099, 4012274079, 3182747585, 1106761117, 3074921942, 2826597558, 530613369, 1408107841, 2909853108, 2052055873, 2151637918, 3775153332, 1697210164, 2748383243, 388425896, 3902000475, 44444877, 190299373, 3802467288, 2432430955, 3573228694, 4234613504, 663227232, 3504998182, 2818568140, 2089079729, 1764011739, 2345693684, 2156823721, 479848277, 2482061478, 286763971, 460347807, 34719071, 3309308291, 2058164715, 4097499901, 3229558899, 3934884672, 1978363444, 2053796824, 2811196783, 1095805763, 1217074101, 264596232, 2900338186, 999456882, 1879395680, 260962281, 4134975577, 2801571397, 2888997548, 321354816, 224916052, 1371339964, 3611483631, 1647901049, 491660493, 8514499, 2355964689, 1047118756, 754250461, 919479968, 1046073168, 517250720, 3251815459, 45306865, 1906674686, 2805610381, 3032672849, 2114249531, 277875506, 3426639681, 2424703720, 2261633930, 3648844959, 185410792, 2668214722, 391505289, 2161966703, 2612423299, 2978933815, 2442786080, 368451385, 3270180305, 287202057, 781208358, 3581321000, 1724769350, 1359713574, 2429054300, 270136631, 420238567, 3404338829, 23256407, 2684317479, 3905086894, 2918661679, 2047888093, 2662771914, 3989908354, 3417530629, 2094001687, 361580016, 3086435457, 965781219, 4249366685, 448816469, 251000905, 3512983509, 399664727, 3319202455, 2991935997, 238214973, 2059177992, 924510095, 2738727311, 1408152090, 1366672482, 544745176, 2718822597, 3342403313, 3069625731, 1122889278, 2352618905, 4032627128, 2739922667, 3448136107, 2173196206, 1213124524, 181560319, 1137248410, 3748611021, 1634052255, 1140008267, 1000807011, 266130147, 3968119094, 1663575010, 2544232626, 387355496, 536092600, 3034262090, 2275205838, 1992098149, 904357246, 2047404193, 504923133, 3579921170, 1631109480, 3686011874, 2301805038, 2932643745, 1516851640, 2629543965, 1734466704, 1916624342, 3614123815, 1985797395, 1822045299, 1571737744, 328376417, 3307293173, 3298812782, 3929675526, 381933809, 8956221, 2330861594, 3129515112, 843570113, 4249041719, 2832931138, 2596533158, 3295015771, 2890813875, 578570402, 3426929694, 3286268033, 2079105775, 2984649912, 3249157295, 1209368491, 2149367866, 1110834557, 3595580613, 3493621749, 2880729144, 2806520113, 1886576060, 3568463889, 1694305802, 878278620, 809891654, 1983193009, 1867229389, 4162557282, 2356690531, 521290693, 1959127013, 4142787822, 499367916, 2474576428, 2093902775, 13158038, 292424669, 3987092736, 2963112161, 2440758231, 580917628, 3344986760, 3870742929, 2276641489, 3392631670, 2272346511, 3831968049, 2465542736, 1168142476, 78200];
const POW23_13: [u32; 580] = [4069294081, 1954401470, 2426562721, 2785656499, 2436180519, 1555477753, 26008596, 2550420690, 2660826980, 1910178312, 751335956, 3784438901, 3887774093, 1253188426, 2461159114, 2396898009, 536785702, 1539400130, 3340993484, 723696446, 2866420198, 137664586, 28452047, 2346439400, 710205197, 773955028, 1295618182, 2168257280, 823750549, 4107353467, 194544918, 1399866117, 4080865184, 4294414893, 2716211388, 30877716, 2805600161, 1168681766, 3675200818, 826363708, 1788156611, 2383043973, 3368147427, 2635875110, 2897736799, 2501181051, 640939406, 742206169, 1553972078, 82055010, 1960090306, 2044466541, 3382908180, 2691915312, 3811761225, 978356366, 2121280903, 1044872173, 1689233681, 3523820819, 2719151474, 1557860688, 2816310055, 3007778646, 1955415889, 2709007886, 824179083, 4157845984, 1668333438, 1323991598, 2512532644, 115219799, 1798362470, 3294560066, 4165155070, 2094351775, 3845308917, 3592861001, 4037342980, 836321446, 1146169325, 3788391498, 3845351500, 4123710833, 2287261707, 3001660701, 365734328, 1373840209, 379319944, 3304703246, 2667248859, 3469642195, 1491933952, 1800417045, 4188345322, 3836015449, 2289088224, 1881030843, 2117857271, 227625765, 3378234399, 3686254475, 2839453187, 2345076086, 325108888, 316281677, 144330590, 185763391, 2751272900, 3413189564, 2095740472, 2304249401, 3738777365, 3589204737, 3926188970, 1855205086, 971129436, 1728588995, 1912872952, 4155583376, 3490428049, 67177501, 939790347, 3681278908, 1257097516, 2165164581, 197355782, 3182242994, 2304233930, 2399030398, 2931875554, 1536732010, 2218690775, 1447885919, 4040462315, 854495807, 180717071, 2262287620, 2620208073, 3231180781, 3311643465, 724991797, 3699878088, 2946011589, 3890861432, 1043419275, 92510136, 4007698002, 1864878984, 304713154, 1813086879, 2824742219, 577583630, 2786013288, 117739258, 3826637508, 3801221845, 1137785848, 3296897084, 1076447441, 3166882710, 3103335519, 3153904328, 2340551809, 3629195646, 299740308, 239096656, 3194262602, 3177130873, 3245830874, 2835384678, 3761796838, 4294537490, 2190208216, 1386675137, 3366893001, 607433185, 1897011430, 1418554732, 2272214293, 1735757754, 2507633226, 2029556540, 2826896662, 4046611314, 810189824, 922331213, 958459530, 3657536577, 1086105018, 3758440273, 1579013403, 204829439, 338418247, 1660430527, 3668379592, 2730295562, 223749203, 3117457472, 307354783, 3841575, 3276225973, 2970415599, 3695857983, 2939332526, 2757720255, 2767717659, 4239836917, 2359756599, 1282847416, 221814126, 3738616852, 332100895, 2827681514, 1399634935, 2631257341, 1044381446, 3617910905, 1189777580, 903799496, 1144824547, 485155442, 2947328600, 1686177123, 2947084384, 3941590708, 3197580207, 614109925, 3653865495, 1435212859, 3391256022, 1006926394, 2902917026, 801475739, 3070880610, 1276574800, 2142234948, 3356519153, 2035630764, 3205171983, 1332734318, 4078069739, 1428897349, 342772171, 2097758727, 2225548100, 4118513652, 2062957901, 3528788113, 2427038307, 3572649043, 4129470847, 3666530417, 2690176479, 2531735868, 164025276, 3432026166, 682738945, 3631838634, 657685579, 618943277, 996863671, 2187701409, 4019922914, 3644683240, 857254337, 409516993, 2681090225, 1635520229, 229516358, 3151916241, 694772196, 2435581206, 1125534899, 1910166927, 2448255279, 697647330, 1830318100, 1609142992, 3611999617, 1847492473, 1355259976, 3708210041, 2735959343, 293575348, 2975059905, 4274837588, 3745372880, 4076667507, 3873563731, 3099420835, 1001674783, 3547607037, 1838139501, 3326132470, 356100529, 2607636644, 3791208868, 2579299845, 3155313575, 309611805, 3292634034, 3698684191, 2375433324, 3877927092, 3763165659, 531649305, 3837201187, 2282886327, 3002787250, 1223950399, 3649652961, 1184782172, 3466130022, 1238685353, 180270883, 1752600178, 726733767, 52593246, 2618104701, 2843395146, 1428755413, 2660004701, 1927047974, 2869239333, 1007878885, 1944014181, 2497293477, 1862749216, 2028701675, 216388274, 771716445, 3598106963, 1505785136, 1371557563, 2522177212, 3753067627, 207338163, 1955929058, 3148350200, 1957377172, 2164175391, 1006133080, 218924664, 4237756727, 4124313905, 963598878, 499215679, 1172118642, 352801645, 3711486055, 2704856106, 843526135, 2380772459, 3349025226, 4273981066, 3853711389, 3666535652, 3757224559, 3343712598, 4110824240, 2216790611, 2036434305, 1637307214, 1895812213, 1109890606, 960516819, 416511472, 1428970943, 714117557, 1042867327, 3584887456, 1200174443, 4106051533, 2966846591, 4286452120, 907712294, 3028289635, 608526429, 2369063090, 71802511, 3188847921, 46576398, 3655681067, 3295512953, 3638105274, 2119636724, 2572108308, 763014256, 4016048453, 2184788569, 3419569661, 3686207017, 3368449948, 1683363159, 2266607979, 4157176569, 3329606707, 2406202189, 2840460639, 4002433436, 1857236927, 1186011215, 2565743137, 2506474626, 2869693354, 3765518931, 1708079424, 2703237025, 2402297528, 563068429, 1459608153, 2846473058, 2604689849, 2216300800, 2424306645, 529388414, 2318346844, 2403016497, 3445305487, 994471558, 2958786303, 3964318006, 4180280941, 3250713050, 3786273909, 969898182, 1008973939, 122032332, 2129955944, 638544021, 2812683054, 2775574130, 1576693875, 525779223, 420097599, 3642591110, 2993241847, 2620193437, 4269035410, 1575785715, 3444471787, 4294921544, 2478645296, 1930412589, 441446086, 2060156797, 554640781, 1583647825, 2456879323, 2790030200, 2100532777, 2854768645, 787011355, 2298053187, 1455122573, 582074911, 14997701, 3518950742, 2881834507, 1940098452, 1701395718, 3034550474, 2087613597, 250442365, 1580048717, 3790302087, 2344367410, 2437266339, 3023419473, 3840138892, 3550683195, 960677531, 4143492805, 467899094, 3581822845, 2855355044, 1254323525, 3603167711, 3285584259, 3091552660, 1528201745, 2387950529, 3188835330, 124684358, 1610853249, 716458711, 3435200986, 2378854294, 199806670, 4193966026, 2799407192, 3782350066, 868481059, 443682634, 3674611533, 763113571, 2754086452, 2528179471, 1576625559, 510326000, 1657616019, 1833044432, 2723855909, 152377489, 998028148, 337731178, 3265443092, 3700237320, 2940004226, 971765863, 2450784377, 3215723394, 3678551205, 4061391272, 3851851231, 2899339302, 1248189013, 570675688, 1276023275, 3759158608, 2500824135, 2509074472, 2527752661, 988837119, 1475656310, 706394433, 2455979371, 2436825652, 2507640175, 626513663, 4005398074, 2644648308, 1290976833, 1654396564, 110135643, 3263622255, 463879869, 1888262729, 4215769909, 1934613129, 3483952775, 1724048463, 3932205985, 2088081195, 861756285, 1594614133, 2492863394, 722201448, 1550394506, 571927635, 2659445340, 2801880457, 3132851170, 165526633, 683594542, 3481462370, 2478620971, 2302899208, 3801656181, 1601163220, 3263774847, 1631993133, 1238601788, 1247510535, 1461290983, 4238127104, 2128496266, 90140812, 1830400869, 751828593, 621557169, 1723496903, 3957415136, 3262786214, 549825854, 2955876730, 2777176878, 1820315241, 1];

pub(super) const POW23: [&'static [u32]; 13] = [
    &POW23_1,
    &POW23_2,
    &POW23_3,
    &POW23_4,
    &POW23_5,
    &POW23_6,
    &POW23_7,
    &POW23_8,
    &POW23_9,
    &POW23_10,
    &POW23_11,
    &POW23_12,
    &POW23_13,
];

/// Large powers (&[u32]) for base29 operations.
const POW29_1: [u32; 1] = [29];
const POW29_2: [u32; 1] = [841];
const POW29_3: [u32; 1] = [707281];
const POW29_4: [u32; 2] = [2030206625, 116];
const POW29_5: [u32; 3] = [1797710145, 3816168866, 13565];
const POW29_6: [u32; 5] = [4219425409, 2265142903, 4119564573, 1570454940, 184033331];
const POW29_7: [u32; 10] = [3969180929, 1340492553, 1739183727, 105569977, 1767257366, 1739519195, 3874617455, 3771111571, 1793220428, 7885570];
const POW29_8: [u32; 20] = [1845676545, 3608513765, 1294341313, 344489966, 566774291, 427680924, 163628113, 422450508, 3222465417, 3727450692, 2861254789, 883344622, 1689193932, 1672377999, 1874044950, 3963222593, 1712211922, 4194848827, 3979265421, 14477];
const POW29_9: [u32; 39] = [2741605377, 3747537770, 2886285109, 1412328910, 1983065589, 3689472563, 746895763, 1865898533, 3190488753, 2306727561, 93165003, 393896841, 3469007245, 350649525, 2503345911, 993127718, 3133114464, 821782878, 626409599, 381575402, 45686706, 1602747444, 2383280150, 2768255957, 404622700, 1968885784, 1077673669, 3777279179, 1028090331, 643293672, 4270324062, 58968547, 538879074, 3280367964, 1962916813, 2823720265, 2293198637, 2545114653, 209610355];
const POW29_10: [u32; 78] = [73607169, 1727263960, 1550447109, 223139752, 474733911, 2907675967, 3776691901, 2917289149, 8658750, 572966205, 3934783264, 3097006194, 1229111012, 552677943, 244540825, 2659847833, 3839719922, 4256484087, 4285080068, 3146272340, 2443489594, 890208720, 2265994015, 386119463, 949159946, 22693323, 1194056901, 1827462345, 4016125523, 3968753268, 960638922, 2816452726, 1620062006, 545777120, 414071121, 3769697272, 204797, 2016773156, 2535915665, 599464091, 1031205166, 917030052, 2226442601, 3339166097, 1797305811, 541956524, 2958721485, 3048266196, 4259459440, 1379998557, 4176468795, 2567940618, 4181173209, 3739384482, 3312759079, 2983647679, 1436244967, 3871463862, 1499007172, 2101608748, 3148042606, 3529524040, 4136411945, 936705246, 3326082955, 2710274333, 1883484962, 361100589, 3022765025, 3931132428, 2649068847, 2761797091, 3525392638, 859192676, 3927252476, 4260244805, 3640817271, 10229763];
const POW29_11: [u32; 156] = [4278603777, 697215319, 202853069, 2954909114, 1550962014, 1496023878, 1782193615, 3665399447, 3085565264, 2841551794, 3719475863, 1273167982, 2320235283, 2098517552, 44349562, 862793635, 2953154376, 1587005149, 3168348248, 1764782146, 2062885846, 1072560879, 1789045518, 2917948689, 2924957515, 2555853131, 2939971233, 681122998, 3174781702, 2662376941, 4123393835, 1483261462, 3334085387, 841325466, 4161363919, 1996038917, 2662316806, 4117921344, 1854020894, 2163718449, 624914160, 4143716802, 1152477144, 3761430858, 3634337359, 740859484, 3562428707, 4026862771, 678311050, 1940514605, 2932426120, 2325287144, 4183216363, 962659255, 3417669325, 2479541064, 298477652, 4169501017, 3758278103, 1711340542, 96141647, 3215275776, 1919119895, 9401932, 2882445344, 1060594142, 355920713, 385890957, 1054224959, 569979766, 3797736015, 3397125441, 195938544, 995733397, 2588893058, 2042240136, 1709410972, 4120956638, 3141477629, 2131485274, 771892488, 2816894770, 3054172189, 3611267231, 2977682122, 685750076, 4150739665, 3619886069, 3053318796, 899466401, 454257567, 4246663479, 2422422368, 2084224089, 3446576329, 1212477009, 506911052, 2987008999, 2040308234, 3639166139, 2462919952, 4272561960, 2096264055, 3729176847, 2102556768, 2603507063, 1899102954, 1553729706, 122344717, 859323548, 1649990386, 1521267614, 1927659096, 2731685046, 3916751522, 198593844, 1228999290, 3674435493, 3172342912, 1702890034, 1328949637, 3890640112, 1647424304, 2639285503, 341668221, 4107683075, 658508302, 1929600924, 168815462, 3733313214, 3380373144, 3663192695, 1301952946, 1856661354, 490667334, 1640212579, 2118340383, 884101983, 3676138166, 3368341196, 1984411539, 4128071055, 607633591, 208516855, 1101438860, 2842144949, 724302134, 1515113562, 72509015, 3435476047, 3059758279, 3665234599, 1182272530, 2792877457, 1190212543, 24365];
const POW29_12: [u32; 311] = [3607928833, 3172288055, 199160624, 3815140915, 4105135486, 354905100, 3334288201, 2374822670, 1591127775, 257429645, 1191501490, 1839186182, 4012788896, 4287636051, 442130510, 1519890657, 1288950902, 158929220, 4220851980, 3951512010, 4194716349, 28529624, 3940969666, 315223375, 816580711, 1792851290, 845620169, 2590898178, 2193361451, 260246424, 953995987, 293040003, 378698822, 1766866274, 3894726485, 3059015199, 2210108283, 685592791, 3465961704, 4117926780, 2444200593, 2515179420, 2695137729, 864772394, 3019284117, 1419771309, 703241944, 3693031146, 4033289377, 2451600091, 3740912397, 1363611801, 1100094045, 1789977742, 1402519375, 2934850417, 2560495362, 1713428760, 4209170350, 1296762553, 4177610136, 1073420145, 3871056953, 3387126897, 512427028, 2665482997, 3291283379, 2751792998, 661182206, 2101149465, 788878807, 4100594244, 99048184, 146464003, 3380645691, 3819035076, 3603170945, 701081015, 3720253032, 130253503, 3679112580, 1794752709, 1209476919, 2671937841, 87671778, 1752746183, 4041650367, 4290916551, 4167356879, 3876112030, 1108122061, 3491100392, 1489365511, 373185189, 1883413925, 2425193676, 2323548305, 908560591, 1948021589, 3776848200, 47334853, 2963562145, 3102090119, 3742296626, 3195412642, 2807873934, 3274976012, 1756841097, 650785134, 651748604, 2981868088, 389371324, 3895577665, 2011007468, 1241038096, 560605404, 2680398066, 2580194201, 3768424261, 1401956559, 2125168161, 1817282670, 1069321318, 611379508, 4080385706, 3777745780, 1405905850, 2342863597, 2922904845, 580076185, 3201346217, 3927498483, 3584531193, 1264830103, 2227961968, 1490369089, 2482481839, 3009000827, 969504404, 3905341734, 2874668988, 2045899191, 1089128399, 1504976194, 2833313782, 3063026411, 911402527, 1265656537, 1000807348, 3466284855, 2416281739, 1318343005, 626681002, 1411270607, 627171802, 3899677631, 2769301206, 1951203588, 2499971370, 776095777, 3786039761, 1317617964, 3185899345, 4132713697, 1305149308, 3763748177, 1703616143, 2381192787, 423169192, 2338580159, 164376048, 3534014631, 2435384891, 2536480092, 2611549869, 3390039588, 2506328084, 4047419198, 3611123991, 144779922, 994101540, 2523775857, 3972705149, 458202001, 3947530004, 1902196855, 2482166846, 2510589980, 793211894, 3979960687, 1791603334, 2677229163, 3963053333, 2889462311, 3639690090, 1727091983, 2132273135, 4260113040, 4136804362, 366651068, 4014155770, 3108998370, 3524928879, 163789635, 1857975067, 2175199387, 3061735179, 1671255764, 2487618669, 170315554, 3600792564, 3129952624, 1895671812, 2394379137, 1058623778, 3720215419, 1625703422, 1854220682, 1922473404, 1319953466, 3003019916, 3369563474, 1720693313, 3027887928, 2700242801, 2236329480, 2274388727, 3748013616, 1803164013, 1997843968, 3591495713, 1395040688, 2646289185, 1044704746, 2468273032, 3399212506, 2308715228, 3242205410, 466084230, 2675183433, 1513832991, 2588626825, 3740540717, 2653270253, 2476312429, 891627129, 450536579, 3552176684, 465569917, 3776661276, 1494793834, 2304900165, 1244037087, 3765131358, 1421214113, 2216329758, 2377502548, 3461492606, 417469843, 3927482701, 1900648322, 237767264, 2245383962, 2743269639, 455634196, 656163457, 3436736663, 3007991801, 3500075783, 151551344, 1861964282, 2332367313, 227261633, 928786803, 442629844, 223744743, 2914982971, 2271868058, 3591067978, 4217647960, 374514385, 4230019140, 1550676035, 3377325821, 3678940869, 1049269419, 2477001772, 812696853, 3495418575, 3427581880, 1068364743, 1305279423, 3640508285, 1573640499, 2030179892, 453940246, 555867500, 2104328489, 1169480451, 1057036024, 1007972776, 3374167874, 587514179, 3159698528, 1705338233, 2465824868, 1335209891, 957788808, 3503441638, 148716156, 593666729];
const POW29_13: [u32; 622] = [303644673, 3183313359, 1076783228, 999911089, 3398129928, 2779329913, 1032887498, 3986457683, 2955592949, 1691800665, 3824605515, 2804753885, 3452962860, 1060557084, 3938354736, 1895760521, 2235469582, 3475924610, 158840748, 2465874169, 1305903705, 47725050, 72716818, 4282885909, 4241690860, 4207749816, 1075135789, 3023104985, 3829299750, 3029023672, 1193029810, 3128772959, 3866776527, 4003411115, 2382880661, 4163238484, 3751602836, 2035172010, 541641876, 245401834, 1858547923, 2201891579, 4173044206, 2941936212, 218252298, 1820008548, 33580923, 167399357, 1543106286, 2446335653, 2111948432, 3883029972, 3496468947, 752335179, 817552192, 1917461340, 1324761443, 168684988, 2104242380, 3124339844, 1141408612, 2074356148, 1167598633, 3357103207, 2471197125, 4200966721, 2402964820, 1333066366, 3391310489, 3043470037, 895188397, 2392954091, 2952156610, 2798187726, 3425704694, 4109012957, 1888190658, 1345700401, 721060681, 3876834174, 2209380659, 4092844177, 1823377013, 4248159515, 2632724164, 2063037533, 2902415591, 490954952, 1044158739, 2951434559, 2521421609, 997866532, 1952446248, 2160056446, 3186384396, 2535960823, 838019242, 3119346130, 3861853776, 3623933842, 857167795, 2250467289, 1780232445, 1277821502, 2082379725, 3495661016, 3018854047, 1345333239, 4280922518, 3466106207, 2579113204, 39317414, 1472739731, 1792810543, 2185078144, 1487293172, 401857417, 2146057477, 3143789664, 2699086962, 827996356, 4064349888, 1662353986, 1797375974, 979056531, 1344912360, 765649955, 2771210394, 1164010295, 3788606568, 2802032172, 4231796015, 4001203572, 313890799, 3052869518, 1301272702, 4070120662, 3340639114, 2007663329, 604496786, 3897245152, 3026622833, 4284829951, 1828563085, 1540793618, 1729659901, 3154823257, 2135200319, 4183552731, 2997372558, 111567451, 532555489, 687137494, 3599716408, 2316350567, 251811707, 1434760416, 1432186602, 1096469152, 2624751716, 1368985992, 3212505234, 3055001132, 2473674731, 2150232166, 146699872, 2837058512, 2647805246, 2096270624, 250307650, 844431077, 1246568178, 555089930, 4063302278, 3306804856, 2060007132, 1539650155, 3433967093, 2830736770, 4223922604, 3733371591, 1905078074, 268715723, 1802178127, 2026703815, 2324444230, 3440092954, 2057951711, 136534841, 3684051805, 2104244864, 1744845513, 2192314422, 2305196093, 131872073, 438869222, 674629894, 3299635811, 1106938552, 3254925718, 3192711691, 3146361283, 1755736231, 1291673623, 4261541459, 1986268199, 1315835509, 3009412613, 2973425468, 3640768416, 4224096917, 2882674484, 3355313666, 1279142813, 1160361149, 50119274, 949924603, 2933555006, 1274125673, 2472227477, 1519351166, 201587781, 1074748878, 4229158278, 603906850, 990754641, 4294456296, 345136702, 3560171052, 627635694, 4101663877, 142723961, 2378988083, 1245764179, 2973857140, 2478095233, 62555848, 1808536722, 3025895988, 3104995285, 3373929246, 4169827753, 2840358176, 81042179, 285927421, 3337938645, 1305479039, 2862535986, 1874603606, 807474687, 1660116983, 3434786736, 3554253119, 2702055524, 438987431, 2307841985, 1455140514, 2845740475, 1883605201, 1280643263, 581237717, 224756748, 1269082234, 1890630962, 4176579598, 2418094911, 521775027, 2584291463, 76563234, 4224875385, 2855407519, 2144695537, 3277115083, 3756289399, 2153175735, 3604124288, 3258293705, 2042617615, 2472190561, 252576920, 4001317443, 1212884260, 1549325556, 4088074707, 22493855, 33328745, 2960453593, 2527772030, 2591296152, 619193823, 3989256628, 3906079973, 1210839857, 1234498834, 4223523499, 973035588, 3177917377, 2556043565, 1271906994, 2006279264, 156770796, 3884106513, 831340199, 4053124734, 2982401735, 4001576003, 2516342895, 2930489120, 2028053718, 519993087, 936909979, 1071994874, 725603483, 3497336401, 3610814535, 3930657257, 3977278599, 1010148812, 580900628, 593301858, 3327728996, 328744601, 3945396574, 2505306274, 2342321917, 2815739140, 3389869102, 3085070177, 1610655666, 4093683037, 3192440806, 602451862, 3851066731, 2144890088, 950713960, 4287963561, 3286490648, 136894868, 3319128654, 3904646232, 3985523626, 4197905340, 1694102576, 501793921, 1206701048, 2833568710, 3371724344, 3052249003, 1744131785, 2083286690, 1859301448, 1371001931, 3286393557, 3401800068, 34471061, 3591009703, 2518753186, 874480531, 2566451611, 1477745000, 328163581, 244124411, 2892083124, 2298202563, 2167594460, 2538473758, 2357707143, 977661367, 1581329216, 1592884799, 3698473987, 3185681363, 2455621907, 3364832939, 1054679906, 2217747561, 4105059165, 3959399075, 3548450065, 3774469321, 3791714722, 3553057415, 2063297147, 1807493563, 3977593379, 3254904003, 2599804607, 2020243000, 1118199017, 1564055810, 3370022, 1734908882, 3623326673, 2966995191, 3642308246, 3449150232, 1502085375, 3446684038, 718560555, 1447552798, 2812607505, 3644257274, 444292967, 3362075634, 1643860215, 3089826123, 2115551495, 1254916978, 1087167284, 869638441, 2010653041, 2527916487, 1285767759, 2416012550, 3547777031, 915740087, 2729231436, 162451211, 365493721, 3877582547, 2277113986, 572868686, 1262230636, 1895163344, 628196366, 2922199147, 4037231086, 3420625536, 2410166508, 1909185220, 2702337144, 2725970107, 4261606944, 3751913945, 3050620361, 990491761, 3145229247, 3237716436, 4082857938, 390867178, 1768964419, 751005573, 2546755211, 1112835765, 820035761, 986213907, 2473306682, 1360563042, 1905677837, 3181662095, 2911801772, 1901440501, 344892035, 3006094535, 2680608443, 3732710880, 3541067859, 4055206617, 2202617299, 2080481907, 86028653, 2033998330, 1363819323, 3777887954, 399211942, 977260394, 3736523869, 1913224162, 4013933894, 1529265582, 2007809405, 1095173889, 3696356081, 4229713491, 2687125930, 2108457172, 938560412, 3425892164, 3351361513, 3939588737, 3509314163, 3847320545, 3911595459, 149317008, 3256445432, 3557227499, 1627632369, 1142527704, 527475203, 1273749217, 544269845, 1653200233, 212332584, 3154602799, 2554156023, 3164377227, 1953273019, 3124461181, 281702484, 2973367854, 2084540394, 391716868, 533992137, 3772849927, 10812354, 496132998, 3916517968, 907608417, 1716473062, 3447839240, 990843744, 3014585829, 3774531883, 3979986077, 1490012160, 1053656454, 2965511562, 3121392799, 4288672751, 402781092, 428614128, 3818398840, 810522711, 1659949872, 54897046, 3971042606, 3321161469, 1385187039, 2492529446, 3067064010, 183154593, 2655170055, 1663939522, 1573558418, 3519154304, 1154816616, 4111070745, 705578613, 1942823529, 1774191611, 630059831, 4180110313, 3706196772, 100307053, 2381605985, 1985147547, 3386256081, 468300529, 2951787591, 389561435, 4254671518, 3867720458, 3183869016, 1500247372, 2558315356, 1480087440, 55126764, 1210148925, 3681601188, 3519747474, 3340697889, 2797517767, 855268, 2128908273, 2509415773, 3803681356, 3796106933, 128933844, 69661913, 684821642, 1456666030, 3909086261, 133474552, 2814021940, 1385209203, 1521674972, 1988313066, 2379102257, 2348906564, 4158524805, 338482558, 3888007623, 1995626085, 2428026966, 1046401992, 575781181, 2301318754, 181133530, 753396344, 3655347530, 4292433521, 3945538019, 1452083430, 1405107381, 283647490, 3917176879, 3188796574, 2707263909, 1329780507, 3512292689, 2188459725, 3736113550, 1278090504, 1315319779, 1591842429, 3936306061, 703921010, 4281991091, 2117759127, 3819397001, 676858981, 1122763461, 2597188748, 503031614, 2595031841, 1860404840, 2527881539, 457668224, 3911672161, 2601854028, 691119667, 82058875];

pub(super) const POW29: [&'static [u32]; 13] = [
    &POW29_1,
    &POW29_2,
    &POW29_3,
    &POW29_4,
    &POW29_5,
    &POW29_6,
    &POW29_7,
    &POW29_8,
    &POW29_9,
    &POW29_10,
    &POW29_11,
    &POW29_12,
    &POW29_13,
];

/// Large powers (&[u32]) for base31 operations.
const POW31_1: [u32; 1] = [31];
const POW31_2: [u32; 1] = [961];
const POW31_3: [u32; 1] = [923521];
const POW31_4: [u32; 2] = [2487512833, 198];
const POW31_5: [u32; 3] = [1353309697, 2948261936, 39433];
const POW31_6: [u32; 5] = [2111290369, 854830039, 1377820608, 3005187674, 1555015626];
const POW31_7: [u32; 10] = [1304393729, 558465812, 2768012290, 3935646446, 3376640041, 1419477874, 1557778152, 3873581017, 2245632988, 563001632];
const POW31_8: [u32; 20] = [3820941313, 3840574348, 1970562388, 1279978999, 91057081, 172159608, 7026786, 3609778129, 320477644, 2720004857, 2683868502, 3872769187, 1705702550, 1250974998, 1821061582, 2142610495, 2457779444, 131107681, 1215733575, 73800524];
const POW31_9: [u32; 40] = [3900563457, 3605508898, 1080835543, 1839856042, 1887789426, 506338258, 1664410539, 1941444729, 2303133992, 1204730127, 4228901863, 3235428013, 108090832, 4278312395, 4187964700, 878213001, 1487687387, 2089710316, 1913306896, 866021004, 281352193, 3790189294, 1071396380, 1070474072, 1560701226, 508984177, 2267895212, 3095779249, 3222665897, 3587404114, 523699303, 1215001001, 2154196787, 3884596454, 2367833007, 2975277751, 3968326605, 1164131563, 636920197, 1268116];
const POW31_10: [u32; 80] = [1425784833, 2309179946, 605198140, 4075439659, 2712533997, 103860628, 3011372056, 1930212728, 1296157408, 1058369540, 1528293566, 1111476611, 2626896309, 2709728996, 1397738171, 1300019571, 3454944728, 681924413, 506805944, 223257902, 3164499261, 877689735, 252073363, 1368223871, 1957508588, 2561824618, 745102383, 3229593914, 1953834733, 4023459261, 2970522886, 3289050300, 1988414496, 3618191877, 2791612790, 3753666209, 551881119, 2867462426, 2431166687, 1542558833, 3082166710, 1692150099, 862968556, 1700789331, 1196859083, 1734165634, 2284249015, 3240024613, 3607341121, 3616513708, 3272709503, 3622879435, 741213114, 1560534899, 3403198491, 3230513765, 4203027176, 579111566, 2236689072, 1728386745, 3852156906, 3851502305, 3358676318, 1552411624, 2866922094, 387134890, 3075002974, 2260892662, 124842076, 496426192, 700274592, 1288973540, 2534470918, 1648355020, 2966648217, 3670674092, 2654505063, 1625485661, 1800796861, 374];
const POW31_11: [u32; 159] = [3120005121, 488096230, 4043397809, 3846877022, 2483592266, 1741088811, 1435142880, 2050319480, 517262951, 722574780, 238070319, 786965630, 322204487, 1103090908, 2967926613, 2315724446, 2772989472, 1810548431, 1359881341, 4051147333, 1218086232, 776892200, 1943969984, 819401991, 3332468732, 1228365157, 19838017, 3010084475, 918974391, 3616871658, 3127018519, 2188858850, 3991305607, 1675249399, 1788150933, 1662898117, 1569457105, 3386262069, 3142393857, 283522619, 2220147540, 2991940678, 958689879, 4038295507, 2789663217, 2933447657, 1366791790, 1923121992, 1038666084, 79141466, 1862841584, 4172033108, 1515140411, 1459517991, 2435126659, 1263530374, 3461849730, 1023461415, 360959558, 1480477433, 4015033035, 2612764845, 411967187, 640257764, 3364343281, 742559927, 429175685, 1115349365, 1534393072, 273676385, 41832834, 1338543611, 737323479, 1609524875, 1031988474, 1156849110, 3163325674, 1359180346, 1113088160, 879320928, 1185571731, 2639531511, 2496406806, 462087665, 1734468616, 1613759369, 922076852, 1592024184, 1673328534, 3345308531, 2736181850, 4022461859, 1053087598, 722982409, 841417491, 2932897596, 2825857611, 1506576220, 3356827401, 838819962, 4246599948, 2694391874, 1631357300, 2587807358, 885057850, 254343006, 1347746364, 2524302616, 2190891935, 242348930, 991113938, 3891063097, 2249770445, 1391269286, 1741318817, 3470463227, 1941278356, 3112312335, 3611229996, 1591476171, 3905400994, 4270906928, 728748276, 29536128, 201741823, 1083723043, 871807055, 1207413132, 1311110999, 3698150249, 754440540, 2435230741, 1700095394, 2263890850, 3675382371, 2041485294, 3739417473, 697942096, 2689881429, 3435609081, 3358084069, 412824872, 2743917970, 1687371847, 1412072137, 2638121547, 1733477680, 1180409564, 3573621075, 1182797785, 4279670835, 622698019, 1631163303, 1252862013, 4187932825, 1254825595, 3715086166, 3426328017, 140189];
const POW31_12: [u32; 318] = [3018784769, 419506709, 3233212213, 2647101854, 1477793438, 2458093334, 2288485237, 3429482278, 2831108905, 3809323989, 403137974, 3835811100, 1610459238, 4109149581, 1610747818, 1074953727, 2920186091, 2577002919, 2589919117, 462552040, 1462936280, 3094523706, 4105142664, 858835160, 2719310131, 2913242650, 3972794176, 1676912351, 4280513099, 923764361, 465224322, 2812484591, 3066396016, 1348073152, 4199723738, 1500985824, 3375336889, 4146043012, 1454194161, 851561957, 4247797608, 1024323299, 4070074584, 4209776858, 1943151726, 1029649909, 1083700918, 1639565385, 3862138132, 1112783654, 1468101321, 4135322607, 1062896025, 1603454720, 3050916297, 1596325937, 3696381945, 1554644965, 3298910421, 3289579255, 292490621, 616477315, 564799944, 1151973107, 1537218851, 1174576388, 3905729297, 465868533, 698473488, 1792091640, 2945073796, 3189415559, 2446703543, 2912460746, 637266798, 3657401194, 1510126640, 4115069262, 3648087043, 605289505, 2464500956, 467870221, 2105706646, 2130955145, 486376380, 1951498815, 4290218813, 2179473839, 1935789855, 1825772748, 172130114, 1197404015, 2603367882, 2460444193, 3307498781, 3862141976, 753261873, 615019379, 2914438021, 2627031896, 3239475496, 2496043199, 2168300320, 1171971473, 3599919440, 3109516901, 2958093187, 11899504, 2740177559, 3903901458, 884552025, 3093790134, 957145515, 4084008785, 2307781754, 3738538007, 293067613, 3597823465, 3240542144, 368882458, 1670042397, 4152571281, 309483204, 3669862414, 1884363565, 4128384557, 1387982208, 3697023611, 3698061679, 3152908271, 320634861, 3132422725, 1788486808, 4229940495, 3381901194, 4250442499, 3601486272, 1145260618, 1550198089, 34745150, 3956057056, 595514528, 3828247218, 1473795595, 2609913194, 1703863313, 3811751146, 486210934, 9348244, 591691691, 3467033910, 88755306, 3005002439, 3743182597, 2996665153, 1970416184, 3788536607, 153893617, 128047321, 632017363, 397418666, 2881420714, 2956471890, 1181119044, 3036255393, 98507404, 1035178092, 3324933040, 3782741863, 4176523726, 1631122807, 4248599254, 3528346344, 3766981847, 2039336580, 3031794437, 2305122739, 2074825435, 2112728216, 2645744926, 4103404197, 2500935439, 3610013250, 2335060409, 2358894139, 3742733646, 2429514141, 877651683, 3173403496, 2271349607, 526525851, 3426636266, 3558349301, 1762698863, 3219633537, 1000803285, 3026367708, 3237224684, 3661302038, 3560761596, 3274671807, 123055829, 2430724955, 3583392084, 1620450329, 786940026, 2666934574, 3175328535, 2721719547, 4111833181, 1260489798, 2748812635, 1759741972, 3643279594, 4178723567, 1785976326, 1775532742, 3394440427, 1092540046, 725274647, 3353843106, 1487980419, 1893843101, 720244643, 3576064213, 4284131422, 3548959637, 3093012789, 1784730937, 3554465193, 3635561711, 2923335044, 3242071688, 1728240122, 2457964547, 2309058770, 1311798242, 1796666200, 1421606769, 1003035025, 509218541, 1001007100, 2513790966, 2579349489, 2368558506, 1674638636, 1848570716, 3360991553, 1519298938, 3041316120, 563730877, 3258334470, 502273689, 18205981, 3522179972, 3882181459, 1213464180, 587602597, 3241644306, 4042784099, 1975158053, 3023488285, 4207961823, 1353678974, 1769145680, 3428501067, 2345068356, 2217643002, 1333238334, 487305453, 437806812, 87016367, 2947505658, 1900708318, 1838188938, 3294142465, 231538659, 757985396, 3106426697, 2999167873, 3665346125, 1491136468, 658022211, 2005742040, 4154854801, 2804986423, 3137674860, 971420416, 1203598082, 1094155649, 2743938545, 2028706224, 2688847041, 915909610, 238345560, 2287176763, 3035995830, 1160017862, 2848858409, 2673211775, 591232133, 1109898692, 2700262121, 4215639262, 127379574, 3675139257, 1802194813, 3124284639, 2162602875, 18064492, 3219263946, 3310803175, 2740665076, 1138589124, 640377103, 1510362163, 2473310210, 4];
const POW31_13: [u32; 635] = [1742602241, 2712694092, 3969844521, 4030024960, 3498984537, 3608158682, 576130865, 413907429, 685334448, 2310203983, 3614129488, 2826104460, 2409640991, 4063374733, 1477292428, 2081766794, 1394595811, 3345035813, 1099378286, 2815653833, 2904983105, 1424980588, 3595308604, 940700773, 3922907263, 3759905200, 2635160994, 2709716432, 3907941784, 1665894635, 4207386969, 1733690565, 164929134, 3300318735, 354481355, 2562427821, 2160848272, 961345105, 3365044123, 1843189937, 3084862570, 3974595972, 237355324, 1936488715, 2701673480, 3942094087, 3512375909, 1422117058, 1210054132, 4128467560, 971193828, 2322652741, 1550099421, 4084627544, 2753748181, 2111537343, 1614730916, 2657905887, 569549264, 3245912140, 2344967673, 2243340516, 253999102, 2004450639, 284115510, 1273879578, 761323451, 588931017, 2330833468, 1304890665, 884856597, 1180867463, 612510327, 2307123015, 248328847, 3566610571, 1084727639, 3566188200, 2109971242, 1692532445, 516814364, 4198410336, 11582444, 2177407516, 3708307492, 1709899827, 2874710400, 1274525827, 2111164058, 4070338644, 400439673, 1356063997, 1478669924, 3784739233, 3970025643, 2667544651, 4069878409, 1030572482, 2880952372, 389293382, 982675512, 459875096, 3712204933, 2687344655, 3004405439, 284104407, 3944193068, 831810388, 1308948787, 3959581066, 2488261527, 107772095, 164213469, 1384608366, 2311715038, 2558943373, 473580057, 1704616716, 496989078, 2688908018, 1574625329, 1060021895, 1490036773, 1540921, 3096216483, 3100373184, 1537788597, 17470621, 3188476918, 2453383104, 1431325646, 195756539, 2880896207, 646593199, 90330352, 3961124530, 1827399992, 1633344461, 3741151065, 1526580449, 2019661887, 735159922, 3221729095, 2755534372, 3621298717, 966384068, 482669086, 945383312, 2441376446, 927823971, 1967343761, 2258372909, 646033921, 1652706794, 3471710200, 58292462, 3535345003, 3002082721, 213539009, 2776339201, 3562761185, 1954167026, 3302407048, 1304646401, 4213703860, 1004101238, 3169011127, 4148571839, 2564293074, 1729630728, 2766453747, 3210948511, 884630112, 3920666526, 2005012169, 3525795472, 3931451014, 6224738, 910001578, 1304686443, 151718680, 407491051, 2619604510, 3159210219, 3816730597, 880480511, 1115767705, 3002908945, 2707114743, 635594262, 1726018006, 696637100, 513482034, 3305263239, 2798416989, 1723305, 2011353818, 705861072, 2723201758, 2924166530, 1108452763, 2068774330, 1495460864, 1691603250, 456651540, 456923474, 1959681531, 857783853, 3930669182, 2383874766, 4287839069, 2976331139, 1208460834, 2885060970, 3047970969, 238351352, 3336153557, 2899307923, 2271879335, 3093104656, 3344624615, 3855037668, 1130818629, 1235935730, 1643697088, 651097950, 918462320, 3717032221, 3197438660, 4188258045, 2522845555, 3271357381, 1538710606, 677340008, 2468511212, 4254079112, 658921195, 4067520048, 116661002, 2150343726, 2817660409, 3586583391, 1482025530, 1260675908, 1452495403, 2959503405, 756029845, 2642229035, 1498028053, 3091970612, 569961004, 2329761040, 4292169792, 90222790, 190387838, 2781559307, 2917291193, 2691026458, 1075189898, 4059944629, 4114364763, 3830989952, 3351765634, 4282342604, 3939445622, 1284783665, 2376071789, 925272463, 2364509562, 3703468763, 3311558520, 2980519534, 702072550, 1131176482, 1015663272, 2170462071, 2320129449, 3328536099, 2523170352, 2233495964, 953653350, 537220430, 3258604626, 788472508, 1513210443, 2269189121, 225396670, 4042124581, 3970457239, 542819208, 1064864224, 15599949, 3681733175, 3568163747, 435612715, 515167662, 2920074478, 858295613, 2021232959, 4294514297, 199939877, 874059115, 3043261335, 724543880, 557003460, 3496395691, 3514106423, 3550568600, 279845898, 2255561333, 2695916856, 3171370168, 1096833516, 1441325713, 433034286, 2374659071, 1330891183, 4223843286, 962673246, 2140818628, 4225430131, 1684729340, 2705128107, 707784248, 509351241, 1260865699, 4171859855, 3798313893, 3744144457, 3832767151, 3214278779, 2126972581, 1322182129, 999821442, 2984750496, 3230061016, 191820816, 703926511, 578693817, 3767317383, 3819895309, 3867149923, 626736563, 3759588883, 2948954341, 899990890, 3298124329, 2807236639, 3843579196, 1175298984, 3320790919, 308595574, 1591588158, 899369493, 14799420, 2829862714, 2944200479, 3157141718, 2376984832, 3809211207, 1128878942, 1752683221, 3037718287, 2495148815, 2642325320, 2667307900, 1681086360, 2491706114, 50620460, 2496263600, 138337152, 2966611559, 3819947952, 3357831871, 3714499188, 2742600654, 891376157, 1263040894, 1397195941, 1196628561, 3169290598, 4112182048, 1817194505, 2720356475, 3592261524, 1979701283, 3382271511, 2761309276, 2534251817, 2909157238, 3884612364, 1957501749, 3335269372, 1110221348, 3582796558, 4265299726, 3328991437, 1962564627, 1576239011, 2318280151, 383073149, 3592155296, 3655169945, 1162442196, 4292171127, 2429088230, 3359427039, 4268348448, 3706225061, 723682994, 578194845, 2536702371, 383875365, 577216906, 1997248387, 856921253, 2139686297, 1837767581, 2120201901, 3189412593, 2707332447, 2109041594, 2377975350, 1903059381, 2323705884, 3506337925, 679208764, 1467729428, 569461524, 2249943848, 1871392477, 2418401166, 3339243325, 1947645141, 1716848793, 1375820726, 4087047552, 1747489454, 22815696, 3454086193, 897252209, 1671384647, 2815952662, 755326187, 2074696402, 1741175855, 3659919168, 2313570242, 1953266518, 1679709350, 767347542, 2664118553, 3559981454, 2161973795, 3514438343, 2134804417, 2712509674, 3949219881, 514783764, 2532009617, 1330811725, 3863190624, 1934885504, 700124836, 3141348565, 3774480605, 353971280, 2085103681, 3491245646, 463693460, 2098012506, 3954253967, 1400103191, 36511640, 752541941, 3738400088, 4114201656, 846741457, 1589107444, 2083233961, 1096448150, 2585105136, 3353854165, 1424813123, 2632857786, 22520950, 2989071093, 3012014911, 142167267, 2136931379, 2710847877, 1308539610, 2128524691, 2738618409, 232439464, 2971331669, 699686869, 856592908, 2619308329, 3107261014, 333379732, 3824336016, 1051187204, 3546514611, 1464263119, 2181070272, 133096427, 3615003023, 3471075976, 52815242, 3379588565, 56641150, 4047976038, 1413000684, 1648150629, 2099201989, 39240609, 3758920611, 4250815576, 387627480, 3569186946, 3965003118, 414323464, 1539237033, 1509126441, 4143406457, 2920674546, 3532744036, 2718781690, 3841783144, 1973748669, 3087881975, 1033502228, 1260936963, 3096176660, 2292436222, 2666901210, 3495175453, 2299822890, 2165980566, 1556534880, 2359613267, 1439966100, 3208895672, 3703730780, 549009779, 462732450, 1564638356, 2188371518, 2261740360, 1049543683, 3432977622, 563988795, 3063490889, 143883901, 3110230930, 3327294448, 1676983126, 1158668336, 930878540, 3916676239, 2896575052, 3894139248, 1411023284, 650666444, 413987502, 2304139707, 722081477, 3130866484, 3715828678, 3222365880, 887685607, 2283444283, 740343702, 1508259186, 1117792936, 2068700327, 1060755268, 873702885, 2332769466, 3625190651, 2375782112, 3829179462, 2260661047, 3495790441, 1914553319, 939689320, 3253990951, 1252334930, 3296139429, 3282440456, 1306898975, 2892499023, 1550191943, 838881807, 2388933249, 1552390444, 1688912152, 3124757624, 466908810, 71552052, 2417772964, 3246482, 2470839226, 2377505316, 4161279486, 3383731011, 3007865013, 4264254790, 2600609437, 1713854493, 4286450349, 3144723533, 1759591282, 4155149512, 1879878928, 1555014535, 394741672, 505005590, 556141291, 1812252180, 896817811, 395900714, 1974143062, 3863368026, 205727200, 1039736694, 62236392, 1026952601, 3391053023, 1572679856, 926803867, 3654303694, 4030898872, 20];

pub(super) const POW31: [&'static [u32]; 13] = [
    &POW31_1,
    &POW31_2,
    &POW31_3,
    &POW31_4,
    &POW31_5,
    &POW31_6,
    &POW31_7,
    &POW31_8,
    &POW31_9,
    &POW31_10,
    &POW31_11,
    &POW31_12,
    &POW31_13,
];

}}  // cfg_if
