// Copyright 2016-2024 dbus-secret-service Contributors
//
// Licensed under the Apache License, Version 2.0, <LICENSE-APACHE or
// http://apache.org/licenses/LICENSE-2.0> or the MIT license <LICENSE-MIT or
// http://opensource.org/licenses/MIT>, at your option. This file may not be
// copied, modified, or distributed except according to those terms.

// This code generated by dbus-codegen-rust from xml generated by
// using dbus-send to introspect an item object path.
// Generation command without `--file` argument:
// `dbus-codegen-rust -i org.freedesktop.Secret. --interfaces=org.freedesktop.Secret.Item -c blocking`
// See https://github.com/diwic/dbus-rs
use dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

#[allow(dead_code)]
pub trait Item {
    fn delete(&self) -> Result<dbus::Path<'static>, dbus::Error>;
    fn get_secret(
        &self,
        session: dbus::Path,
    ) -> Result<(dbus::Path<'static>, Vec<u8>, Vec<u8>, String), dbus::Error>;
    fn set_secret(&self, secret: (dbus::Path, Vec<u8>, Vec<u8>, &str)) -> Result<(), dbus::Error>;
    fn locked(&self) -> Result<bool, dbus::Error>;
    fn attributes(&self) -> Result<::std::collections::HashMap<String, String>, dbus::Error>;
    fn set_attributes(
        &self,
        value: ::std::collections::HashMap<String, String>,
    ) -> Result<(), dbus::Error>;
    fn label(&self) -> Result<String, dbus::Error>;
    fn set_label(&self, value: String) -> Result<(), dbus::Error>;
    fn type_(&self) -> Result<String, dbus::Error>;
    fn set_type(&self, value: String) -> Result<(), dbus::Error>;
    fn created(&self) -> Result<u64, dbus::Error>;
    fn modified(&self) -> Result<u64, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>> Item
    for blocking::Proxy<'a, C>
{
    fn delete(&self) -> Result<dbus::Path<'static>, dbus::Error> {
        #![allow(clippy::bind_instead_of_map)]
        self.method_call("org.freedesktop.Secret.Item", "Delete", ())
            .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn get_secret(
        &self,
        session: dbus::Path,
    ) -> Result<(dbus::Path<'static>, Vec<u8>, Vec<u8>, String), dbus::Error> {
        #![allow(clippy::bind_instead_of_map)]
        self.method_call("org.freedesktop.Secret.Item", "GetSecret", (session,))
            .and_then(|r: ((dbus::Path<'static>, Vec<u8>, Vec<u8>, String),)| Ok(r.0))
    }

    fn set_secret(&self, secret: (dbus::Path, Vec<u8>, Vec<u8>, &str)) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.Secret.Item", "SetSecret", (secret,))
    }

    fn locked(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Item",
            "Locked",
        )
    }

    fn attributes(&self) -> Result<::std::collections::HashMap<String, String>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Item",
            "Attributes",
        )
    }

    fn label(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Item",
            "Label",
        )
    }

    fn type_(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Item",
            "Type",
        )
    }

    fn created(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Item",
            "Created",
        )
    }

    fn modified(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Item",
            "Modified",
        )
    }

    fn set_attributes(
        &self,
        value: ::std::collections::HashMap<String, String>,
    ) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(
            self,
            "org.freedesktop.Secret.Item",
            "Attributes",
            value,
        )
    }

    fn set_label(&self, value: String) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(
            self,
            "org.freedesktop.Secret.Item",
            "Label",
            value,
        )
    }

    fn set_type(&self, value: String) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(
            self,
            "org.freedesktop.Secret.Item",
            "Type",
            value,
        )
    }
}
