# Getting Started

Install Rails 6

```console
$ gem install rails -v "~> 6.0.0"
```

### Generate an app

```console
$ rails new example_app
$ cd example_app
```

### Add `rspec-rails` to the Gemfile

```console
$ echo 'gem "rspec-rails", group: [:development, :test]' >> Gemfile
```

### Install the bundle

```console
$ bundle install
```

### Bootstrap RSpec

```console
$ rails generate rspec:install
```

### Generate a scaffold

```console
$ rails generate scaffold Widget name:string
```

This generates files in the `app` and `spec` directories. The files in the
`app` directory are generated by Rails, and Rails delegates the generation of
the files in the `spec` directory to RSpec.

### Run migrations

```console
$ rails db:migrate && rails db:test:prepare
```

### Run RSpec

```console
$ rake spec
```

or

```console
$ rspec spec --format documentation
```

If all went well, you should see output ending with:

    29 examples, 0 failures, 2 pending

This output also includes the following controller spec:

    WidgetsController
      GET index
        assigns all widgets as @widgets
      GET show
        assigns the requested widget as @widget
      GET new
        assigns a new widget as @widget
      GET edit
        assigns the requested widget as @widget
      POST create
        with valid params
          creates a new Widget
          assigns a newly created widget as @widget
          redirects to the created widget
        with invalid params
          assigns a newly created but unsaved widget as @widget
          re-renders the 'new' template
      PUT update
        with valid params
          updates the requested widget
          assigns the requested widget as @widget
          redirects to the widget
        with invalid params
          assigns the widget as @widget
          re-renders the 'edit' template
      DELETE destroy
        destroys the requested widget
        redirects to the widgets list

Output like this can help to quickly gain a high level understanding of how an
object behaves. It also exposes which cases have been specified and which have
not. Note the balance between the examples for the `create` and `update`
actions. If the `redirects to the widget` example was missing from one or the
other, it would be easy to spot.

Take a look at the generated `spec/controllers/widgets_controller_spec.rb` to
get a sense of how to organize your specs to generate output like this.
