module Fog
  module Compute
    class Google
      class Mock
        def list_instance_group_instances(_group, _zone)
          Fog::Mock.not_implemented
        end
      end

      class Real
        def list_instance_group_instances(group_name, zone)
          api_method = @compute.instance_groups.list_instances
          parameters = {
            "instanceGroup" => group_name,
            "project" => @project,
            "zone" => zone
          }

          request(api_method, parameters)
        end
      end
    end
  end
end
