#!/bin/sh
# start hpsockd and webrick, inspired from ruby-mysql2
# It is in turn inspired by
# debian/test_mysql.sh from libdbi-drivers source package.
# It needs a socks proxy and an HTTP service to test.

set -e

CONFIG_FILE=debian/hpsockd.conf

mkdir debian/tmp

# Start webrick on 8082
/usr/bin/ruby -r webrick -e "s = WEBrick::HTTPServer.new(:Port => 8082, :DocumentRoot => Dir.pwd); trap('INT') { s.shutdown }; s.start" >debian/tmp/webrick.out 2>&1&
echo "Sleeping 5 seconds for WEBrick to start..."
sleep 5

# Start a hpsockd socks server
/usr/sbin/hpsockd -c ${CONFIG_FILE} 

dh_auto_install

# Stop webrick and hpsockd
killall -9 hpsockd
webrick_pid=`cat debian/tmp/webrick.out |grep pid| awk '{print $5}'|cut -d= -f2`
kill -9 ${webrick_pid}

# Cleanup
rm -rf debian/tmp
