# This is here to remove DataObject's dependency on Extlib.

module DataObjects
  # @param name<String> The name of the constant to get, e.g. "Merb::Router".
  #
  # @return <Object> The constant corresponding to the name.
  def self.full_const_get(name)
    list = name.split("::")
    list.shift if list.first.nil? || list.first.strip.empty?
    obj = ::Object
    list.each do |x|
      # This is required because const_get tries to look for constants in the
      # ancestor chain, but we only want constants that are HERE
      obj = obj.const_defined?(x) ? obj.const_get(x) : obj.const_missing(x)
    end
    obj
  end
end
