#include "RipOff.h"
#include "ripoff.xpm"


GtkWidget *about_window_draw_with_logo(         gchar *title,
                                                gchar *name,
                                                gchar *description,
                                                gchar *copyright,
                                                gchar *website)
{
        GtkWidget *about_dialog;
        GdkPixbuf *icon;
        GtkWidget *image;
        icon = gdk_pixbuf_new_from_xpm_data((const gchar **) ripoff_xpm);

        /*#if !defined(GTK_MINOR_VERSION) || GTK_MINOR_VERSION <= 6*/
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *button;
	gchar title_string[60] = "About ";

	strncat(title_string, title, 60);

	table = gtk_table_new(3, 7, FALSE);

        image = gtk_image_new_from_pixbuf(icon);

        gtk_table_attach(       GTK_TABLE(table),
                                image,
                                0, 3,
                                0, 1,
                                GTK_EXPAND,
                                GTK_SHRINK,
                                0, 3);

	label = gtk_label_new(NULL);

	gtk_label_set_markup(	GTK_LABEL(label), 
	g_markup_printf_escaped (	"<span weight=\"bold\" size=\"xx-large\">%s</span>", 
					name));

	gtk_table_attach(	GTK_TABLE(table),
				label,
				0, 3,
				1, 2,
				GTK_EXPAND,
				GTK_SHRINK,
				0, 3);

	label = gtk_label_new(description);

	gtk_table_attach(	GTK_TABLE(table),
				label,
				0, 3,
				2, 3,
				GTK_EXPAND,
				GTK_SHRINK,
				0, 3);

	label = gtk_label_new(copyright);

	gtk_table_attach(	GTK_TABLE(table),
				label,
				0, 3,
				3, 4,
				GTK_EXPAND,
				GTK_SHRINK,
				0, 3);

	label = gtk_label_new(website);

	gtk_table_attach(	GTK_TABLE(table),
				label,
				0, 3,
				4, 5,
				GTK_EXPAND,
				GTK_SHRINK,
				0, 3);

	button = gtk_button_new_from_stock(GTK_STOCK_CLOSE);

	gtk_table_attach(	GTK_TABLE(table),
				button,
				2, 3,
				6, 7,
				GTK_SHRINK,
				GTK_SHRINK,
				0, 0);

	about_dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(about_dialog), title_string);
	gtk_widget_set_size_request(about_dialog, 350, 190);
	gtk_window_set_type_hint(GTK_WINDOW(about_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_decorated(GTK_WINDOW(about_dialog), TRUE);
	gtk_window_set_skip_taskbar_hint(GTK_WINDOW(about_dialog), TRUE);
	gtk_container_add(GTK_CONTAINER(about_dialog), table);

	g_signal_connect_swapped(	G_OBJECT (button), 
					"clicked",
                              		G_CALLBACK (gtk_widget_destroy),
                              		G_OBJECT (about_dialog));
        /*#else
        about_dialog = about_window_draw(       title,
                                                name,
                                                description,
                                                copyright,
                                                website);

        gtk_about_dialog_set_logo(GTK_ABOUT_DIALOG(about_dialog), icon);
        #endif*/

        g_object_unref(icon);
        return about_dialog;
}
GtkWidget *about_window_draw(	gchar *title, 
				gchar *name, 
				gchar *description, 
				gchar *copyright, 
				gchar *website)
{
        GtkWidget *about_dialog;
        /*#if !defined(GTK_MINOR_VERSION) || GTK_MINOR_VERSION <= 6*/
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *button;
	gchar title_string[60] = "About ";

	strncat(title_string, title, 60);

	table = gtk_table_new(3, 6, FALSE);

	label = gtk_label_new(NULL);

	gtk_label_set_markup(	GTK_LABEL(label), 
	g_markup_printf_escaped (	"<span weight=\"bold\" size=\"xx-large\">%s</span>", 
					name));

	gtk_table_attach(	GTK_TABLE(table),
				label,
				0, 3,
				0, 1,
				GTK_EXPAND,
				GTK_SHRINK,
				0, 3);

	label = gtk_label_new(description);

	gtk_table_attach(	GTK_TABLE(table),
				label,
				0, 3,
				1, 2,
				GTK_EXPAND,
				GTK_SHRINK,
				0, 3);

	label = gtk_label_new(copyright);

	gtk_table_attach(	GTK_TABLE(table),
				label,
				0, 3,
				2, 3,
				GTK_EXPAND,
				GTK_SHRINK,
				0, 3);

	label = gtk_label_new(website);

	gtk_table_attach(	GTK_TABLE(table),
				label,
				0, 3,
				3, 4,
				GTK_EXPAND,
				GTK_SHRINK,
				0, 3);

	button = gtk_button_new_from_stock(GTK_STOCK_CLOSE);

	gtk_table_attach(	GTK_TABLE(table),
				button,
				2, 3,
				4, 5,
				GTK_SHRINK,
				GTK_SHRINK,
				0, 0);

	about_dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(about_dialog), title_string);
	gtk_widget_set_size_request(about_dialog, 350, 135);
	gtk_window_set_type_hint(GTK_WINDOW(about_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_decorated(GTK_WINDOW(about_dialog), TRUE);
	gtk_window_set_skip_taskbar_hint(GTK_WINDOW(about_dialog), TRUE);
	gtk_container_add(GTK_CONTAINER(about_dialog), table);

	g_signal_connect_swapped(	G_OBJECT (button), 
					"clicked",
                              		G_CALLBACK (gtk_widget_destroy),
                              		G_OBJECT (about_dialog));

        /* Commenting this out until gtk_about_dialog close button starts working 
         * correctly again
         */
        /*#else
        about_dialog = gtk_about_dialog_new();
	gtk_about_dialog_set_name(GTK_ABOUT_DIALOG(about_dialog), name);
	gtk_about_dialog_set_comments(GTK_ABOUT_DIALOG(about_dialog), description);
	gtk_about_dialog_set_copyright(GTK_ABOUT_DIALOG(about_dialog), copyright);
	gtk_about_dialog_set_website(	GTK_ABOUT_DIALOG(about_dialog), website);
        #endif*/

        return about_dialog;
}
