#! /bin/sh

# Test representation of a table with URLs

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

TMP_TEST_DB=samples.db
TMP_DB_FILE=${TMP_DB_DIR}/samples.db
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/${TMP_TEST_DB}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_FILE} <<'EOF'
create table origin (
  `id` integer AUTO_INCREMENT PRIMARY KEY,
  `uuid` char(36) NOT NULL UNIQUE,
  `location` varchar(255) DEFAULT NULL,
  `mine` varchar(255) DEFAULT NULL
); 

create table sample (
   id integer primary key autoincrement,
   uuid char(36) unique,
   SolsaID char(12) unique,
   origin_id integer foreighn key `origin_id` references origin(id),
   name text
);

create table experiment (
   id integer primary key autoincrement,
   uuid char(36) unique,
   sample_id integer foreighn key `sample_id` references sample(id),
   description text
);

create table experiment_value (
   id integer primary key autoincrement,
   uuid char(36) unique,
   experiment_id integer foreighn key references experiment(id),
   name varchar(12),
   value float,
   esu float
);

insert into origin (id,uuid,location,mine) values
   (1,"616953f0-55cf-11e8-9571-537b10974660","Vilnius","Bartonys IV"),
   (2,"61697984-55cf-11e8-aceb-a7c50ce67ca6","France","SODICAPEI")
;

insert into sample (id,uuid,SolsaID,origin_id,name) values
    (1,"3129df14-4ec4-11e8-950f-cfc135e92040","VU-TEST-0001",1,"Calcite"),
    (2,"45cb6e74-4ec4-11e8-ac0e-73a678ca22dc","VU-TEST-0002",2,"Stromatolite"),
    (3,"ff2c20f2-55ef-11e8-9862-87e6cd51f632","VU-TEST-0003",1,"Quartz")
;

insert into experiment (id,uuid,sample_id,description) values
    (1, "eec2c756-55f0-11e8-9807-ffa53e47f629", 1, "Experiment No. 1"),
    (2, "eec2eee8-55f0-11e8-94ab-8f2beb6aaa7e", 1, "Experiment No. 2"),
    (3, "eec3154e-55f0-11e8-ac9b-ab8062acb225", 1, "Experiment No. 3"),
    (4, "eec33c54-55f0-11e8-bcf8-070650ae85af", 1, "Experiment No. 4"),
    (5, "eec3636e-55f0-11e8-a286-8768d7b154ce", 1, "Experiment No. 5"),

    (10, "0ce6bc38-55f1-11e8-a837-6f53b3c0891e", 3, "Another Experiment No. 10"),
    (11, "0ce6e438-55f1-11e8-ba82-53e6287ead91", 3, "Another Experiment No. 11"),
    (12, "0ce70b3e-55f1-11e8-84cf-8bcd86d86a0c", 3, "Another Experiment No. 12"),
    (13, "0ce73104-55f1-11e8-ab1a-5fffc60ba6ec", 3, "Another Experiment No. 13")
;

insert into experiment_value (id,uuid,experiment_id,name,value,esu) values
    (1, "9c73d0ce-55f2-11e8-9af6-6fba9e63fa68", 1, "foo 1.1 value", 0.00415885, 0.0790546 ),
    (2, "9d0d420e-55f2-11e8-b9a7-0f2edbd1a5fe", 1, "foo 1.2 value", 0.556513, 0.0484741 ),
    (3, "9da6bd1c-55f2-11e8-9a3d-dfe2d176e50f", 1, "foo 1.3 value", 0.230949, 0.0498732 ),
    (4, "9e402ac4-55f2-11e8-823d-27f883a49b2f", 1, "foo 1.4 value", 0.0474068, 0.0360574 ),
    (5, "9ed99880-55f2-11e8-af27-7f9933eefbd6", 1, "foo 1.5 value", 0.298852, 0.0549002 ),
    (6, "9f7379c8-55f2-11e8-ae9b-fb55491a867c", 2, "foo 2.1 value", 0.135695, 0.0466264 ),
    (7, "a00ce234-55f2-11e8-89d8-cb6e404c3648", 2, "foo 2.2 value", 0.573511, 0.0681715 ),
    (8, "a0a64cb2-55f2-11e8-b693-9bd66d13752f", 2, "foo 2.3 value", 0.53908, 0.0597442 ),
    (9, "a13fbb36-55f2-11e8-9070-4b0860063275", 2, "foo 2.4 value", 0.263723, 0.0114714 ),
    (10, "a1d99d46-55f2-11e8-a6dc-9fa50a118e3d", 3, "foo 3.1 value", 0.778412, 0.0933552 ),
    (11, "a2730c60-55f2-11e8-a55c-5be053f8e541", 3, "foo 3.2 value", 0.0995359, 0.0544846 ),
    (12, "a30c7ecc-55f2-11e8-8b93-ab689069872c", 3, "foo 3.3 value", 0.246931, 0.0358809 ),
    (13, "a3a5f412-55f2-11e8-9c5a-2b80e2dc53bd", 3, "foo 3.4 value", 0.0804544, 0.0810238 ),
    (14, "a43f6a98-55f2-11e8-b49d-dfc0e4eb1095", 3, "foo 3.5 value", 0.151988, 0.0656596 ),
    (15, "a4d8df8e-55f2-11e8-947f-430a4d80bc1c", 3, "foo 3.6 value", 0.661222, 0.0770385 ),
    (16, "a572c11c-55f2-11e8-8b4c-4f42b3a52546", 4, "foo 4.1 value", 0.832957, 0.0819109 ),
    (17, "a60c34fa-55f2-11e8-a805-bb010045ae27", 4, "foo 4.2 value", 0.813956, 0.0690714 ),
    (18, "a6a59fb4-55f2-11e8-be0b-fb59a22c9336", 4, "foo 4.3 value", 0.711655, 0.0163423 ),
    (19, "a73f13d8-55f2-11e8-9553-23691cbce53c", 4, "foo 4.4 value", 0.23027, 0.00101103 ),
    (20, "a7d8850e-55f2-11e8-88a7-0b2c58f6aabd", 4, "foo 4.5 value", 0.313562, 0.0178622 ),
    (21, "a871f8e2-55f2-11e8-bb96-f377705abfe6", 4, "foo 4.6 value", 0.124227, 0.0950114 ),
    (22, "a90b68a6-55f2-11e8-b61f-2f621e95b63e", 4, "foo 4.7 value", 0.848971, 0.0193136 ),
    (23, "a9a54d68-55f2-11e8-aaa3-7756b1d110d4", 5, "foo 5.1 value", 0.926345, 0.0101242 ),
    (24, "aa3ebaca-55f2-11e8-9484-07bf19e79e1e", 5, "foo 5.2 value", 0.856758, 0.0718409 ),
    (25, "aad82f34-55f2-11e8-ad34-572b3d82a4fe", 5, "foo 5.3 value", 0.920327, 0.0609964 ),
    (26, "ab71aaba-55f2-11e8-8771-6bca1c46a988", 5, "foo 5.4 value", 0.186154, 0.0583725 ),
    (27, "ac0b2974-55f2-11e8-9278-4bbf82f66263", 5, "foo 5.5 value", 0.744226, 0.0724591 ),
    (28, "aca4a298-55f2-11e8-8923-0743980f085e", 5, "foo 5.6 value", 0.769037, 0.0207862 ),
    (29, "ad3e0c1c-55f2-11e8-936e-bf86d38ade4e", 5, "foo 5.7 value", 0.889156, 0.0514508 ),
    (30, "add7e918-55f2-11e8-a974-6fa79c533c4d", 10, "foo 10.1 value", 0.0866512, 0.0525014 ),
    (31, "ae7156de-55f2-11e8-81ee-abf09743cb83", 10, "foo 10.2 value", 0.793023, 0.0256708 ),
    (32, "af0ad21e-55f2-11e8-b6af-631052cfd0e6", 10, "foo 10.3 value", 0.373107, 0.0534583 ),
    (33, "afa43ea4-55f2-11e8-916c-7fe8dfbc1a46", 10, "foo 10.4 value", 0.747869, 0.0401495 ),
    (34, "b03db854-55f2-11e8-80ce-db5b6164e7c0", 10, "foo 10.5 value", 0.356275, 0.0319596 ),
    (35, "b0d72f7a-55f2-11e8-9fc7-77f6bd3b10c6", 10, "foo 10.6 value", 0.260063, 0.0555904 ),
    (36, "b170a060-55f2-11e8-99e8-ff33f10ce402", 10, "foo 10.7 value", 0.923432, 0.0213991 ),
    (37, "b20a1d58-55f2-11e8-97c0-2783d09c8937", 10, "foo 10.8 value", 0.0840242, 0.0721726 ),
    (38, "b2a3fd74-55f2-11e8-8bc0-6ff40b7f1c84", 11, "foo 11.1 value", 0.599801, 0.0933334 ),
    (39, "b33d60cc-55f2-11e8-9f0f-e3dcd296275f", 11, "foo 11.2 value", 0.638234, 0.0783517 ),
    (40, "b3d6c8b6-55f2-11e8-9afc-0be420d59ac6", 11, "foo 11.3 value", 0.823698, 0.0223927 ),
    (41, "b470338e-55f2-11e8-9f8e-e3e5b5f13b7c", 11, "foo 11.4 value", 0.285347, 0.0257925 ),
    (42, "b5099506-55f2-11e8-93c3-5b7bc08e615e", 11, "foo 11.5 value", 0.417398, 0.0980469 ),
    (43, "b5a302a4-55f2-11e8-a894-ab63c84c7774", 11, "foo 11.6 value", 0.256488, 0.00194725 ),
    (44, "b63c69d0-55f2-11e8-b267-3fb63bc8b062", 11, "foo 11.7 value", 0.224395, 0.0680556 ),
    (45, "b6d63452-55f2-11e8-88f2-07b10d850f7b", 12, "foo 12.1 value", 0.707804, 0.0781116 ),
    (46, "b76f9854-55f2-11e8-8966-db99175f7e6c", 12, "foo 12.2 value", 0.58914, 0.00406156 ),
    (47, "b808fd5a-55f2-11e8-acd8-6f1e1ff68420", 12, "foo 12.3 value", 0.323878, 0.0843986 ),
    (48, "b8a2cf52-55f2-11e8-bb5e-7fb8547efd8e", 13, "foo 13.1 value", 0.194214, 0.0913838 ),
    (49, "b93c31a6-55f2-11e8-867d-03bc996d8f28", 13, "foo 13.2 value", 0.193264, 0.033207 ),
    (50, "b9d5a714-55f2-11e8-838e-732dd4e31e6d", 13, "foo 13.3 value", 0.697833, 0.0550893 )
;

EOF

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} <<EOF
insert into description 
    (id,dbname, dbtable, dbcolumn, coltype, fk_target, relation, visualisation)
values
    (1,"${TMP_DB_FILE_ABS}", "sample", "id", "id", NULL, NULL, NULL),
    (2,"${TMP_DB_FILE_ABS}", "origin", "id", "id", NULL, NULL, NULL),
    (3,"${TMP_DB_FILE_ABS}", "experiment", "id", "id", NULL, NULL, NULL),
    (4,"${TMP_DB_FILE_ABS}", "experiment_value", "id", "id", NULL, NULL, NULL),

    (10,"${TMP_DB_FILE_ABS}", "sample", "origin_id", "fk",     2,    "1", "card"),
    (11,"${TMP_DB_FILE_ABS}", "sample", "SolsaID",   "extkey", NULL, NULL, NULL),

    (12,"${TMP_DB_FILE_ABS}", "experiment", "sample_id", "fk", 1, "N", "card"),
    (13,"${TMP_DB_FILE_ABS}", "experiment_value", "experiment_id", "fk", 3, "N", NULL)
;
EOF

export REQUEST_URI='/~saulius/restful/website/samples.db/sample/3?order=experiment_value.value%3Ad&engine=SQLite'
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=get
export QUERY_STRING=""
export REMOTE_USER=tester

${INPUT_SCRIPT} order=experiment_value.value%3Ad engine=SQLite

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
