#! /bin/sh

# Test upload of a CSV file.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g')

DB_DIR=db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}.db

sqlite3 ${TMP_DB_FILE} < tests/inputs/samples-r92.sql

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}.db/epma_content"
export HTTP_HOST=restfuldb.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=------------------------b989696a28305e74"
export REMOTE_USER=writer

echo "==="

perl -lne 'print "$_\r"' <<EOF |
--------------------------b989696a28305e74
Content-Disposition: form-data; name="jsonfile"; filename="fill.csv"
Content-Type: text/plain

{
   "data" : [
      {
         "attributes" : {
            "component" : "CuSO4",
            "value" : 0.01,
            "su" : 0.0001,
            "uuid" : "aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa"
         },
         "type" : "epma_content"
      }
   ]
}

--------------------------b989696a28305e74--
EOF
${INPUT_SCRIPT} \
    | perl -lpe 's/(&#39;)\S+(tmp\S+\.db)&#39;/$1$2$1/'

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from epma_content order by id';

rm -f ${TMP_DB_FILE}
