use strict;
use warnings;

use RT::Test tests => undef;

my $template = RT::Template->new( RT->SystemUser );
my ($ok, $msg) = $template->Create(
    Queue   => 0,
    Name    => 'test',
    Type    => 'Simple',
    Content => <<'.',
===Create-Ticket: testing
Queue: General
Subject: duplicate: { $Tickets{TOP}->Subject }
.
);
ok $ok, $msg;

my $ticket = RT::Test->create_ticket(
    Queue   => 'General',
    Subject => 'a ticket',
);
ok $ticket->id, "created ticket";

for my $type (qw(Simple Perl)) {
    if ($template->Type ne $type) {
        my ($ok, $msg) = $template->SetType($type);
        ok $ok, $msg;
    }

    require RT::Action::CreateTickets;
    my $action = RT::Action::CreateTickets->new(
        CurrentUser     => RT->SystemUser,
        TemplateObj     => $template,
        TicketObj       => $ticket,
    );
    $action->{TransactionObj} = $ticket->Transactions->First;
    ok $action->Prepare, 'prepares';
    ok $action->Commit, 'commits';

    my $new_ticket = RT::Test->last_ticket;
    ok $new_ticket->id > $ticket->id, 'new ticket';

    if ($type eq 'Perl') {
        is $new_ticket->Subject, 'duplicate: a ticket', 'interpolated';
        isnt $new_ticket->Subject, 'duplicate: { $Tickets{TOP}->Subject }', 'interpolated';
    } else {
        isnt $new_ticket->Subject, 'duplicate: a ticket', 'not interpolated';
        is $new_ticket->Subject, 'duplicate: { $Tickets{TOP}->Subject }', 'not interpolated';
    }
}

done_testing;
