use strict;
use warnings;

use RT::Test tests => undef;
plan skip_all => 'GraphViz required.'
    unless eval { require GraphViz; 1 };

my ($base, $m) = RT::Test->started_ok;
$m->login;

for my $arg (qw(LeadingLink ShowLinks)) {
    my $ticket = RT::Test->create_ticket(
        Queue   => 'General',
        Subject => 'testing',
    );
    ok $ticket->id, 'created ticket';

    ok !$ticket->ToldObj->Unix, 'no Told';
    $m->get_ok("$base/Ticket/Graphs/index.html?$arg=SetTold;id=" . $ticket->id);

    $ticket->Load($ticket->id); # cache busting

    ok !$ticket->ToldObj->Unix, 'still no Told';
    $m->content_lacks('GotoFirstItem', 'no GotoFirstItem error');
    $m->content_like(qr|<img[^>]+?src=['"]/Ticket/Graphs/@{[$ticket->id]}|, 'found image element');
}

undef $m;
done_testing;
