// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from StorageManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.webcam {
  public class StorageManager_1_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("webcam.StorageManager:1.0.1", null);

    public StorageManager_1_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public StorageManager_1_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new StorageManager_1_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new StorageManager_1_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int NO_ERROR = 0;

    public const int ERR_INVALID_PARAM = 1;

    public const int ERR_INIT_IN_PROGRESS = 2;

    public const int ERR_ALREADY_RUNNING = 3;

    public const int ERR_TOO_LARGE = 4;

    public enum StorageType {
      LOCAL,
      FTP,
      CIFS,
      NFS,
    }

    public enum Direction {
      ASCENDING,
      DESCENDING,
    }

    public enum StorageStatus {
      INITIALIZING,
      READY,
    }

    public class WebcamStorageInfo : ICloneable {
      public object Clone() {
        WebcamStorageInfo copy = new WebcamStorageInfo();
        copy.webcam = this.webcam;
        copy.newestIndex = this.newestIndex;
        copy.oldestIndex = this.oldestIndex;
        copy.count = this.count;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["webcam"] = this.webcam != null ? this.webcam.Encode() : JsonValue.Null;
        json["newestIndex"] = this.newestIndex;
        json["oldestIndex"] = this.oldestIndex;
        json["count"] = this.count;
        return json;
      }

      public static WebcamStorageInfo Decode(LightJson.JsonObject json, Agent agent) {
        WebcamStorageInfo inst = new WebcamStorageInfo();
        inst.webcam = Com.Raritan.Idl.webcam.Webcam_2_0_0.StaticCast(ObjectProxy.Decode(json["webcam"], agent));
        inst.newestIndex = (long)json["newestIndex"];
        inst.oldestIndex = (long)json["oldestIndex"];
        inst.count = (int)json["count"];
        return inst;
      }

      public Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam = null;
      public long newestIndex = 0;
      public long oldestIndex = 0;
      public int count = 0;
    }

    public class StorageInformation : ICloneable {
      public object Clone() {
        StorageInformation copy = new StorageInformation();
        copy.status = this.status;
        copy.capacity = this.capacity;
        copy.used = this.used;
        copy.webcamStorageInfo = this.webcamStorageInfo;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["status"] = (int)this.status;
        json["capacity"] = this.capacity;
        json["used"] = this.used;
        json["webcamStorageInfo"] = new JsonArray(this.webcamStorageInfo.Select(
          _value => (JsonValue)(_value.Encode())));
        return json;
      }

      public static StorageInformation Decode(LightJson.JsonObject json, Agent agent) {
        StorageInformation inst = new StorageInformation();
        inst.status = (Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageStatus)(int)json["status"];
        inst.capacity = (int)json["capacity"];
        inst.used = (int)json["used"];
        inst.webcamStorageInfo = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.StorageManager_1_0_1.WebcamStorageInfo>(json["webcamStorageInfo"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.webcam.StorageManager_1_0_1.WebcamStorageInfo.Decode(_value, agent)));
        return inst;
      }

      public Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageStatus status = Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageStatus.INITIALIZING;
      public int capacity = 0;
      public int used = 0;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.webcam.StorageManager_1_0_1.WebcamStorageInfo> webcamStorageInfo = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.StorageManager_1_0_1.WebcamStorageInfo>();
    }

    public class StorageSettings : ICloneable {
      public object Clone() {
        StorageSettings copy = new StorageSettings();
        copy.type = this.type;
        copy.capacity = this.capacity;
        copy.server = this.server;
        copy.username = this.username;
        copy.password = this.password;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["type"] = (int)this.type;
        json["capacity"] = this.capacity;
        json["server"] = this.server;
        json["username"] = this.username;
        json["password"] = this.password;
        return json;
      }

      public static StorageSettings Decode(LightJson.JsonObject json, Agent agent) {
        StorageSettings inst = new StorageSettings();
        inst.type = (Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageType)(int)json["type"];
        inst.capacity = (int)json["capacity"];
        inst.server = (string)json["server"];
        inst.username = (string)json["username"];
        inst.password = (string)json["password"];
        return inst;
      }

      public Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageType type = Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageType.LOCAL;
      public int capacity = 0;
      public string server = "";
      public string username = "";
      public string password = "";
    }

    public class StorageMetaData : ICloneable {
      public object Clone() {
        StorageMetaData copy = new StorageMetaData();
        copy.index = this.index;
        copy.webcam = this.webcam;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["index"] = this.index;
        json["webcam"] = this.webcam != null ? this.webcam.Encode() : JsonValue.Null;
        return json;
      }

      public static StorageMetaData Decode(LightJson.JsonObject json, Agent agent) {
        StorageMetaData inst = new StorageMetaData();
        inst.index = (long)json["index"];
        inst.webcam = Com.Raritan.Idl.webcam.Webcam_2_0_0.StaticCast(ObjectProxy.Decode(json["webcam"], agent));
        return inst;
      }

      public long index = 0;
      public Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam = null;
    }

    public class ImageStorageMetaData : ICloneable {
      public object Clone() {
        ImageStorageMetaData copy = new ImageStorageMetaData();
        copy.imageMeta = this.imageMeta;
        copy.fileSize = this.fileSize;
        copy.storageMeta = this.storageMeta;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["imageMeta"] = this.imageMeta.Encode();
        json["fileSize"] = this.fileSize;
        json["storageMeta"] = this.storageMeta.Encode();
        return json;
      }

      public static ImageStorageMetaData Decode(LightJson.JsonObject json, Agent agent) {
        ImageStorageMetaData inst = new ImageStorageMetaData();
        inst.imageMeta = Com.Raritan.Idl.webcam.ImageMetaData.Decode(json["imageMeta"], agent);
        inst.fileSize = (int)json["fileSize"];
        inst.storageMeta = Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageMetaData.Decode(json["storageMeta"], agent);
        return inst;
      }

      public Com.Raritan.Idl.webcam.ImageMetaData imageMeta = new Com.Raritan.Idl.webcam.ImageMetaData();
      public int fileSize = 0;
      public Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageMetaData storageMeta = new Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageMetaData();
    }

    public class StorageImage : ICloneable {
      public object Clone() {
        StorageImage copy = new StorageImage();
        copy.image = this.image;
        copy.metaData = this.metaData;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["image"] = this.image.Encode();
        json["metaData"] = this.metaData.Encode();
        return json;
      }

      public static StorageImage Decode(LightJson.JsonObject json, Agent agent) {
        StorageImage inst = new StorageImage();
        inst.image = Com.Raritan.Idl.webcam.Image_2_0_0.Decode(json["image"], agent);
        inst.metaData = Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageMetaData.Decode(json["metaData"], agent);
        return inst;
      }

      public Com.Raritan.Idl.webcam.Image_2_0_0 image = new Com.Raritan.Idl.webcam.Image_2_0_0();
      public Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageMetaData metaData = new Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageMetaData();
    }

    public class Activity : ICloneable {
      public object Clone() {
        Activity copy = new Activity();
        copy.webcam = this.webcam;
        copy.interval = this.interval;
        copy.count = this.count;
        copy.done = this.done;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["webcam"] = this.webcam != null ? this.webcam.Encode() : JsonValue.Null;
        json["interval"] = this.interval;
        json["count"] = this.count;
        json["done"] = this.done;
        return json;
      }

      public static Activity Decode(LightJson.JsonObject json, Agent agent) {
        Activity inst = new Activity();
        inst.webcam = Com.Raritan.Idl.webcam.Webcam_2_0_0.StaticCast(ObjectProxy.Decode(json["webcam"], agent));
        inst.interval = (int)json["interval"];
        inst.count = (int)json["count"];
        inst.done = (int)json["done"];
        return inst;
      }

      public Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam = null;
      public int interval = 0;
      public int count = 0;
      public int done = 0;
    }

    public class GetSupportedStorageTypesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageType> _ret_;
    }

    public GetSupportedStorageTypesResult getSupportedStorageTypes() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSupportedStorageTypes", _parameters);
      var _ret = new GetSupportedStorageTypesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageType>(_result["_ret_"].AsJsonArray.Select(
        _value => (Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageType)(int)_value));
      return _ret;
    }

    public AsyncRequest getSupportedStorageTypes(AsyncRpcResponse<GetSupportedStorageTypesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSupportedStorageTypes(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSupportedStorageTypes(AsyncRpcResponse<GetSupportedStorageTypesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSupportedStorageTypes", _parameters,
        _result => {
          try {
            var _ret = new GetSupportedStorageTypesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageType>(_result["_ret_"].AsJsonArray.Select(
              _value => (Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageType)(int)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetInformationResult {
      public Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageInformation _ret_;
    }

    public GetInformationResult getInformation() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInformation", _parameters);
      var _ret = new GetInformationResult();
      _ret._ret_ = Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageInformation.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInformation(AsyncRpcResponse<GetInformationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInformation(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInformation(AsyncRpcResponse<GetInformationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInformation", _parameters,
        _result => {
          try {
            var _ret = new GetInformationResult();
            _ret._ret_ = Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageInformation.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageSettings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageSettings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageSettings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageSettings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageSettings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class AddImageResult {
      public int _ret_;
      public long index;
    }

    public AddImageResult addImage(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, Com.Raritan.Idl.webcam.Image_2_0_0 image) {
      var _parameters = new LightJson.JsonObject();
      _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;
      _parameters["image"] = image.Encode();

      var _result = RpcCall("addImage", _parameters);
      var _ret = new AddImageResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.index = (long)_result["index"];
      return _ret;
    }

    public AsyncRequest addImage(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, Com.Raritan.Idl.webcam.Image_2_0_0 image, AsyncRpcResponse<AddImageResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addImage(webcam, image, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addImage(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, Com.Raritan.Idl.webcam.Image_2_0_0 image, AsyncRpcResponse<AddImageResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;
        _parameters["image"] = image.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addImage", _parameters,
        _result => {
          try {
            var _ret = new AddImageResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.index = (long)_result["index"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class RemoveImagesResult {
      public int _ret_;
    }

    public RemoveImagesResult removeImages(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, long start, int count, Com.Raritan.Idl.webcam.StorageManager_1_0_1.Direction direction) {
      var _parameters = new LightJson.JsonObject();
      _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;
      _parameters["start"] = start;
      _parameters["count"] = count;
      _parameters["direction"] = (int)direction;

      var _result = RpcCall("removeImages", _parameters);
      var _ret = new RemoveImagesResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest removeImages(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, long start, int count, Com.Raritan.Idl.webcam.StorageManager_1_0_1.Direction direction, AsyncRpcResponse<RemoveImagesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return removeImages(webcam, start, count, direction, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest removeImages(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, long start, int count, Com.Raritan.Idl.webcam.StorageManager_1_0_1.Direction direction, AsyncRpcResponse<RemoveImagesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;
        _parameters["start"] = start;
        _parameters["count"] = count;
        _parameters["direction"] = (int)direction;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("removeImages", _parameters,
        _result => {
          try {
            var _ret = new RemoveImagesResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetMetaDataResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.webcam.StorageManager_1_0_1.ImageStorageMetaData> meta;
    }

    public GetMetaDataResult getMetaData(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, long start, int count, Com.Raritan.Idl.webcam.StorageManager_1_0_1.Direction direction) {
      var _parameters = new LightJson.JsonObject();
      _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;
      _parameters["start"] = start;
      _parameters["count"] = count;
      _parameters["direction"] = (int)direction;

      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.meta = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.StorageManager_1_0_1.ImageStorageMetaData>(_result["meta"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.webcam.StorageManager_1_0_1.ImageStorageMetaData.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getMetaData(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, long start, int count, Com.Raritan.Idl.webcam.StorageManager_1_0_1.Direction direction, AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(webcam, start, count, direction, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, long start, int count, Com.Raritan.Idl.webcam.StorageManager_1_0_1.Direction direction, AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;
        _parameters["start"] = start;
        _parameters["count"] = count;
        _parameters["direction"] = (int)direction;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.meta = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.StorageManager_1_0_1.ImageStorageMetaData>(_result["meta"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.webcam.StorageManager_1_0_1.ImageStorageMetaData.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetImagesResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageImage> image;
    }

    public GetImagesResult getImages(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, long start, int count, Com.Raritan.Idl.webcam.StorageManager_1_0_1.Direction direction) {
      var _parameters = new LightJson.JsonObject();
      _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;
      _parameters["start"] = start;
      _parameters["count"] = count;
      _parameters["direction"] = (int)direction;

      var _result = RpcCall("getImages", _parameters);
      var _ret = new GetImagesResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.image = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageImage>(_result["image"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageImage.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getImages(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, long start, int count, Com.Raritan.Idl.webcam.StorageManager_1_0_1.Direction direction, AsyncRpcResponse<GetImagesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getImages(webcam, start, count, direction, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getImages(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, long start, int count, Com.Raritan.Idl.webcam.StorageManager_1_0_1.Direction direction, AsyncRpcResponse<GetImagesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;
        _parameters["start"] = start;
        _parameters["count"] = count;
        _parameters["direction"] = (int)direction;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getImages", _parameters,
        _result => {
          try {
            var _ret = new GetImagesResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.image = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageImage>(_result["image"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.webcam.StorageManager_1_0_1.StorageImage.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetActivitiesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.webcam.StorageManager_1_0_1.Activity> _ret_;
    }

    public GetActivitiesResult getActivities() {
      JsonObject _parameters = null;
      var _result = RpcCall("getActivities", _parameters);
      var _ret = new GetActivitiesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.StorageManager_1_0_1.Activity>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.webcam.StorageManager_1_0_1.Activity.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getActivities(AsyncRpcResponse<GetActivitiesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getActivities(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getActivities(AsyncRpcResponse<GetActivitiesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getActivities", _parameters,
        _result => {
          try {
            var _ret = new GetActivitiesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.StorageManager_1_0_1.Activity>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.webcam.StorageManager_1_0_1.Activity.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class StartActivityResult {
      public int _ret_;
    }

    public StartActivityResult startActivity(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, int count, int interval) {
      var _parameters = new LightJson.JsonObject();
      _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;
      _parameters["count"] = count;
      _parameters["interval"] = interval;

      var _result = RpcCall("startActivity", _parameters);
      var _ret = new StartActivityResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest startActivity(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, int count, int interval, AsyncRpcResponse<StartActivityResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return startActivity(webcam, count, interval, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest startActivity(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, int count, int interval, AsyncRpcResponse<StartActivityResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;
        _parameters["count"] = count;
        _parameters["interval"] = interval;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("startActivity", _parameters,
        _result => {
          try {
            var _ret = new StartActivityResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class StopActivityResult {
      public int _ret_;
    }

    public StopActivityResult stopActivity(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam) {
      var _parameters = new LightJson.JsonObject();
      _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;

      var _result = RpcCall("stopActivity", _parameters);
      var _ret = new StopActivityResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest stopActivity(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, AsyncRpcResponse<StopActivityResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return stopActivity(webcam, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest stopActivity(Com.Raritan.Idl.webcam.Webcam_2_0_0 webcam, AsyncRpcResponse<StopActivityResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["webcam"] = webcam != null ? webcam.Encode() : JsonValue.Null;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("stopActivity", _parameters,
        _result => {
          try {
            var _ret = new StopActivityResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
