// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Unit.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class Unit_1_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Unit:1.0.1", null);

    public Unit_1_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Unit_1_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Unit_1_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Unit_1_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_PARAM = 1;

    public enum Orientation {
      NORMAL,
      FLIPPED,
      LEFT,
      RIGHT,
    }

    public class DisplayOptions : ICloneable {
      public object Clone() {
        DisplayOptions copy = new DisplayOptions();
        copy.key = this.key;
        copy.value = this.value;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["key"] = this.key;
        json["value"] = this.value;
        return json;
      }

      public static DisplayOptions Decode(LightJson.JsonObject json, Agent agent) {
        DisplayOptions inst = new DisplayOptions();
        inst.key = (string)json["key"];
        inst.value = (string)json["value"];
        return inst;
      }

      public string key = "";
      public string value = "";
    }

    public class DisplayInfo : ICloneable {
      public object Clone() {
        DisplayInfo copy = new DisplayInfo();
        copy.type = this.type;
        copy.address = this.address;
        copy.options = this.options;
        copy.orientation = this.orientation;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["type"] = this.type;
        json["address"] = this.address;
        json["options"] = new JsonArray(this.options.Select(
          _value => (JsonValue)(_value.Encode())));
        json["orientation"] = (int)this.orientation;
        return json;
      }

      public static DisplayInfo Decode(LightJson.JsonObject json, Agent agent) {
        DisplayInfo inst = new DisplayInfo();
        inst.type = (string)json["type"];
        inst.address = (string)json["address"];
        inst.options = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Unit_1_0_1.DisplayOptions>(json["options"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.pdumodel.Unit_1_0_1.DisplayOptions.Decode(_value, agent)));
        inst.orientation = (Com.Raritan.Idl.pdumodel.Unit_1_0_1.Orientation)(int)json["orientation"];
        return inst;
      }

      public string type = "";
      public string address = "";
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Unit_1_0_1.DisplayOptions> options = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Unit_1_0_1.DisplayOptions>();
      public Com.Raritan.Idl.pdumodel.Unit_1_0_1.Orientation orientation = Com.Raritan.Idl.pdumodel.Unit_1_0_1.Orientation.NORMAL;
    }

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.hasOrientationSensor = this.hasOrientationSensor;
        copy.supportedDisplayOrientations = this.supportedDisplayOrientations;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["hasOrientationSensor"] = this.hasOrientationSensor;
        json["supportedDisplayOrientations"] = new JsonArray(this.supportedDisplayOrientations.Select(
          _value => (JsonValue)((int)_value)));
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.hasOrientationSensor = (bool)json["hasOrientationSensor"];
        inst.supportedDisplayOrientations = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Unit_1_0_1.Orientation>(json["supportedDisplayOrientations"].AsJsonArray.Select(
          _value => (Com.Raritan.Idl.pdumodel.Unit_1_0_1.Orientation)(int)_value));
        return inst;
      }

      public bool hasOrientationSensor = false;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Unit_1_0_1.Orientation> supportedDisplayOrientations = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Unit_1_0_1.Orientation>();
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.buzzerMuted = this.buzzerMuted;
        copy.autoDisplayOrientation = this.autoDisplayOrientation;
        copy.displayOrientation = this.displayOrientation;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["buzzerMuted"] = this.buzzerMuted;
        json["autoDisplayOrientation"] = this.autoDisplayOrientation;
        json["displayOrientation"] = (int)this.displayOrientation;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.buzzerMuted = (bool)json["buzzerMuted"];
        inst.autoDisplayOrientation = (bool)json["autoDisplayOrientation"];
        inst.displayOrientation = (Com.Raritan.Idl.pdumodel.Unit_1_0_1.Orientation)(int)json["displayOrientation"];
        return inst;
      }

      public bool buzzerMuted = false;
      public bool autoDisplayOrientation = false;
      public Com.Raritan.Idl.pdumodel.Unit_1_0_1.Orientation displayOrientation = Com.Raritan.Idl.pdumodel.Unit_1_0_1.Orientation.NORMAL;
    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.pdumodel.Unit_1_0_1.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Unit_1_0_1.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Unit_1_0_1.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.pdumodel.Unit_1_0_1.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Unit_1_0_1.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Unit_1_0_1.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.pdumodel.Unit_1_0_1.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.pdumodel.Unit_1_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.pdumodel.Unit_1_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class IdentifyResult {
    }

    public IdentifyResult identify(int seconds) {
      var _parameters = new LightJson.JsonObject();
      _parameters["seconds"] = seconds;

      var _result = RpcCall("identify", _parameters);
      var _ret = new IdentifyResult();
      return _ret;
    }

    public AsyncRequest identify(int seconds, AsyncRpcResponse<IdentifyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return identify(seconds, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest identify(int seconds, AsyncRpcResponse<IdentifyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["seconds"] = seconds;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("identify", _parameters,
        _result => {
          try {
            var _ret = new IdentifyResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class MuteBuzzerResult {
    }

    public MuteBuzzerResult muteBuzzer(bool mute) {
      var _parameters = new LightJson.JsonObject();
      _parameters["mute"] = mute;

      var _result = RpcCall("muteBuzzer", _parameters);
      var _ret = new MuteBuzzerResult();
      return _ret;
    }

    public AsyncRequest muteBuzzer(bool mute, AsyncRpcResponse<MuteBuzzerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return muteBuzzer(mute, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest muteBuzzer(bool mute, AsyncRpcResponse<MuteBuzzerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["mute"] = mute;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("muteBuzzer", _parameters,
        _result => {
          try {
            var _ret = new MuteBuzzerResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TestBuzzerResult {
    }

    public TestBuzzerResult testBuzzer(bool on) {
      var _parameters = new LightJson.JsonObject();
      _parameters["on"] = on;

      var _result = RpcCall("testBuzzer", _parameters);
      var _ret = new TestBuzzerResult();
      return _ret;
    }

    public AsyncRequest testBuzzer(bool on, AsyncRpcResponse<TestBuzzerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return testBuzzer(on, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest testBuzzer(bool on, AsyncRpcResponse<TestBuzzerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["on"] = on;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("testBuzzer", _parameters,
        _result => {
          try {
            var _ret = new TestBuzzerResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetAllButtonStatesResult {
      public System.Collections.Generic.IEnumerable<bool> _ret_;
    }

    public GetAllButtonStatesResult getAllButtonStates() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAllButtonStates", _parameters);
      var _ret = new GetAllButtonStatesResult();
      _ret._ret_ = new System.Collections.Generic.List<bool>(_result["_ret_"].AsJsonArray.Select(
        _value => (bool)_value));
      return _ret;
    }

    public AsyncRequest getAllButtonStates(AsyncRpcResponse<GetAllButtonStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAllButtonStates(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAllButtonStates(AsyncRpcResponse<GetAllButtonStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAllButtonStates", _parameters,
        _result => {
          try {
            var _ret = new GetAllButtonStatesResult();
            _ret._ret_ = new System.Collections.Generic.List<bool>(_result["_ret_"].AsJsonArray.Select(
              _value => (bool)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TestButtonStateResult {
      public bool _ret_;
    }

    public TestButtonStateResult testButtonState(int button) {
      var _parameters = new LightJson.JsonObject();
      _parameters["button"] = button;

      var _result = RpcCall("testButtonState", _parameters);
      var _ret = new TestButtonStateResult();
      _ret._ret_ = (bool)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest testButtonState(int button, AsyncRpcResponse<TestButtonStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return testButtonState(button, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest testButtonState(int button, AsyncRpcResponse<TestButtonStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["button"] = button;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("testButtonState", _parameters,
        _result => {
          try {
            var _ret = new TestButtonStateResult();
            _ret._ret_ = (bool)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TestLEDSequenceResult {
    }

    public TestLEDSequenceResult testLEDSequence() {
      JsonObject _parameters = null;
      var _result = RpcCall("testLEDSequence", _parameters);
      var _ret = new TestLEDSequenceResult();
      return _ret;
    }

    public AsyncRequest testLEDSequence(AsyncRpcResponse<TestLEDSequenceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return testLEDSequence(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest testLEDSequence(AsyncRpcResponse<TestLEDSequenceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("testLEDSequence", _parameters,
        _result => {
          try {
            var _ret = new TestLEDSequenceResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class RunDisplayTestResult {
    }

    public RunDisplayTestResult runDisplayTest(int cycleTimeMs) {
      var _parameters = new LightJson.JsonObject();
      _parameters["cycleTimeMs"] = cycleTimeMs;

      var _result = RpcCall("runDisplayTest", _parameters);
      var _ret = new RunDisplayTestResult();
      return _ret;
    }

    public AsyncRequest runDisplayTest(int cycleTimeMs, AsyncRpcResponse<RunDisplayTestResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return runDisplayTest(cycleTimeMs, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest runDisplayTest(int cycleTimeMs, AsyncRpcResponse<RunDisplayTestResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["cycleTimeMs"] = cycleTimeMs;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("runDisplayTest", _parameters,
        _result => {
          try {
            var _ret = new RunDisplayTestResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDisplayInfoResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Unit_1_0_1.DisplayInfo> _ret_;
    }

    public GetDisplayInfoResult getDisplayInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDisplayInfo", _parameters);
      var _ret = new GetDisplayInfoResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Unit_1_0_1.DisplayInfo>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.pdumodel.Unit_1_0_1.DisplayInfo.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getDisplayInfo(AsyncRpcResponse<GetDisplayInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDisplayInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDisplayInfo(AsyncRpcResponse<GetDisplayInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDisplayInfo", _parameters,
        _result => {
          try {
            var _ret = new GetDisplayInfoResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Unit_1_0_1.DisplayInfo>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.pdumodel.Unit_1_0_1.DisplayInfo.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
