/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/


static char sccsid[] =
"$Id: pass.c,v 1.2 1999/06/23 23:40:40 cdr Exp $ Copyright 1992-1999 Lucent Technologies Inc";

#include	<sys/types.h>

#include	<stdio.h>
#include	<pwd.h>
#include	<ctype.h>
#include	<errno.h>
#include	<syslog.h>
#include	<grp.h>

#include	"radius.h"
#include	"users.h"

#if !defined(NOSHADOW)
#include	<shadow.h>
#endif /* !NOSHADOW */

struct passwd	pw;
char	pwbuf[MAX_LINE_SIZE];

extern int	debug_flag;
extern char	*alt_passwd;

/*************************************************************************
 *
 *	Function: unix_pass
 *
 *	Purpose: Check the users password against the standard UNIX
 *		 password table.
 *
 *************************************************************************/

int
unix_pass(name, passwd, from)
char	*name;
char	*passwd;
char	*from;
{
	struct passwd	*pwd;
	struct passwd	*getownpwnam();
	struct passwd	*getpwnam();
	char		*encpw;
	char		*crypt();
	char		*encrypted_pass;
#if !defined(NOSHADOW)
#if defined(M_UNIX)
	struct passwd	*spwd;
#else
	struct spwd	*spwd;
#endif
#endif /* !NOSHADOW */

	/* Get encrypted password from alternate password file */
	if (alt_passwd != (char *)NULL) {
		if((pwd = getownpwnam(name)) == NULL) {
			DEBUG("unix_pass: getownpwnam for \"%s\"%s failed\n", 
				name, from);
			return(-1);
		}
		encrypted_pass = pwd->pw_passwd;
	}
	else {
	/* Get encrypted password from password file */
		if((pwd = getpwnam(name)) == NULL) {
			DEBUG("unix_pass: getpwnam for \"%s\"%s failed\n",
				name, from);
			return(-1);
		}

#if defined(BSD4_4)
		/* Return failed if Unix Account is expired (locked out) */
		if (pwd->pw_expire && (pwd->pw_expire < time((time_t *)NULL))) {
			DEBUG("unix_pass: account for \"%s\"%s has expired\n", 
				name, from);
			return(-1);
		}
#endif
		encrypted_pass = pwd->pw_passwd;

#if !defined(NOSHADOW)
		if(strcmp(pwd->pw_passwd, "x") == 0 ||
		   strcmp(pwd->pw_passwd, "*") == 0 ||
		   strcmp(pwd->pw_passwd, "*NP*") == 0) {
			if((spwd = getspnam(name)) == NULL) {
				return(-1);
			}
#if defined(M_UNIX)
			encrypted_pass = spwd->pw_passwd;
#else
			encrypted_pass = spwd->sp_pwdp;
#endif	/* M_UNIX */
		}
#endif	/* !NOSHADOW */
	}

	/* Run encryption algorythm */
	encpw = crypt(passwd, encrypted_pass);

	/* Check it */
	if(strcmp(encpw, encrypted_pass)) {
		DEBUG("unix_pass: password for \"%s\"%s failed\n", name, from);
		return(-1);
	}
	return(0);
}

/*************************************************************************
 *
 *	Function: unix_group
 *
 *	Purpose: Check the user's membership to the standard UNIX
 *		 group table.
 *
 *************************************************************************/

int
unix_group(name, group)
char	*name;
char	*group;
{
	struct passwd	*pwd;
	struct passwd	*getownpwnam();
	struct passwd	*getpwnam();
	char		**gr_mem;
	struct group	*gr_ent;
	
	/* Get encrypted password from alternate password file */
	if (alt_passwd != (char *)NULL) {
		if((pwd = getownpwnam(name)) == NULL) {
			DEBUG("unix_group: getownpwnam for \"%s\" failed\n", name);
			return(-1);
		}
	} else {
	/* Get encrypted password from password file */
		if((pwd = getpwnam(name)) == NULL) {
			DEBUG("unix_group: getpwnam for \"%s\" failed\n", name);
			return(0);
		}
	}

	if((gr_ent = getgrnam(group)) == NULL) {
		DEBUG("unix_group: getgrnam(%s) for \"%s\" failed\n", group,name);
		return(0);
	}

	/* Check the immediate group */
	if(pwd->pw_gid == gr_ent->gr_gid) {
		return(1);
	}
	/* Search for this user */
	gr_mem = gr_ent->gr_mem;
	while(*gr_mem != NULL) {
		if(strcmp(*gr_mem, name) == 0) {
			return(1);
		}
		gr_mem++;
	}
	return(0);
}


struct passwd *
getownpwnam(name)
char *name;
{
	extern char	*alt_passwd;
	extern char	pwbuf[];
	extern struct passwd	pw;
	FILE		*pwfd;
	char		*ptr;

	if (alt_passwd == (char *)NULL) {
		return (struct passwd *)NULL;
	}
	if((pwfd = fopen(alt_passwd, "r")) == (FILE *)NULL) {
		return (struct passwd *)NULL;
        }

	memset((char *)&pw,0,sizeof(pw));
	while(fgets(pwbuf, MAX_LINE_SIZE, pwfd) != (char *)NULL) {
		ptr = pwbuf;
		while (*ptr && *ptr != ':')
			ptr++;
		*ptr++ = '\0';
		if (strcmp(name,pwbuf) == 0) {
			pw.pw_name = pwbuf;
			pw.pw_passwd = ptr;
			while (*ptr && *ptr != ':')
				ptr++;
			*ptr++ = '\0';
			pw.pw_uid = atoi(ptr);
			while (*ptr && *ptr != ':')
				ptr++;
			*ptr++ = '\0';
			pw.pw_gid = atoi(ptr);
			while (*ptr && *ptr != ':')
				ptr++;
			*ptr++ = '\0';
			/* we do not use the rest of the entries */
			return (&pw);
		}
	}
	return (struct passwd *)NULL;
}
