% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{DengueTrees}
\alias{DengueTrees}
\title{BEAST analysis of Dengue fever}
\format{A multiPhylo object containing 500 trees, each with 17 tips}
\source{
http://bmcevolbiol.biomedcentral.com/articles/10.1186/1471-2148-7-214
}
\description{
These trees were created using one of the \code{xml} files provided with the original BEAST paper by Drummond and Rambaut (2007).
They provide an example of 17 dengue virus serotype 4 sequences from Lanciotti et al. (1997) (available as \code{\link{DengueSeqs}}) and \code{xml} files with varying priors for model and clock rate.
Here we include a random sample of 500 of the trees (from the second half of the posterior) produced using BEAST v1.8 with the standard GTR + Gamma + I substitution model with uncorrelated lognormal-distributed relaxed molecular clock (file 4).
}
\references{
Drummond, A. J., and Rambaut, A. (2007) 
BEAST: Bayesian evolutionary analysis by sampling trees.
\emph{BMC Evolutionary Biology}, 7(1), 214.

Lanciotti, R. S., Gubler, D. J., and Trent, D. W. (1997)
Molecular evolution and phylogeny of dengue-4 viruses.
\emph{Journal of General Virology}, 78(9), 2279-2286.
}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
\keyword{datasets}
