% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-output.R
\name{expect_output}
\alias{expect_output}
\title{Expectation: does code print output to the console?}
\usage{
expect_output(object, regexp = NULL, ..., info = NULL, label = NULL,
  width = 80)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link{quasi_label} for more details.}

\item{regexp}{Regular expression to test against.
\itemize{
\item A character vector giving a regular expression that must match the output.
\item If \code{NULL}, the default, asserts that there should output,
but doesn't check for a specific value.
\item If \code{NA}, asserts that there should be no output.
}}

\item{...}{Arguments passed on to \code{expect_match}
\describe{
  \item{all}{Should all elements of actual value match \code{regexp} (TRUE),
or does only one need to match (FALSE)}
  \item{perl}{logical.  Should Perl-compatible regexps be used?}
  \item{fixed}{logical.  If \code{TRUE}, \code{pattern} is a string to be
    matched as is.  Overrides all conflicting arguments.}
}}

\item{info}{Extra information to be included in the message. This argument
is soft-deprecated and should not be used in new code. Instead see
alternatives in \link{quasi_label}.}

\item{label}{Used to customise failure messages. For expert use only.}

\item{width}{Number of characters per line of output. This does not
inherit from \code{getOption("width")} so that tests always use the same
output width, minimising spurious differences.}
}
\value{
The first argument, invisibly.
}
\description{
Test for output produced by \code{print()} or \code{cat()}. This is best used for
very simple output; for more complex cases use \code{\link[=verify_output]{verify_output()}}.
}
\examples{
str(mtcars)
expect_output(str(mtcars), "32 obs")
expect_output(str(mtcars), "11 variables")

# You can use the arguments of grepl to control the matching
expect_output(str(mtcars), "11 VARIABLES", ignore.case = TRUE)
expect_output(str(mtcars), "$ mpg", fixed = TRUE)
}
\seealso{
Other expectations: \code{\link{comparison-expectations}},
  \code{\link{equality-expectations}},
  \code{\link{expect_error}}, \code{\link{expect_length}},
  \code{\link{expect_match}}, \code{\link{expect_message}},
  \code{\link{expect_named}}, \code{\link{expect_null}},
  \code{\link{expect_silent}},
  \code{\link{inheritance-expectations}},
  \code{\link{logical-expectations}}
}
\concept{expectations}
