% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reset.R
\name{reset}
\alias{reset}
\title{Reset input elements to their original values}
\usage{
reset(id = "", asis = FALSE)
}
\arguments{
\item{id}{The id of the input element to reset or the id of an HTML
tag to reset all inputs inside it. If no id is provided, then
all inputs on the page are reset.}

\item{asis}{If \code{TRUE}, use the ID as-is even when inside a module
(instead of adding the namespace prefix to the ID).}
}
\description{
Reset any input element back to its original value. You can either reset
one specific input at a time by providing the id of a shiny input, or reset
all inputs within an HTML tag by providing the id of an HTML tag.\cr\cr
Reset can be performed on any traditional Shiny input widget, which
includes: textInput, numericInput, sliderInput, selectInput,
selectizeInput, radioButtons, dateInput, dateRangeInput, checkboxInput,
checkboxGroupInput, colourInput, passwordInput, textAreaInput. Note that
\code{actionButton} is not supported, meaning that you cannot reset
the value of a button back to 0.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\examples{
if (interactive()) {
  library(shiny)

  shinyApp(
    ui = fluidPage(
      useShinyjs(),
      div(
        id = "form",
        textInput("name", "Name", "Dean"),
        radioButtons("gender", "Gender", c("Male", "Female")),
        selectInput("letter", "Favourite letter", LETTERS)
      ),
      actionButton("resetAll", "Reset all"),
      actionButton("resetName", "Reset name"),
      actionButton("resetGender", "Reset Gender"),
      actionButton("resetLetter", "Reset letter")
    ),
    server = function(input, output) {
      observeEvent(input$resetName, {
        reset("name")
      })
      observeEvent(input$resetGender, {
        reset("gender")
      })
      observeEvent(input$resetLetter, {
        reset("letter")
      })
      observeEvent(input$resetAll, {
        reset("form")
      })
    }
  )
}
}
\seealso{
\code{\link[shinyjs]{useShinyjs}},
\code{\link[shinyjs]{runExample}}
}
