% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{query}
\alias{dbClearResult,SQLiteConnection-method}
\alias{dbClearResult,SQLiteResult-method}
\alias{dbFetch,SQLiteResult-method}
\alias{dbGetPreparedQuery,SQLiteConnection,character,data.frame-method}
\alias{dbGetQuery,SQLiteConnection,character-method}
\alias{dbListResults,SQLiteConnection-method}
\alias{dbSendPreparedQuery,SQLiteConnection,character,data.frame-method}
\alias{dbSendQuery,SQLiteConnection,character-method}
\alias{fetch,SQLiteResult-method}
\alias{query}
\title{Execute a SQL statement on a database connection}
\usage{
\S4method{dbSendQuery}{SQLiteConnection,character}(conn, statement)

\S4method{dbSendPreparedQuery}{SQLiteConnection,character,data.frame}(conn,
  statement, bind.data)

\S4method{dbFetch}{SQLiteResult}(res, n = 0)

\S4method{fetch}{SQLiteResult}(res, n = 0)

\S4method{dbClearResult}{SQLiteResult}(res, ...)

\S4method{dbClearResult}{SQLiteConnection}(res, ...)

\S4method{dbListResults}{SQLiteConnection}(conn, ...)

\S4method{dbGetQuery}{SQLiteConnection,character}(conn, statement)

\S4method{dbGetPreparedQuery}{SQLiteConnection,character,data.frame}(conn,
  statement, bind.data)
}
\arguments{
\item{conn}{an \code{\linkS4class{SQLiteConnection}} object.}

\item{statement}{a character vector of length one specifying the SQL
statement that should be executed.  Only a single SQL statment should be
provided.}

\item{bind.data}{A data frame of data to be bound.}

\item{res}{an \code{\linkS4class{SQLiteResult}} object.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{-1} to
retrieve all pending records; use \code{0} for to fetch the default
number of rows as defined in \code{\link{SQLite}}}

\item{...}{Unused. Needed for compatibility with generic.}
}
\description{
To retrieve results a chunk at a time, use \code{dbSendQuery},
\code{dbFetch}, then \code{ClearResult}. Alternatively, if you want all the
results (and they'll fit in memory) use \code{dbGetQuery} which sends,
fetches and clears for you.
}
\examples{
con <- dbConnect(SQLite(), ":memory:")
dbWriteTable(con, "arrests", datasets::USArrests)

# Run query to get results as dataframe
dbGetQuery(con, "SELECT * FROM arrests limit 3")

# Send query to pull requests in batches
res <- dbSendQuery(con, "SELECT * FROM arrests")
data <- fetch(res, n = 2)
data
dbHasCompleted(res)

dbListResults(con)
dbClearResult(res)

# Use dbSendPreparedQuery/dbGetPreparedQuery for "prepared" queries
dbGetPreparedQuery(con, "SELECT * FROM arrests WHERE Murder < ?",
   data.frame(x = 3))
dbGetPreparedQuery(con, "SELECT * FROM arrests WHERE Murder < (:x)",
   data.frame(x = 3))

dbDisconnect(con)
}

