% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_job_status.R
\name{get_job_status}
\alias{get_job_status}
\title{Get the status of a Slurm job}
\usage{
get_job_status(slr_job)
}
\arguments{
\item{slr_job}{A \code{slurm_job} object.}
}
\value{
A list with three elements: \code{completed} is a logical value 
  indicating if all portions of the job have completed or stopped, \code{queue} 
  contains the information on job elements still in queue, and
  \code{log} contains the console/error logs.
}
\description{
This function returns the completion status of a Slurm job, its queue status 
if any and log outputs.
}
\details{
The \code{queue} element of the output is a data frame matching the output
of the Slurm \code{squeue} command for that job; it will only indicate portions
of job that are running or in queue. The \code{log} element is a
vector of the contents of console/error output files for each node where the 
job is running.
}
