% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.group.R
\name{list.group}
\alias{list.group}
\title{Divide list/vector elements into exclusive groups}
\usage{
list.group(.data, ..., sorted = TRUE)
}
\arguments{
\item{.data}{A \code{list} or \code{vector}}

\item{...}{One or more expressions in the scope of each element to evaluate
as keys}

\item{sorted}{\code{TRUE} to sort the group keys. Ignored when the key has
multiple entries.}
}
\value{
A list of group elements each contain all the elements in \code{.data}
belonging to the group
}
\description{
Divide list/vector elements into exclusive groups
}
\examples{
x <- list(p1 = list(type='A',score=list(c1=10,c2=8)),
       p2 = list(type='B',score=list(c1=9,c2=9)),
       p3 = list(type='B',score=list(c1=9,c2=7)))
list.group(x, type)
list.group(x, mean(unlist(score)))
}
\seealso{
\code{\link{list.ungroup}}
}
