% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Serializer.R
\docType{methods}
\name{freeSerializer}
\alias{freeSerializer}
\alias{freeSerializer,Serializer-method}
\title{Free memory used by a librdf serializer.}
\usage{
freeSerializer(.Object)

\S4method{freeSerializer}{Serializer}(.Object)
}
\arguments{
\item{.Object}{a Serializer object}
}
\description{
Free memory used by a librdf serializer.
}
\examples{
world <- new("World")
storage <- new("Storage", world, "hashes", name="", options="hash-type='memory'")
model <- new("Model", world, storage, options="")
filePath <- system.file("extdata/example.rdf", package="redland")
parser <- new("Parser", world)
parseFileIntoModel(parser, world, filePath, model)
# Creat the default "rdfxml" serizlizer
serializer <- new("Serializer", world)
# At this point, some operations would be performed with the Serializer object. 
# See '?Serializer' for a complete example.
# When the serializer object is no longer needed, the resources it had allocated can be freed.
freeSerializer(serializer)
rm(serializer)
}
