% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial.R
\name{partial}
\alias{partial}
\title{Partial apply a function, filling in some arguments.}
\usage{
partial(.f, ..., .env = NULL, .lazy = NULL, .first = NULL)
}
\arguments{
\item{.f}{a function. For the output source to read well, this should be a
named function.}

\item{...}{named arguments to \code{.f} that should be partially applied.

Pass an empty \code{... = } argument to specify the position of future
arguments relative to partialised ones. See
\code{\link[rlang:call_modify]{rlang::call_modify()}} to learn more about this syntax.

These dots support quasiquotation and quosures. If you unquote a
value, it is evaluated only once at function creation time.
Otherwise, it is evaluated each time the function is called.}

\item{.env}{Soft-deprecated as of purrr 0.3.0. The environments are
now captured via quosures.}

\item{.lazy}{Soft-deprecated as of purrr 0.3.0. Please unquote the
arguments that should be evaluated once at function creation time.}

\item{.first}{Soft-deprecated as of purrr 0.3.0. Please pass an
empty argument \code{... = } to specify the position of future
arguments.}
}
\description{
Partial function application allows you to modify a function by pre-filling
some of the arguments.  It is particularly useful in conjunction with
functionals and other function operators.

Note that an argument can only be partialised once.
}
\examples{
# Partial is designed to replace the use of anonymous functions for
# filling in function arguments. Instead of:
compact1 <- function(x) discard(x, is.null)

# we can write:
compact2 <- partial(discard, .p = is.null)

# partial() works fine with functions that do non-standard
# evaluation
my_long_variable <- 1:10
plot2 <- partial(plot, my_long_variable)
plot2()
plot2(runif(10), type = "l")

# Note that you currently can't partialise arguments multiple times:
my_mean <- partial(mean, na.rm = TRUE)
my_mean <- partial(my_mean, na.rm = FALSE)
try(my_mean(1:10))


# The evaluation of arguments normally occurs "lazily". Concretely,
# this means that arguments are repeatedly evaluated across invocations:
f <- partial(runif, n = rpois(1, 5))
f
f()
f()

# You can unquote an argument to fix it to a particular value.
# Unquoted arguments are evaluated only once when the function is created:
f <- partial(runif, n = !!rpois(1, 5))
f
f()
f()


# By default, partialised arguments are passed before new ones:
my_list <- partial(list, 1, 2)
my_list("foo")

# Control the position of these arguments by passing an empty
# `... = ` argument:
my_list <- partial(list, 1, ... = , 2)
my_list("foo")
}
