% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.matrix.R
\name{publish.matrix}
\alias{publish.matrix}
\title{Publishing a matrix in raw, org, latex, or muse format}
\usage{
\method{publish}{matrix}(
  object,
  title,
  colnames = TRUE,
  rownames = TRUE,
  col1name = "",
  digits = 4,
  try.convert = TRUE,
  sep = " ",
  endhead,
  endrow,
  style,
  inter.lines,
  latex = FALSE,
  wiki = FALSE,
  org = FALSE,
  markdown = FALSE,
  tabular = TRUE,
  latex.table.format = NA,
  latex.hline = 1,
  latex.nodollar = FALSE,
  ...
)
}
\arguments{
\item{object}{Matrix to be published}

\item{title}{Title for table, only in wiki and muse format}

\item{colnames}{If \code{TRUE} show column names}

\item{rownames}{If \code{TRUE} show row names}

\item{col1name}{Name for first column}

\item{digits}{Numbers are rounded according to digits}

\item{try.convert}{Logical. If \code{TRUE} try to convert also non-numeric
formats such as character to numeric before rounding. Default is \code{TRUE}.}

\item{sep}{Field separator when style is \code{"none"}}

\item{endhead}{String to be pasted at the end of the first row
(header)}

\item{endrow}{String to be pasted at the end of each row}

\item{style}{Table style for export to \code{"latex"},
\code{"org"}, \code{"markdown"}, \code{"wiki"},
\code{"none"}. Overwritten by argments below.}

\item{inter.lines}{A named list which contains strings to be
placed between the rows of the table. An element with name
\code{"0"} is used to place a line before the first column,
elements with name \code{"r"} are placed between line r and
r+1.}

\item{latex}{If \code{TRUE} use latex table format}

\item{wiki}{If \code{TRUE} use mediawiki table format}

\item{org}{If \code{TRUE} use emacs orgmode table format}

\item{markdown}{If \code{TRUE} use markdown table format}

\item{tabular}{For style \code{latex} only: if \code{TRUE} enclose
the table in begin/end tabular environement.}

\item{latex.table.format}{For style \code{latex} only: format of
the tabular environement.}

\item{latex.hline}{For style \code{latex} only: if \code{TRUE} add
hline statements add the end of each line.}

\item{latex.nodollar}{For style \code{latex} only: if \code{TRUE}
do not enclose numbers in dollars.}

\item{...}{Used to transport arguments. Currently supports
\code{wiki.class}.}
}
\description{
This is the heart of the Publish package
}
\examples{

x <- matrix(1:12,ncol=3)
publish(x)

# rounding the numeric part of data mixtures 
y <- cbind(matrix(letters[1:12],ncol=3),x,matrix(rnorm(12),ncol=3))
publish(y,digits=1)

publish(x,latex=TRUE,
inter.lines=list("1"="text between line 1 and line 2",
                          "3"="text between line 3 and line 4"))

}
