% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/def_conexp.R, R/def_conlorm.R,
%   R/def_conpl.R, R/def_conweibull.R, R/def_disexp.R, R/def_dislnorm.R,
%   R/def_displ.R, R/def_dispois.R
\docType{methods}
\name{dist_cdf}
\alias{dist_cdf}
\alias{dist_cdf,conexp-method}
\alias{dist_all_cdf,conexp-method}
\alias{dist_all_cdf,conexo-method}
\alias{dist_cdf,conlnorm-method}
\alias{dist_all_cdf,conlnorm-method}
\alias{dist_cdf,conpl-method}
\alias{dist_all_cdf,conpl-method}
\alias{dist_cdf,conweibull-method}
\alias{dist_all_cdf,conweibull-method}
\alias{dist_cdf,disexp-method}
\alias{dist_all_cdf,disexp-method}
\alias{dist_cdf,dislnorm-method}
\alias{dist_all_cdf,dislnorm-method}
\alias{dist_cdf,displ-method}
\alias{dist_all_cdf,displ-method}
\alias{dist_cdf,dispois-method}
\alias{dist_all_cdf,dispois-method}
\title{The cumulative distribution function (cdf)}
\usage{
dist_cdf(m, q = NULL, lower_tail = FALSE)

\S4method{dist_cdf}{conexp}(m, q = NULL, lower_tail = TRUE)

\S4method{dist_all_cdf}{conexp}(m, lower_tail = TRUE, xmax = 1e+05)

\S4method{dist_cdf}{conlnorm}(m, q = NULL, lower_tail = TRUE)

\S4method{dist_all_cdf}{conlnorm}(m, lower_tail = TRUE, xmax = 1e+05)

\S4method{dist_cdf}{conpl}(m, q = NULL, lower_tail = TRUE)

\S4method{dist_all_cdf}{conpl}(m, lower_tail = TRUE, xmax = 1e+05)

\S4method{dist_cdf}{conweibull}(m, q = NULL, lower_tail = TRUE)

\S4method{dist_all_cdf}{conweibull}(m, lower_tail = TRUE, xmax = 1e+05)

\S4method{dist_cdf}{disexp}(m, q = NULL, lower_tail = TRUE)

\S4method{dist_all_cdf}{disexp}(m, lower_tail = TRUE, xmax = 1e+05)

\S4method{dist_cdf}{dislnorm}(m, q = NULL, lower_tail = TRUE)

\S4method{dist_all_cdf}{dislnorm}(m, lower_tail = TRUE, xmax = 1e+05)

\S4method{dist_cdf}{displ}(m, q = NULL, lower_tail = TRUE)

\S4method{dist_all_cdf}{displ}(m, lower_tail = TRUE, xmax = 1e+05)

\S4method{dist_cdf}{dispois}(m, q = NULL, lower_tail = TRUE)

\S4method{dist_all_cdf}{dispois}(m, lower_tail = TRUE, xmax = 1e+05)
}
\arguments{
\item{m}{a distribution object.}

\item{q}{a vector values where the function will be evaluated. 
If \code{q} is \code{NULL} (default), then the data values 
will be used.}

\item{lower_tail}{logical; if \code{TRUE} (default), 
probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{xmax}{default \code{1e5}. The maximum x value calculated when working out the CDF.}
}
\description{
This is a generic function for calculating
the cumulative distribution function (cdf) of 
distribution objects. This is similar to base R's \code{pnorm} 
for the normal distribution. 
The \code{dist_cdf} function calculates the 
cumulative probability distribution for the 
current parameters and xmin value.
}
\note{
This method does *not* alter the internal state of
the distribution objects.
}
\examples{
##########################################
#Load data and create distribution object#
##########################################
data(moby_sample)
m = displ$new(moby_sample)
m$setXmin(7); m$setPars(2)

##########################################
#Calculate the CDF at a particular values#
##########################################
dist_cdf(m, 10:15)

########################################## 
#Calculate the CDF at the data values    #
##########################################
dist_cdf(m)
}
