% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.r
\name{using_something}
\alias{using_something}
\alias{using_envvar}
\alias{using_env}
\alias{using_locale}
\alias{using_collate}
\alias{using_dir}
\alias{using_libpaths}
\alias{using_lib}
\alias{using_options}
\alias{using_par}
\alias{using_path}
\title{Execute code in temporarily altered environment.}
\usage{
using_envvar(new, code, action = "replace")

using_env(new, code)

using_locale(new, code)

using_collate(new, code)

using_dir(new, code)

using_libpaths(new, code)

using_lib(new, code)

using_options(new, code)

using_par(new, code)

using_path(new, code, add = TRUE, prepend = FALSE)
}
\arguments{
\item{new}{values for setting}

\item{code}{code to execute in that environment}

\item{action}{(for \code{using_envvar} only): should new values
\code{"replace"}, \code{"suffix"}, \code{"prefix"} existing environmental
variables with the same name.}

\item{add}{Combine with existing values? Currently for
\code{\link{using_path}} only. If \code{FALSE} all existing
paths are overwritten, which you don't usually want.}

\item{prepend}{logical that indicates if the new paths should
be added in front of the current ones.}
}
\description{
These functions were extracted from the \pkg{devtools} package
to make them available without a dependency to \pkg{devtools}.
}
\details{
\itemize{
\item \code{using_dir}: working directory
\item \code{using_collate}: collation order
\item \code{using_envvar}: environmental variables
\item \code{using_libpaths}: library paths, replacing current libpaths
\item \code{using_lib}: library paths, prepending to current libpaths
\item \code{using_locale}: any locale setting
\item \code{using_options}: options
\item \code{using_path}: PATH environment variable
\item \code{using_par}: graphics parameters
}
}
\section{Deprecation}{

\code{using_env} will be deprecated in devtools 1.2 and removed in
devtools 1.3
}

\examples{
\dontshow{
options(R_CHECK_RUNNING_EXAMPLES_=TRUE) ## roxygen generated flag
}

getwd()
using_dir(tempdir(), getwd())
getwd()

Sys.getenv("HADLEY")
using_envvar(c("HADLEY" = 2), Sys.getenv("HADLEY"))
Sys.getenv("HADLEY")

using_envvar(c("A" = 1),
  using_envvar(c("A" = 2), action = "suffix", Sys.getenv("A"))
)
}
\author{
Hadley Wickham
}
