% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictEventProb.R
\name{predictEventProb}
\alias{predictEventProb}
\alias{predictEventProb.CauseSpecificCox}
\alias{predictEventProb.riskRegression}
\alias{predictEventProb.FGR}
\alias{predictEventProb.prodlim}
\alias{predictEventProb.rfsrc}
\title{Predicting event probabilities (cumulative incidences) in competing risk
models.}
\usage{
predictEventProb(object, newdata, times, cause, ...)
}
\arguments{
\item{object}{A fitted model from which to extract predicted event
probabilities}

\item{newdata}{A data frame containing predictor variable combinations for
which to compute predicted event probabilities.}

\item{times}{A vector of times in the range of the response variable, for
which the cumulative incidences event probabilities are computed.}

\item{cause}{Identifies the cause of interest among the competing events.}

\item{\dots}{Additional arguments that are passed on to the current method.}
}
\value{
A matrix with as many rows as \code{NROW(newdata)} and as many
columns as \code{length(times)}. Each entry should be a probability and in
rows the values should be increasing.
}
\description{
Function to extract event probability predictions from various modeling
approaches. The most prominent one is the combination of cause-specific Cox
regression models which can be fitted with the function \code{cumincCox}
from the package \code{compRisk}.
}
\details{
The function predictEventProb is a generic function that means it invokes
specifically designed functions depending on the 'class' of the first
argument.

See \code{\link{predictSurvProb}}.
}
\examples{

library(pec)
library(survival)
library(riskRegression)
library(prodlim)
train <- SimCompRisk(100)
test <- SimCompRisk(10)
cox.fit  <- CSC(Hist(time,cause)~X1+X2,data=train)
predictEventProb(cox.fit,newdata=test,times=seq(1:10),cause=1)

## with strata
cox.fit2  <- CSC(list(Hist(time,cause)~strata(X1)+X2,Hist(time,cause)~X1+X2),data=train)
predictEventProb(cox.fit2,newdata=test,times=seq(1:10),cause=1)

}
\seealso{
See \code{\link{predictSurvProb}}.
}
\author{
Thomas A. Gerds \email{tag@biostat.ku.dk}
}
\keyword{survival}
