% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_table.R
\name{wrap_table}
\alias{wrap_table}
\title{Wrap a table in a patchwork compliant patch}
\usage{
wrap_table(
  table,
  panel = c("body", "full", "rows", "cols"),
  space = c("free", "free_x", "free_y", "fixed"),
  ignore_tag = FALSE
)
}
\arguments{
\item{table}{A gt table or an object coercible to a data frame}

\item{panel}{what portion of the table should be aligned with the panel
region? \code{"body"} means that any column and row headers will be placed outside
the panel region, i.e. the topleft corner of the panel region will be aligned
with the topleft data cell. \code{"full"} means that the whole table will be
placed inside the panel region. \code{"rows"} means that all rows (including column
headers) will be placed inside the panel region but row headers will be
placed to the left. \code{"cols"} is the opposite, placing all columns within the
panel region but keeping the column header on top of it. If this is set to
\code{"body"} or \code{"cols"} and \code{space} is set to \code{"fixed"} or \code{"free_x"} then any
footnotes or source notes in the table will be placed outside the bottom of
the panel region.}

\item{space}{How should the dimension of the table influence the final
composition? \code{"fixed"} means that the table width will set the width of the
column it occupies and the table height will set the height of the row it
occupies. \code{"free"} is the opposite meaning that the table dimension will not
have any influence on the sizing. \code{"free_x"} and \code{"free_y"} allows you to
free either direction while keeping the remaining fixed. Do note that if you
set a specific width or height in \code{\link[=plot_layout]{plot_layout()}} it will have higher
priority than the table dimensions}

\item{ignore_tag}{Should tags be ignored for this patch. This is relevant
when using automatic tagging of plots and the content of the patch does not
qualify for a tag.}
}
\value{
A wrapped_table object
}
\description{
This function works much like \code{\link[=wrap_elements]{wrap_elements()}} in that it turns the input
into patchwork compliant objects that can be added to a composition. However,
\code{wrap_table()} uses the knowledge that the input is a table to provide some
very nifty layout options that makes it generally better to use than
\code{\link[=wrap_elements]{wrap_elements()}} for this type of object.
}
\note{
This functionality requires v0.11.0 or higher of the gt package
}
\examples{
\dontshow{if (requireNamespace("gt", quietly = TRUE) && packageVersion("gt") >= "0.11.0") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
library(gt)

p1 <- ggplot(airquality) +
  geom_line(aes(x = Day, y = Temp, colour = month.name[Month])) +
  labs(colour = "Month")

table <- data.frame(
  Month = month.name[5:9],
  "Mean temp." = tapply(airquality$Temp, airquality$Month, mean),
  "Min temp." = tapply(airquality$Temp, airquality$Month, min),
  "Max temp." = tapply(airquality$Temp, airquality$Month, max)
)
gt_tab <- gt(table, rowname_col = "Month")

# Default addition usees wrap_table
p1 + gt_tab

# Default places column and row headers outside panel area. Use wrap_table
# to control this
p1 + wrap_table(gt_tab, panel = "full")

# Tables generally have fixed dimensions and these can be used to control
# the size of the area they occupy
p2 <- ggplot(airquality) +
  geom_boxplot(aes(y = month.name[Month], x = Temp)) +
  scale_y_discrete(name = NULL, limits = month.name[9:5], guide = "none")

wrap_table(gt_tab, space = "fixed") + p2
\dontshow{\}) # examplesIf}
}
