% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_performance.R
\name{cluster_performance}
\alias{cluster_performance}
\alias{cluster_performance.hclust}
\title{Performance of clustering models}
\usage{
cluster_performance(model, ...)

\method{cluster_performance}{hclust}(model, data, clusters, ...)
}
\arguments{
\item{model}{Cluster model.}

\item{...}{Arguments passed to or from other methods.}

\item{data}{A data frame.}

\item{clusters}{A vector with clusters assignments (must be same length as
rows in data).}
}
\description{
Compute performance indices for clustering solutions.
}
\examples{
# kmeans
model <- kmeans(iris[1:4], 3)
cluster_performance(model)

# hclust
data <- iris[1:4]
model <- hclust(dist(data))
clusters <- cutree(model, 3)
cluster_performance(model, data, clusters)

# Retrieve performance from parameters
params <- model_parameters(kmeans(iris[1:4], 3))
cluster_performance(params)
}
