% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_centers.R
\name{cluster_centers}
\alias{cluster_centers}
\title{Find the cluster centers in your data}
\usage{
cluster_centers(data, clusters, fun = mean, ...)
}
\arguments{
\item{data}{A data.frame.}

\item{clusters}{A vector with clusters assignments (must be same length as rows in data).}

\item{fun}{What function to use, \code{mean} by default.}

\item{...}{Other arguments to be passed to or from other functions.}
}
\value{
A dataframe containing the cluster centers. Attributes include performance statistics and distance between each observation and its respective cluster centre.
}
\description{
For each cluster, computes the mean (or other indices) of the variables. Can be used
to retrieve the centers of clusters. Also returns the within Sum of Squares.
}
\examples{
k <- kmeans(iris[1:4], 3)
cluster_centers(iris[1:4], clusters = k$cluster)
cluster_centers(iris[1:4], clusters = k$cluster, fun = median)
}
