#' Tate Gallery modern artwork metadata
#'
#' Metadata such as artist, title, and year created for recent artworks owned
#'  by the Tate Gallery. Only artworks created during or after 1990 are
#'  included, and the metadata source was last updated in 2014. The Tate Gallery
#'  provides these data but requests users to be respectful of their
#'  [guidelines for use](https://github.com/tategallery/collection#usage-guidelines-for-open-data).
#'
#' @name tate_text
#' @aliases tate_text
#' @docType data
#' @return \item{tate_text}{a tibble}
#'
#' @source \itemize{
#' \item \url{https://github.com/tategallery/collection}
#' \item \url{https://www.tate.org.uk/}
#' }
#'
#' @keywords datasets
#' @examples
#' data(tate_text)
#' str(tate_text)
NULL
