% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CostSensRegrWrapper.R
\name{makeCostSensRegrWrapper}
\alias{makeCostSensRegrWrapper}
\alias{CostSensRegrWrapper}
\alias{CostSensRegrModel}
\title{Wraps a regression learner for use in cost-sensitive learning.}
\usage{
makeCostSensRegrWrapper(learner)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The regression learner.
If you pass a string the learner will be created via \link{makeLearner}.}
}
\value{
\link{Learner}.
}
\description{
Creates a wrapper, which can be used like any other learner object.
Models can easily be accessed via \link{getLearnerModel}.

For each class in the task, an individual regression model is fitted for the costs of that class.
During prediction, the class with the lowest predicted costs is selected.
}
\seealso{
Other costsens: 
\code{\link{makeCostSensClassifWrapper}()},
\code{\link{makeCostSensTask}()},
\code{\link{makeCostSensWeightedPairsWrapper}()}

Other wrapper: 
\code{\link{makeBaggingWrapper}()},
\code{\link{makeClassificationViaRegressionWrapper}()},
\code{\link{makeConstantClassWrapper}()},
\code{\link{makeCostSensClassifWrapper}()},
\code{\link{makeDownsampleWrapper}()},
\code{\link{makeDummyFeaturesWrapper}()},
\code{\link{makeExtractFDAFeatsWrapper}()},
\code{\link{makeFeatSelWrapper}()},
\code{\link{makeFilterWrapper}()},
\code{\link{makeImputeWrapper}()},
\code{\link{makeMulticlassWrapper}()},
\code{\link{makeMultilabelBinaryRelevanceWrapper}()},
\code{\link{makeMultilabelClassifierChainsWrapper}()},
\code{\link{makeMultilabelDBRWrapper}()},
\code{\link{makeMultilabelNestedStackingWrapper}()},
\code{\link{makeMultilabelStackingWrapper}()},
\code{\link{makeOverBaggingWrapper}()},
\code{\link{makePreprocWrapper}()},
\code{\link{makePreprocWrapperCaret}()},
\code{\link{makeRemoveConstantFeaturesWrapper}()},
\code{\link{makeSMOTEWrapper}()},
\code{\link{makeTuneWrapper}()},
\code{\link{makeUndersampleWrapper}()},
\code{\link{makeWeightedClassesWrapper}()}
}
\concept{costsens}
\concept{wrapper}
