% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classification.R
\name{FBeta_Score}
\alias{FBeta_Score}
\title{F-Beta Score}
\usage{
FBeta_Score(y_true, y_pred, positive = NULL, beta = 1)
}
\arguments{
\item{y_true}{Ground truth (correct) 0-1 labels vector}

\item{y_pred}{Predicted labels vector, as returned by a classifier}

\item{positive}{An optional character string for the factor level that
corresponds to a "positive" result}

\item{beta}{Weight of precision in harmonic mean}
}
\value{
F-Beta Score
}
\description{
Compute the F-Beta Score
}
\examples{
data(cars)
logreg <- glm(formula = vs ~ hp + wt,
              family = binomial(link = "logit"), data = mtcars)
pred <- ifelse(logreg$fitted.values < 0.5, 0, 1)
FBeta_Score(y_pred = pred, y_true = mtcars$vs, positive = "0", beta = 2)
FBeta_Score(y_pred = pred, y_true = mtcars$vs, positive = "1", beta = 2)
}

