% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.norm.R
\name{mice.impute.norm}
\alias{mice.impute.norm}
\alias{norm}
\title{Imputation by Bayesian linear regression}
\usage{
mice.impute.norm(y, ry, x, wy = NULL, ...)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length \code{length(y)} indicating the 
the subset \code{y[ry]} of elements in \code{y} to which the imputation 
model is fitted. The \code{ry} generally distinguishes the observed 
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for 
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value 
indicates locations in \code{y} for which imputations are created.}

\item{...}{Other named arguments.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length 
\code{sum(wy)}
}
\description{
Calculates imputations for univariate missing data by Bayesian linear 
regression, also known as the normal model.
}
\details{
Imputation of \code{y} by the normal model by the method defined by 
Rubin (1987, p. 167). The procedure is as follows:

\enumerate{
\item{Calculate the cross-product matrix \eqn{S=X_{obs}'X_{obs}}.}
\item{Calculate \eqn{V = (S+{diag}(S)\kappa)^{-1}}, with some small ridge 
parameter \eqn{\kappa}.}
\item{Calculate regression weights \eqn{\hat\beta = VX_{obs}'y_{obs}.}}
\item{Draw a random variable \eqn{\dot g \sim \chi^2_\nu} with \eqn{\nu=n_1 - q}.}
\item{Calculate \eqn{\dot\sigma^2 = (y_{obs} - X_{obs}\hat\beta)'(y_{obs} - X_{obs}\hat\beta)/\dot g.}}
\item{Draw \eqn{q} independent \eqn{N(0,1)} variates in vector \eqn{\dot z_1}.}
\item{Calculate \eqn{V^{1/2}} by Cholesky decomposition.}
\item{Calculate \eqn{\dot\beta = \hat\beta + \dot\sigma\dot z_1 V^{1/2}}.}
\item{Draw \eqn{n_0} independent \eqn{N(0,1)} variates in vector \eqn{\dot z_2}.}
\item{Calculate the \eqn{n_0} values \eqn{y_{imp} = X_{mis}\dot\beta + \dot z_2\dot\sigma}.}
}

Using \code{mice.impute.norm} for all columns emulates Schafer's NORM method (Schafer, 1997).
}
\references{
Rubin, D.B (1987). Multiple Imputation for Nonresponse in Surveys. New York: John Wiley & Sons.

Schafer, J.L. (1997). Analysis of incomplete multivariate data. London: Chapman & Hall.
}
\seealso{
Other univariate imputation functions: 
\code{\link{mice.impute.cart}()},
\code{\link{mice.impute.lda}()},
\code{\link{mice.impute.logreg.boot}()},
\code{\link{mice.impute.logreg}()},
\code{\link{mice.impute.mean}()},
\code{\link{mice.impute.midastouch}()},
\code{\link{mice.impute.mnar.logreg}()},
\code{\link{mice.impute.norm.boot}()},
\code{\link{mice.impute.norm.nob}()},
\code{\link{mice.impute.norm.predict}()},
\code{\link{mice.impute.pmm}()},
\code{\link{mice.impute.polr}()},
\code{\link{mice.impute.polyreg}()},
\code{\link{mice.impute.quadratic}()},
\code{\link{mice.impute.rf}()},
\code{\link{mice.impute.ri}()}
}
\author{
Stef van Buuren, Karin Groothuis-Oudshoorn
}
\concept{univariate imputation functions}
\keyword{datagen}
