% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilistic.R
\name{meanNumVisits}
\alias{meanNumVisits}
\title{Mean num of visits for markovchain, starting at each state}
\usage{
meanNumVisits(object)
}
\arguments{
\item{object}{the markovchain-class object}
}
\value{
a matrix with the expect number of visits to each state
}
\description{
Given a markovchain object, this function calculates 
a matrix where the element (i, j) represents the expect number of visits
to the state j if the chain starts at i (in a Markov chain by columns it
would be the element (j, i) instead)
}
\examples{
M <- matlab::zeros(5, 5)
M[1,1] <- M[5,5] <- 1
M[2,1] <- M[2,3] <- 1/2
M[3,2] <- M[3,4] <- 1/2
M[4,2] <- M[4,5] <- 1/2

mc <- new("markovchain", transitionMatrix = M)
meanNumVisits(mc)

}
\references{
R. Vélez, T. Prieto, Procesos Estocásticos, Librería UNED, 2013
}
\author{
Ignacio Cordón
}
