% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createContrast.R
\name{contrast2name}
\alias{contrast2name}
\alias{.contrast2name}
\title{Create Rownames for a Contrast Matrix}
\usage{
.contrast2name(contrast, null = NULL, sep = c("[", "]"))
}
\arguments{
\item{contrast}{[matrix] a contrast matrix defining the left hand side of the linear hypotheses to be tested.}

\item{null}{[vector, optional] the right hand side of the linear hypotheses to be tested.}

\item{sep}{[character of length 2, optional] character used in rownames to wrap the left hand side of the equation.}
}
\value{
a character vector.
}
\description{
Create rownames for a contrast matrix using the coefficients and the names of the coefficients. The rownames will be [value * name] == null, e.g. [beta + 4*alpha] = 0.
}
\details{
When argument \code{NULL} is null then the rownames will not be put into brackets and the right hand side will not be added to the name.
}
\keyword{internal}
