% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{neighbors}
\alias{neighbors}
\title{Neighboring (adjacent) vertices in a graph}
\usage{
neighbors(graph, v, mode = c("out", "in", "all", "total"))
}
\arguments{
\item{graph}{The input graph.}

\item{v}{The vertex of which the adjacent vertices are queried.}

\item{mode}{Whether to query outgoing (\sQuote{out}), incoming
(\sQuote{in}) edges, or both types (\sQuote{all}). This is
ignored for undirected graphs.}
}
\value{
A vertex sequence containing the neighbors of the input vertex.
}
\description{
A vertex is a neighbor of another one (in other words, the two
vertices are adjacent), if they are incident to the same edge.
}
\examples{
g <- make_graph("Zachary")
n1 <- neighbors(g, 1)
n34 <- neighbors(g, 34)
intersection(n1, n34)
}
\seealso{
Other structural queries: \code{\link{[.igraph}},
  \code{\link{[[.igraph}}, \code{\link{adjacent_vertices}},
  \code{\link{are_adjacent}}, \code{\link{ends}},
  \code{\link{get.edge.ids}}, \code{\link{gorder}},
  \code{\link{gsize}}, \code{\link{head_of}},
  \code{\link{incident_edges}}, \code{\link{incident}},
  \code{\link{is_directed}}, \code{\link{tail_of}}
}
