% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlwidgets.R
\name{createWidget}
\alias{createWidget}
\title{Create an HTML Widget}
\usage{
createWidget(
  name,
  x,
  width = NULL,
  height = NULL,
  sizingPolicy = htmlwidgets::sizingPolicy(),
  package = name,
  dependencies = NULL,
  elementId = NULL,
  preRenderHook = NULL
)
}
\arguments{
\item{name}{Widget name (should match the base name of the YAML and
JavaScript files used to implement the widget)}

\item{x}{Widget instance data (underlying data to render and options that
govern how it's rendered). This value will be converted to JSON using
\code{\link[jsonlite]{toJSON}} and made available to the widget's
JavaScript \code{renderValue} function.}

\item{width}{Fixed width for widget (in css units). The default is
\code{NULL}, which results in intelligent automatic sizing based on the
widget's container.}

\item{height}{Fixed height for widget (in css units). The default is
\code{NULL}, which results in intelligent automatic sizing based on the
widget's container.}

\item{sizingPolicy}{Options that govern how the widget is sized in various
containers (e.g. a standalone browser, the RStudio Viewer, a knitr figure,
or a Shiny output binding). These options can be specified by calling the
\code{\link{sizingPolicy}} function.}

\item{package}{Package where the widget is defined (defaults to the widget
name).}

\item{dependencies}{Additional widget HTML dependencies (over and above those
defined in the widget YAML). This is useful for dynamic dependencies that
only exist when selected widget options are enabled (e.g. sets of map tiles
or projections).}

\item{elementId}{Use an explicit element ID for the widget (rather than an
automatically generated one). Useful if you have other JavaScript that
needs to explicitly discover and interact with a specific widget instance.}

\item{preRenderHook}{A function to be run on the widget, just prior to
rendering. It accepts the entire widget object as input, and should return
a modified widget object.}
}
\value{
An object of class \code{htmlwidget} that will intelligently print
  itself into HTML in a variety of contexts including the R console, within R
  Markdown documents, and within Shiny output bindings.
}
\description{
Create an HTML widget based on widget YAML and JavaScript contained within
the specified package.
}
\details{
For additional details on developing widgets, see package vignettes:
\code{vignette("develop_intro", package = "htmlwidgets")}.
}
