% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOCore.R
\name{reduce_overlap}
\alias{reduce_overlap}
\title{Eliminates redundant terms.}
\usage{
reduce_overlap(data, overlap)
}
\arguments{
\item{data}{A data frame created with \code{circle_dat}.}

\item{overlap}{Skalar indicating the threshold for gene overlap (default = 0.75).}
}
\description{
The function eliminates all terms with a gene overlap >= set
  threshold (\code{overlap}) The reduced dataset can be used to improve the
  readability of plots such as \code{GOBubble} and \code{GOBar}
}
\details{
The function is currently very slow.
}
\examples{
\dontrun{
# Load the included dataset
data(EC)

# Building the circ object
circ <- circle_dat(EC$david, EC$genelist)

# Eliminate redundant terms
reduced_circ <- reduce_overlap(circ)

# Plot reduced data
GOBubble(reduced_circ)

}
}

