% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-jitter.r
\name{geom_jitter}
\alias{geom_jitter}
\title{Points, jittered to reduce overplotting.}
\usage{
geom_jitter(mapping = NULL, data = NULL, width = NULL, height = NULL,
  stat = "identity", position = "jitter", na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{width}{Amount of vertical and horizontal jitter. The jitter
  is added in both positive and negative directions, so the total spread
  is twice the value specified here.

  If omitted, defaults to 40\% of the resolution of the data: this means the
  jitter values will occupy 80\% of the implied bins. Categorical data
  is aligned on the integers, so a width or height of 0.5 will spread the
  data so it's not possible to see the distinction between the categories.}

\item{height}{Amount of vertical and horizontal jitter. The jitter
  is added in both positive and negative directions, so the total spread
  is twice the value specified here.

  If omitted, defaults to 40\% of the resolution of the data: this means the
  jitter values will occupy 80\% of the implied bins. Categorical data
  is aligned on the integers, so a width or height of 0.5 will spread the
  data so it's not possible to see the distinction between the categories.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}
}
\description{
The jitter geom is a convenient default for geom_point with position =
'jitter'. It's a useful way of handling overplotting caused by discreteness
in smaller datasets.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "point")}
}
\examples{
p <- ggplot(mpg, aes(cyl, hwy))
p + geom_point()
p + geom_jitter()

# Add aesthetic mappings
p + geom_jitter(aes(colour = class))

# Use smaller width/height to emphasise categories
ggplot(mpg, aes(cyl, hwy)) + geom_jitter()
ggplot(mpg, aes(cyl, hwy)) + geom_jitter(width = 0.25)

# Use larger width/height to completely smooth away discreteness
ggplot(mpg, aes(cty, hwy)) + geom_jitter()
ggplot(mpg, aes(cty, hwy)) + geom_jitter(width = 0.5, height = 0.5)
}
\seealso{
\code{\link{geom_point}} for regular, unjittered points,
 \code{\link{geom_boxplot}} for another way of looking at the conditional
    distribution of a variable
}

