% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsearch.R
\name{tsearch}
\alias{tsearch}
\title{Search for the enclosing Delaunay convex hull}
\usage{
tsearch(x, y, t, xi, yi, bary = FALSE, method = "quadtree")
}
\arguments{
\item{x}{X-coordinates of triangulation points}

\item{y}{Y-coordinates of triangulation points}

\item{t}{Triangulation, e.g. produced by \code{t <-
delaunayn(cbind(x, y))}}

\item{xi}{X-coordinates of points to test}

\item{yi}{Y-coordinates of points to test}

\item{bary}{If \code{TRUE} return barycentric coordinates as well
as index of triangle.}

\item{method}{One of \code{"quadtree"} or \code{"orig"}. The
Quadtree algorithm is much faster and new from version
0.4.0. The \code{orig} option uses the tsearch algorithm adapted
from Octave code. Its use is deprecated and it may be removed
from a future version of the package.}
}
\value{
If \code{bary} is \code{FALSE}, the index in \code{t} containing the points 
\code{(xi, yi)}.  For points outside the convex hull the index is \code{NA}. 
If \code{bary} is \code{TRUE}, a list containing: 
  \describe{
   \item{list("idx")}{the index in \code{t} containing the points \code{(xi, yi)}}
   \item{list("p")}{a 3-column matrix containing the barycentric coordinates with 
   respect to the enclosing triangle of each point \code{(xi, yi)}.}
  }
}
\description{
For \code{t <- delaunay(cbind(x, y))}, where \code{(x, y)} is a 2D set of
points, \code{tsearch(x, y, t, xi, yi)} finds the index in \code{t}
containing the points \code{(xi, yi)}.  For points outside the convex hull
the index is \code{NA}.
}
\note{
The original Octave function is Copyright (C) 2007-2012
  David Bateman
}
\seealso{
\code{\link{tsearchn}}, \code{\link{delaunayn}}
}
\author{
Jean-Romain Roussel (Quadtree algorithm), David Sterratt (Octave-based implementation)
}
