% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{decode_colour}
\alias{decode_colour}
\title{Decode RGB hex-strings into colour values}
\usage{
decode_colour(colour, alpha = FALSE, to = "rgb", white = "D65", na_value = NA)
}
\arguments{
\item{colour}{A character vector of hex-encoded values or a valid colour name
as given in \code{\link[grDevices:colors]{grDevices::colours()}}.}

\item{alpha}{If \code{TRUE} the alpha channel will be returned as well (scaled
between 0 and 1). If no alpha channel exists in the colour it will be
assumed 1. If \code{FALSE} any alpha channel is ignored.}

\item{to}{The output colour space. Allowed values are: \code{"cmy"},
\code{"cmyk"}, \code{"hsl"}, \code{"hsb"}, \code{"hsv"}, \code{"lab"} (CIE L*ab), \code{"hunterlab"}
(Hunter Lab), \code{"oklab"}, \code{"lch"} (CIE Lch(ab) / polarLAB), \code{"luv"},
\code{"rgb"} (sRGB), \code{"xyz"}, \code{"yxy"} (CIE xyY), \code{"hcl"} (CIE Lch(uv) / polarLuv),
or \code{"oklch"} (Polar form of oklab)}

\item{white}{The white reference of the output colour space. Will only have
an effect for relative colour spaces such as Lab and luv. Any value accepted
by \code{\link[=as_white_ref]{as_white_ref()}} allowed.}

\item{na_value}{A valid colour string or \code{NA} to use when \code{colour} contains
\code{NA} elements. The general approach in farver is to carry \code{NA} values over,
but if you want to mimick \code{\link[=col2rgb]{col2rgb()}} you should set
\code{na_value = 'transparent'}, i.e. treat \code{NA} as transparent white.}
}
\value{
A numeric matrix with a row for each element in \code{colour} and either
3, 4, or 5 columns depending on the value of \code{alpha} and \code{to}.
}
\description{
This is a version of \code{\link[grDevices:col2rgb]{grDevices::col2rgb()}} that returns the colour values in
the standard form expected by farver (matrix with a row per colour). As with
\code{\link[=encode_colour]{encode_colour()}} it can do colour conversion on the fly, meaning that you can
decode a hex string directly into any of the supported colour spaces.
}
\section{Handling of non-finite and out of bounds values}{

\code{NA}, \code{NaN}, \code{-Inf}, and \code{Inf} are treated as invalid input and will result
in \code{NA} values for the colour. If a given colourspace has finite bounds in
some of their channels, the input will be capped before conversion, and the
output will be capped before returning, so that both input and output colours
are valid colours in their respective space. This means that converting back
and forth between two colourspaces may result in a change in the colour if
the gamut of one of the spaces is less than the other.
}

\examples{
# basic use
decode_colour(c('#43e1f6', 'steelblue', '#67ce9fe4'))

# Return alpha as well (no alpha value is interpreted as 1)
decode_colour(c('#43e1f6', 'steelblue', '#67ce9fe4'), alpha = TRUE)

# Decode directly into specific colour space
decode_colour(c('#43e1f6', 'steelblue', '#67ce9fe4'), to = 'lch')

}
\seealso{
Other encoding and decoding functions: 
\code{\link{encode_colour}()},
\code{\link{manip_channel}}
}
\concept{encoding and decoding functions}
